/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.dsig.keyinfo;

import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import weblogic.xml.crypto.api.MarshalException;
import weblogic.xml.crypto.dsig.DsigConstants;
import weblogic.xml.crypto.dsig.KeyInfoObjectFactory;
import weblogic.xml.crypto.dsig.WLXMLStructure;
import weblogic.xml.crypto.dsig.keyinfo.DSAKeyValue;
import weblogic.xml.crypto.dsig.keyinfo.KeyInfoObjectBase;
import weblogic.xml.crypto.dsig.keyinfo.RSAKeyValue;
import weblogic.xml.crypto.utils.StaxUtils;

public class KeyValueImpl
extends KeyInfoObjectBase
implements KeyInfoObjectFactory {
    KeyValueImpl() {
    }

    public static void init() {
        KeyValueImpl keyValueImpl = new KeyValueImpl();
        KeyValueImpl.register(keyValueImpl);
    }

    protected PublicKey createFromKeySpec(String string, KeySpec keySpec) throws MarshalException {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(string);
            return keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            String string2 = string + " KeyFactory implementation not registered";
            throw new MarshalException(string2, noSuchAlgorithmException);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            String string3 = "Invalid key parameters";
            throw new MarshalException(string3, invalidKeySpecException);
        }
    }

    public QName getQName() {
        return DsigConstants.KEYVALUE_QNAME;
    }

    public Object newKeyInfoObject(XMLStreamReader xMLStreamReader) throws MarshalException {
        KeyValueImpl keyValueImpl = null;
        try {
            xMLStreamReader.nextTag();
            String string = xMLStreamReader.getLocalName();
            if ("DSAKeyValue".equals(string)) {
                keyValueImpl = new DSAKeyValue();
            } else if ("RSAKeyValue".equals(string)) {
                keyValueImpl = new RSAKeyValue();
            }
            ((WLXMLStructure)((Object)keyValueImpl)).read(xMLStreamReader);
            StaxUtils.forwardToEndElement("http://www.w3.org/2000/09/xmldsig#", "KeyValue", xMLStreamReader);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException("Failed to read KeyValue element.", xMLStreamException);
        }
        return keyValueImpl;
    }
}

