/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.dsig.keyinfo;

import java.security.KeyException;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import weblogic.xml.crypto.api.MarshalException;
import weblogic.xml.crypto.api.XMLStructure;
import weblogic.xml.crypto.dsig.WLXMLStructure;
import weblogic.xml.crypto.dsig.api.keyinfo.KeyValue;
import weblogic.xml.crypto.dsig.keyinfo.KeyValueImpl;
import weblogic.xml.crypto.utils.StaxUtils;
import weblogic.xml.security.utils.Utils;

public class RSAKeyValue
extends KeyValueImpl
implements KeyValue,
XMLStructure,
WLXMLStructure {
    public static final String RSAKEYVALUE_ELEMENT = "RSAKeyValue";
    private static final String MODULUS_ELEMENT = "Modulus";
    private static final String EXPONENT_ELEMENT = "Exponent";
    private static final String ALGORITHM_RSA = "RSA";
    private RSAPublicKey publicKey;
    private String modulus;
    private String exponent;

    RSAKeyValue() {
    }

    RSAKeyValue(RSAPublicKey rSAPublicKey) {
        this.publicKey = rSAPublicKey;
    }

    public PublicKey getPublicKey() throws KeyException {
        return this.publicKey;
    }

    public boolean isFeatureSupported(String string) {
        return false;
    }

    public void write(XMLStreamWriter xMLStreamWriter) throws MarshalException {
        try {
            xMLStreamWriter.writeStartElement("http://www.w3.org/2000/09/xmldsig#", "KeyValue");
            xMLStreamWriter.writeStartElement("http://www.w3.org/2000/09/xmldsig#", RSAKEYVALUE_ELEMENT);
            StaxUtils.writeElement(xMLStreamWriter, "http://www.w3.org/2000/09/xmldsig#", MODULUS_ELEMENT, Utils.toCryptoBinary(this.publicKey.getModulus()));
            StaxUtils.writeElement(xMLStreamWriter, "http://www.w3.org/2000/09/xmldsig#", EXPONENT_ELEMENT, Utils.toCryptoBinary(this.publicKey.getPublicExponent()));
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeEndElement();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException("Failed to write element KeyValue", xMLStreamException);
        }
    }

    public void read(XMLStreamReader xMLStreamReader) throws MarshalException {
        try {
            xMLStreamReader.nextTag();
            xMLStreamReader.require(1, "http://www.w3.org/2000/09/xmldsig#", MODULUS_ELEMENT);
            xMLStreamReader.next();
            this.modulus = xMLStreamReader.getText();
            StaxUtils.forwardToEndElement("http://www.w3.org/2000/09/xmldsig#", MODULUS_ELEMENT, xMLStreamReader);
            xMLStreamReader.nextTag();
            xMLStreamReader.require(1, "http://www.w3.org/2000/09/xmldsig#", EXPONENT_ELEMENT);
            xMLStreamReader.next();
            this.exponent = xMLStreamReader.getText();
            StaxUtils.forwardToEndElement("http://www.w3.org/2000/09/xmldsig#", RSAKEYVALUE_ELEMENT, xMLStreamReader);
            RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(Utils.fromCryptoBinary(this.modulus), Utils.fromCryptoBinary(this.exponent));
            this.publicKey = (RSAPublicKey)this.createFromKeySpec(ALGORITHM_RSA, rSAPublicKeySpec);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException("Failed to read RSAKeyValue element.", xMLStreamException);
        }
    }
}

