/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.dsig.keyinfo;

import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import weblogic.xml.crypto.api.Data;
import weblogic.xml.crypto.api.MarshalException;
import weblogic.xml.crypto.api.URIReferenceException;
import weblogic.xml.crypto.api.XMLCryptoContext;
import weblogic.xml.crypto.api.XMLStructure;
import weblogic.xml.crypto.dsig.DsigConstants;
import weblogic.xml.crypto.dsig.KeyInfoObjectFactory;
import weblogic.xml.crypto.dsig.TransformImpl;
import weblogic.xml.crypto.dsig.WLXMLStructure;
import weblogic.xml.crypto.dsig.api.keyinfo.RetrievalMethod;
import weblogic.xml.crypto.dsig.keyinfo.KeyInfoObjectBase;
import weblogic.xml.crypto.utils.StaxUtils;

public class RetrievalMethodImpl
extends KeyInfoObjectBase
implements RetrievalMethod,
XMLStructure,
WLXMLStructure,
KeyInfoObjectFactory {
    private static final String URI_ATTRIBUTE = "URI";
    private static final String TYPE_ATTRIBUTE = "Type";
    private static final String TRANSFORMS_ELEMENT = "Transforms";
    private String uri;
    private List transforms;
    private String type;

    RetrievalMethodImpl(String string, String string2, List list) {
        this.uri = string;
        this.type = string2;
        this.transforms = list;
    }

    public static void init() {
        RetrievalMethodImpl.register(new RetrievalMethodImpl(null, null, null));
    }

    public QName getQName() {
        return DsigConstants.RETRIEVALMETHOD_QNAME;
    }

    public Object newKeyInfoObject(XMLStreamReader xMLStreamReader) throws MarshalException {
        RetrievalMethodImpl retrievalMethodImpl = new RetrievalMethodImpl(null, null, null);
        retrievalMethodImpl.read(xMLStreamReader);
        return retrievalMethodImpl;
    }

    public boolean isFeatureSupported(String string) {
        return false;
    }

    public List getTransforms() {
        if (this.transforms != null) {
            return Collections.unmodifiableList(this.transforms);
        }
        return null;
    }

    public String getURI() {
        return this.uri;
    }

    public void write(XMLStreamWriter xMLStreamWriter) throws MarshalException {
        try {
            xMLStreamWriter.writeStartElement("http://www.w3.org/2000/09/xmldsig#", "RetrievalMethod");
            xMLStreamWriter.writeAttribute(URI_ATTRIBUTE, this.uri);
            if (this.type != null) {
                xMLStreamWriter.writeAttribute(TYPE_ATTRIBUTE, this.type);
            }
            if (this.transforms != null && !this.transforms.isEmpty()) {
                xMLStreamWriter.writeStartElement("http://www.w3.org/2000/09/xmldsig#", TRANSFORMS_ELEMENT);
                for (TransformImpl transformImpl : this.transforms) {
                    transformImpl.write(xMLStreamWriter);
                }
                xMLStreamWriter.writeEndElement();
            }
            xMLStreamWriter.writeEndElement();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException(xMLStreamException);
        }
    }

    public Data dereference(XMLCryptoContext xMLCryptoContext) throws URIReferenceException {
        return xMLCryptoContext.getURIDereferencer().dereference(this, xMLCryptoContext);
    }

    public void read(XMLStreamReader xMLStreamReader) throws MarshalException {
        try {
            xMLStreamReader.require(1, "http://www.w3.org/2000/09/xmldsig#", "RetrievalMethod");
            this.uri = xMLStreamReader.getAttributeValue(null, URI_ATTRIBUTE);
            this.type = xMLStreamReader.getAttributeValue(null, TYPE_ATTRIBUTE);
            int n = xMLStreamReader.nextTag();
            if (n == 1) {
                StaxUtils.readStart(xMLStreamReader, "http://www.w3.org/2000/09/xmldsig#", TRANSFORMS_ELEMENT);
                while (!xMLStreamReader.isEndElement()) {
                    TransformImpl.readTransform(xMLStreamReader);
                }
                StaxUtils.readEnd(xMLStreamReader, "http://www.w3.org/2000/09/xmldsig#", TRANSFORMS_ELEMENT);
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException(xMLStreamException);
        }
    }

    public String getType() {
        return this.type;
    }
}

