/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.dsig.keyinfo;

import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import weblogic.xml.crypto.api.MarshalException;
import weblogic.xml.crypto.dsig.DsigConstants;
import weblogic.xml.crypto.dsig.KeyInfoObjectFactory;
import weblogic.xml.crypto.dsig.WLXMLStructure;
import weblogic.xml.crypto.dsig.api.keyinfo.X509Data;
import weblogic.xml.crypto.dsig.api.keyinfo.X509IssuerSerial;
import weblogic.xml.crypto.dsig.keyinfo.KeyInfoObjectBase;
import weblogic.xml.crypto.dsig.keyinfo.X509IssuerSerialImpl;
import weblogic.xml.crypto.utils.CertUtils;
import weblogic.xml.crypto.utils.StaxUtils;
import weblogic.xml.security.utils.Utils;

public class X509DataImpl
extends KeyInfoObjectBase
implements X509Data,
WLXMLStructure,
KeyInfoObjectFactory {
    List content;

    public X509DataImpl(List list) {
        this.content = list;
    }

    private X509DataImpl() {
        this.content = new ArrayList();
    }

    public static void init() {
        X509DataImpl.register(new X509DataImpl());
    }

    public List getContent() {
        return this.content;
    }

    public boolean isFeatureSupported(String string) {
        return false;
    }

    public void write(XMLStreamWriter xMLStreamWriter) throws MarshalException {
        try {
            xMLStreamWriter.writeStartElement("http://www.w3.org/2000/09/xmldsig#", "X509Data");
            for (Object e : this.content) {
                if (e instanceof WLXMLStructure) {
                    ((WLXMLStructure)e).write(xMLStreamWriter);
                    continue;
                }
                if (e instanceof X509Certificate) {
                    this.writeCertificate(xMLStreamWriter, (X509Certificate)e);
                    continue;
                }
                if (e instanceof String) {
                    this.writeSubjectName(xMLStreamWriter, (String)e);
                    continue;
                }
                if (e instanceof byte[]) {
                    this.writeKeyIdentifier(xMLStreamWriter, (byte[])e);
                    continue;
                }
                if (e instanceof X509CRL) {
                    this.writeCRL(xMLStreamWriter, (X509CRL)e);
                    continue;
                }
                throw new MarshalException("Unsupported X509Data content object " + e);
            }
            xMLStreamWriter.writeEndElement();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException("Failed to write element X509Data", xMLStreamException);
        }
    }

    public void read(XMLStreamReader xMLStreamReader) throws MarshalException {
        try {
            xMLStreamReader.nextTag();
            while (!StaxUtils.is(xMLStreamReader, DsigConstants.X509DATA_QNAME)) {
                Object object = X509DataImpl.readContentElement(xMLStreamReader);
                this.content.add(object);
                if (xMLStreamReader.isStartElement() || xMLStreamReader.isEndElement()) continue;
                xMLStreamReader.nextTag();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException(xMLStreamException);
        }
    }

    private void writeCertificate(XMLStreamWriter xMLStreamWriter, X509Certificate x509Certificate) throws MarshalException {
        try {
            this.write(xMLStreamWriter, "X509Certificate", Utils.base64(x509Certificate.getEncoded()));
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new MarshalException("Failed to write X509Certificate", certificateEncodingException);
        }
    }

    private void writeSubjectName(XMLStreamWriter xMLStreamWriter, String string) throws MarshalException {
        this.write(xMLStreamWriter, "X509SubjectName", string);
    }

    private void writeKeyIdentifier(XMLStreamWriter xMLStreamWriter, byte[] byArray) throws MarshalException {
        this.write(xMLStreamWriter, "X509KeyIdentifier", Utils.base64(byArray));
    }

    private void writeCRL(XMLStreamWriter xMLStreamWriter, X509CRL x509CRL) throws MarshalException {
        try {
            this.write(xMLStreamWriter, "X509CRL", Utils.base64(x509CRL.getEncoded()));
        }
        catch (CRLException cRLException) {
            throw new MarshalException("Failed to write X509CRL", cRLException);
        }
    }

    private void write(XMLStreamWriter xMLStreamWriter, String string, String string2) throws MarshalException {
        try {
            StaxUtils.writeElement(xMLStreamWriter, "http://www.w3.org/2000/09/xmldsig#", string, string2);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException("Failed to write " + string, xMLStreamException);
        }
    }

    private static Object readContentElement(XMLStreamReader xMLStreamReader) throws MarshalException {
        String string = xMLStreamReader.getNamespaceURI();
        if (!"http://www.w3.org/2000/09/xmldsig#".equals(string)) {
            throw new MarshalException("Unsupported namespace for X509Data content element.");
        }
        String string2 = xMLStreamReader.getLocalName();
        if ("X509IssuerSerial".equals(string2)) {
            return X509DataImpl.readX509IssuerSerial(xMLStreamReader);
        }
        if ("X509Certificate".equals(string2)) {
            return X509DataImpl.readX509Certificate(xMLStreamReader);
        }
        if ("X509SubjectName".equals(string2)) {
            return X509DataImpl.readX509SubjectName(xMLStreamReader);
        }
        if ("X509KeyIdentifier".equals(string2)) {
            return X509DataImpl.readX509KeyIdentifier(xMLStreamReader);
        }
        if ("X509CRL".equals(string2)) {
            return X509DataImpl.readX509CRL(xMLStreamReader);
        }
        throw new MarshalException("Unsupported content element for X509Data: " + string2);
    }

    private static X509IssuerSerial readX509IssuerSerial(XMLStreamReader xMLStreamReader) throws MarshalException {
        X509IssuerSerialImpl x509IssuerSerialImpl = new X509IssuerSerialImpl();
        x509IssuerSerialImpl.read(xMLStreamReader);
        return x509IssuerSerialImpl;
    }

    private static X509Certificate readX509Certificate(XMLStreamReader xMLStreamReader) throws MarshalException {
        String string = X509DataImpl.read(xMLStreamReader, "X509Certificate");
        return CertUtils.getCertificate(Utils.base64(string));
    }

    private static String readX509SubjectName(XMLStreamReader xMLStreamReader) throws MarshalException {
        return X509DataImpl.read(xMLStreamReader, "X509SubjectName");
    }

    private static byte[] readX509KeyIdentifier(XMLStreamReader xMLStreamReader) throws MarshalException {
        String string = X509DataImpl.read(xMLStreamReader, "X509KeyIdentifier");
        return Utils.base64(string);
    }

    private static X509CRL readX509CRL(XMLStreamReader xMLStreamReader) throws MarshalException {
        String string = X509DataImpl.read(xMLStreamReader, "X509CRL");
        byte[] byArray = Utils.base64(string);
        return CertUtils.getCRL(byArray);
    }

    private static String read(XMLStreamReader xMLStreamReader, String string) throws MarshalException {
        try {
            return StaxUtils.readElement(xMLStreamReader, "http://www.w3.org/2000/09/xmldsig#", string);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException("Failed to read " + string, xMLStreamException);
        }
    }

    public QName getQName() {
        return DsigConstants.X509DATA_QNAME;
    }

    public Object newKeyInfoObject(XMLStreamReader xMLStreamReader) throws MarshalException {
        X509DataImpl x509DataImpl = new X509DataImpl();
        x509DataImpl.read(xMLStreamReader);
        return x509DataImpl;
    }
}

