/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.dsig.keyinfo;

import java.math.BigInteger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import weblogic.xml.crypto.api.MarshalException;
import weblogic.xml.crypto.dsig.WLXMLStructure;
import weblogic.xml.crypto.dsig.api.keyinfo.X509IssuerSerial;
import weblogic.xml.crypto.utils.StaxUtils;

public class X509IssuerSerialImpl
implements X509IssuerSerial,
WLXMLStructure {
    private String issuerName;
    private BigInteger serialNumber;

    public X509IssuerSerialImpl() {
    }

    public X509IssuerSerialImpl(String string, BigInteger bigInteger) {
        this.issuerName = string;
        this.serialNumber = bigInteger;
    }

    public String getIssuerName() {
        return this.issuerName;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public boolean isFeatureSupported(String string) {
        return false;
    }

    public void write(XMLStreamWriter xMLStreamWriter) throws MarshalException {
        try {
            xMLStreamWriter.writeStartElement("http://www.w3.org/2000/09/xmldsig#", "X509IssuerSerial");
            StaxUtils.writeElement(xMLStreamWriter, "http://www.w3.org/2000/09/xmldsig#", "X509IssuerName", this.issuerName);
            StaxUtils.writeElement(xMLStreamWriter, "http://www.w3.org/2000/09/xmldsig#", "X509SerialNumber", this.serialNumber.toString());
            xMLStreamWriter.writeEndElement();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException(xMLStreamException);
        }
    }

    public void read(XMLStreamReader xMLStreamReader, boolean bl) throws MarshalException {
        try {
            StaxUtils.readStart(xMLStreamReader, "http://www.w3.org/2000/09/xmldsig#", "X509IssuerSerial");
            this.issuerName = StaxUtils.readElement(xMLStreamReader, "http://www.w3.org/2000/09/xmldsig#", "X509IssuerName");
            String string = StaxUtils.readElement(xMLStreamReader, "http://www.w3.org/2000/09/xmldsig#", "X509SerialNumber");
            this.serialNumber = new BigInteger(string);
            if (bl) {
                StaxUtils.readEnd(xMLStreamReader, "http://www.w3.org/2000/09/xmldsig#", "X509IssuerSerial");
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException(xMLStreamException);
        }
    }

    public void read(XMLStreamReader xMLStreamReader) throws MarshalException {
        this.read(xMLStreamReader, true);
    }
}

