/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.encrypt;

import com.rsa.jsafe.JSAFE_AsymmetricCipher;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.JSAFE_SymmetricCipher;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.ShortBufferException;
import weblogic.kernel.Kernel;
import weblogic.xml.crypto.encrypt.api.XMLEncryptionException;

public abstract class CipherWrapper {
    public static final int DECRYPT = 2;
    public static final int ENCRYPT = 1;
    private static final SecureRandom rand = new SecureRandom();
    private static final String JSAFE_PROVIDER = "Java";
    private static Set jceFailures = Collections.synchronizedSet(new HashSet());

    public static CipherWrapper getInstance(String string, int n, Key key) throws XMLEncryptionException {
        return CipherWrapper.getInstance(string, n, key, null);
    }

    public static CipherWrapper getInstance(String string, int n, Key key, byte[] byArray) throws XMLEncryptionException {
        return new JSafeCipherWrapper(string, n, key, byArray);
    }

    public byte[] decrypt(byte[] byArray) throws XMLEncryptionException {
        return this.decrypt(byArray, 0, byArray.length);
    }

    public byte[] decrypt(byte[] byArray, int n, int n2) throws XMLEncryptionException {
        byte[] byArray2 = new byte[this.getOutputSize(n2)];
        int n3 = this.update(byArray, n, n2, byArray2, 0);
        if ((n3 += this.doFinal(byArray2, n3)) < byArray2.length) {
            byte[] byArray3 = new byte[n3];
            System.arraycopy(byArray2, 0, byArray3, 0, n3);
            byArray2 = byArray3;
        }
        return byArray2;
    }

    public byte[] encrypt(byte[] byArray) throws XMLEncryptionException {
        return this.doFinal(byArray);
    }

    public abstract int update(byte[] var1, int var2, int var3, byte[] var4, int var5) throws XMLEncryptionException;

    public abstract int doFinal(byte[] var1, int var2) throws XMLEncryptionException;

    public abstract byte[] doFinal() throws XMLEncryptionException;

    public abstract byte[] doFinal(byte[] var1) throws XMLEncryptionException;

    public abstract int getBlockSize();

    public abstract int getOutputSize(int var1);

    public abstract byte[] getIV() throws XMLEncryptionException;

    static {
        if (!Kernel.isServer() && Security.getProperty("com.rsa.crypto.default.random") == null && !Boolean.getBoolean("weblogic.security.allowCryptoJDefaultPRNG")) {
            Security.setProperty("com.rsa.crypto.default.random", "FIPS186PRNG");
        }
    }

    private static class JSafeCipherWrapper
    extends CipherWrapper {
        private JSAFE_SymmetricCipher symmetricCipher;
        private JSAFE_AsymmetricCipher asymmetricCipher;
        private final int mode;

        JSafeCipherWrapper(String string, int n, Key key, byte[] byArray) throws XMLEncryptionException {
            this.mode = n;
            this.init(string, key, byArray);
        }

        private void init(String string, Key key, byte[] byArray) throws XMLEncryptionException {
            try {
                if (key instanceof PrivateKey) {
                    if (this.mode != 2) {
                        throw new XMLEncryptionException("Invalid key for decryption");
                    }
                    this.asymmetricCipher = JSAFE_AsymmetricCipher.getInstance((String)string, (String)CipherWrapper.JSAFE_PROVIDER);
                    JSAFE_PrivateKey jSAFE_PrivateKey = JSAFE_PrivateKey.getInstance((byte[])key.getEncoded(), (int)0, (String)CipherWrapper.JSAFE_PROVIDER);
                    this.asymmetricCipher.decryptInit(jSAFE_PrivateKey);
                } else if (key instanceof PublicKey) {
                    if (this.mode != 1) {
                        throw new XMLEncryptionException("Invalid key for encryption");
                    }
                    this.asymmetricCipher = JSAFE_AsymmetricCipher.getInstance((String)string, (String)CipherWrapper.JSAFE_PROVIDER);
                    JSAFE_PublicKey jSAFE_PublicKey = JSAFE_PublicKey.getInstance((byte[])key.getEncoded(), (int)0, (String)CipherWrapper.JSAFE_PROVIDER);
                    this.asymmetricCipher.encryptInit(jSAFE_PublicKey, JSAFE_SecureRandom.getInstance((String)"FIPS186Random", (String)CipherWrapper.JSAFE_PROVIDER));
                } else {
                    int n = string.indexOf("/");
                    String string2 = n != -1 ? string.substring(0, n) : string;
                    JSAFE_SecretKey jSAFE_SecretKey = JSAFE_SecretKey.getInstance((String)string2, (String)CipherWrapper.JSAFE_PROVIDER);
                    byte[] byArray2 = key.getEncoded();
                    jSAFE_SecretKey.setSecretKeyData(byArray2, 0, byArray2.length);
                    this.symmetricCipher = JSAFE_SymmetricCipher.getInstance((String)string, (String)CipherWrapper.JSAFE_PROVIDER);
                    if (byArray != null) {
                        this.symmetricCipher.setIV(byArray, 0, byArray.length);
                    }
                    if (this.mode == 2) {
                        this.symmetricCipher.decryptInit(jSAFE_SecretKey);
                    } else {
                        this.symmetricCipher.encryptInit(jSAFE_SecretKey);
                    }
                }
            }
            catch (JSAFE_Exception jSAFE_Exception) {
                throw new XMLEncryptionException(jSAFE_Exception);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new XMLEncryptionException(noSuchAlgorithmException);
            }
        }

        public int update(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws XMLEncryptionException {
            try {
                if (this.symmetricCipher != null) {
                    if (this.mode == 2) {
                        return this.symmetricCipher.decryptUpdate(byArray, n, n2, byArray2, n3);
                    }
                    return this.symmetricCipher.encryptUpdate(byArray, n, n2, byArray2, n3);
                }
                if (this.mode == 2) {
                    return this.asymmetricCipher.decryptUpdate(byArray, n, n2, byArray2, n3);
                }
                return this.asymmetricCipher.encryptUpdate(byArray, n, n2, byArray2, n3);
            }
            catch (JSAFE_Exception jSAFE_Exception) {
                throw new XMLEncryptionException(jSAFE_Exception);
            }
        }

        public int doFinal(byte[] byArray, int n) throws XMLEncryptionException {
            try {
                if (this.symmetricCipher != null) {
                    if (this.mode == 2) {
                        return this.symmetricCipher.decryptFinal(byArray, n);
                    }
                    return this.symmetricCipher.encryptFinal(byArray, n);
                }
                if (this.mode == 2) {
                    return this.asymmetricCipher.decryptFinal(byArray, n);
                }
                return this.asymmetricCipher.encryptFinal(byArray, n);
            }
            catch (JSAFE_Exception jSAFE_Exception) {
                throw new XMLEncryptionException(jSAFE_Exception);
            }
        }

        public byte[] doFinal() throws XMLEncryptionException {
            try {
                if (this.symmetricCipher != null) {
                    if (this.mode == 2) {
                        return this.symmetricCipher.decryptFinal();
                    }
                    return this.symmetricCipher.encryptFinal();
                }
                if (this.mode == 2) {
                    return this.asymmetricCipher.decryptFinal();
                }
                return this.asymmetricCipher.encryptFinal();
            }
            catch (JSAFE_Exception jSAFE_Exception) {
                throw new XMLEncryptionException(jSAFE_Exception);
            }
        }

        public byte[] doFinal(byte[] byArray) throws XMLEncryptionException {
            byte[] byArray2;
            byte[] byArray3;
            try {
                if (this.symmetricCipher != null) {
                    if (this.mode == 2) {
                        byArray3 = this.symmetricCipher.decryptUpdate(byArray, 0, byArray.length);
                        byArray2 = this.symmetricCipher.decryptFinal();
                    } else {
                        byArray3 = this.symmetricCipher.encryptUpdate(byArray, 0, byArray.length);
                        byArray2 = this.symmetricCipher.encryptFinal();
                    }
                } else if (this.mode == 2) {
                    byArray3 = this.asymmetricCipher.decryptUpdate(byArray, 0, byArray.length);
                    byArray2 = this.asymmetricCipher.decryptFinal();
                } else {
                    byArray3 = this.asymmetricCipher.encryptUpdate(byArray, 0, byArray.length);
                    byArray2 = this.asymmetricCipher.encryptFinal();
                }
            }
            catch (JSAFE_Exception jSAFE_Exception) {
                throw new XMLEncryptionException(jSAFE_Exception);
            }
            byte[] byArray4 = new byte[byArray3.length + byArray2.length];
            System.arraycopy(byArray3, 0, byArray4, 0, byArray3.length);
            System.arraycopy(byArray2, 0, byArray4, byArray3.length, byArray2.length);
            return byArray4;
        }

        public int getBlockSize() {
            if (this.symmetricCipher != null) {
                return this.symmetricCipher.getBlockSize();
            }
            if (this.mode == 2) {
                return this.asymmetricCipher.getOutputBlockSize();
            }
            return this.asymmetricCipher.getInputBlockSize();
        }

        public int getOutputSize(int n) {
            int n2 = this.symmetricCipher != null ? this.symmetricCipher.getOutputBufferSize(n) : this.asymmetricCipher.getOutputBufferSize(n);
            return n2;
        }

        public byte[] getIV() throws XMLEncryptionException {
            if (this.symmetricCipher != null) {
                byte[] byArray = this.symmetricCipher.getIV();
                if (byArray == null) {
                    try {
                        this.symmetricCipher.generateIV(rand);
                    }
                    catch (JSAFE_Exception jSAFE_Exception) {
                        throw new XMLEncryptionException(jSAFE_Exception);
                    }
                    byArray = this.symmetricCipher.getIV();
                }
                return byArray;
            }
            return null;
        }
    }

    private static class JCECipherWrapper
    extends CipherWrapper {
        private final Cipher cipher;

        JCECipherWrapper(Cipher cipher) {
            this.cipher = cipher;
        }

        public int update(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws XMLEncryptionException {
            try {
                return this.cipher.update(byArray, n, n2, byArray2, n3);
            }
            catch (ShortBufferException shortBufferException) {
                throw new XMLEncryptionException(shortBufferException);
            }
        }

        public int doFinal(byte[] byArray, int n) throws XMLEncryptionException {
            try {
                return this.cipher.doFinal(byArray, n);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new XMLEncryptionException(generalSecurityException);
            }
        }

        public byte[] doFinal() throws XMLEncryptionException {
            try {
                return this.cipher.doFinal();
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new XMLEncryptionException(generalSecurityException);
            }
        }

        public byte[] doFinal(byte[] byArray) throws XMLEncryptionException {
            try {
                return this.cipher.doFinal(byArray);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new XMLEncryptionException(generalSecurityException);
            }
        }

        public int getBlockSize() {
            return this.cipher.getBlockSize();
        }

        public int getOutputSize(int n) {
            return this.cipher.getOutputSize(n);
        }

        public byte[] getIV() throws XMLEncryptionException {
            return this.cipher.getIV();
        }
    }
}

