/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.encrypt;

import java.io.IOException;
import java.io.OutputStream;
import weblogic.xml.crypto.encrypt.CipherWrapper;
import weblogic.xml.crypto.encrypt.api.XMLEncryptionException;

final class CipherWrapperOutputStream
extends OutputStream {
    private final OutputStream dest;
    private final int blockSize;
    private final CipherWrapper cipher;
    private boolean flushed = false;
    private byte[] buf;
    private int n = 0;

    CipherWrapperOutputStream(OutputStream outputStream, CipherWrapper cipherWrapper) {
        this.dest = outputStream;
        this.blockSize = cipherWrapper.getBlockSize();
        this.cipher = cipherWrapper;
        this.buf = null;
    }

    public void write(int n) throws IOException {
        this.dest.write(new byte[]{(byte)n});
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        int n3 = n2 % this.blockSize;
        if (n3 == 0 && this.buf == null) {
            this.encryptAndUpdate(byArray, n, n2);
        } else if (n3 != 0 && this.buf == null) {
            this.buf = new byte[n3];
            System.arraycopy(byArray, n2 - n3, this.buf, 0, n3);
            this.encryptAndUpdate(byArray, n, n2 - n3);
        } else if (this.buf.length + n2 > this.blockSize) {
            n3 = (this.buf.length + n2) % this.blockSize;
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, n2 - n3, byArray2, 0, n3);
            byte[] byArray3 = new byte[this.buf.length + n2 - n3];
            System.arraycopy(this.buf, 0, byArray3, 0, this.buf.length);
            System.arraycopy(byArray, n, byArray3, this.buf.length, byArray3.length - this.buf.length);
            this.buf = byArray2;
            this.encryptAndUpdate(byArray3, 0, byArray3.length);
        } else if (this.buf.length + n2 == this.blockSize) {
            byte[] byArray4 = new byte[this.blockSize];
            System.arraycopy(this.buf, 0, byArray4, 0, this.buf.length);
            System.arraycopy(byArray, n, byArray4, this.buf.length, n2);
            this.buf = null;
            this.encryptAndUpdate(byArray4, 0, this.blockSize);
        } else {
            byte[] byArray5 = new byte[this.buf.length + n2];
            System.arraycopy(this.buf, 0, byArray5, 0, this.buf.length);
            System.arraycopy(byArray, n, byArray5, this.buf.length, n2);
            this.buf = byArray5;
        }
    }

    public void flush() throws IOException {
        if (this.flushed) {
            return;
        }
        if (this.buf != null) {
            this.encryptAndUpdate(this.buf, 0, this.buf.length);
            this.buf = null;
        }
        int n = this.blockSize - this.n % this.blockSize;
        byte[] byArray = new byte[n];
        byArray[n - 1] = (byte)n;
        if (byArray.length < this.blockSize) {
            byte[] byArray2 = new byte[this.blockSize];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            byArray = byArray2;
        }
        this.encryptAndUpdate(byArray, 0, n);
        try {
            this.dest.write(this.cipher.doFinal());
        }
        catch (XMLEncryptionException xMLEncryptionException) {
            throw new IOException(xMLEncryptionException.getLocalizedMessage());
        }
        this.dest.flush();
        this.flushed = true;
    }

    public void close() throws IOException {
        if (!this.flushed) {
            this.flush();
        }
    }

    private void encryptAndUpdate(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        try {
            n3 = this.cipher.update(byArray, n, n2, byArray, n);
        }
        catch (XMLEncryptionException xMLEncryptionException) {
            throw new IOException(xMLEncryptionException.getLocalizedMessage());
        }
        this.dest.write(byArray, n, n3);
        this.n += n2;
    }
}

