/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.encrypt;

import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.stream.XMLStreamReader;
import weblogic.xml.crypto.encrypt.CipherWrapper;
import weblogic.xml.crypto.encrypt.CipherWrapperInputStream;
import weblogic.xml.crypto.encrypt.CipherWrapperOutputStream;
import weblogic.xml.crypto.encrypt.EncryptionAlgorithm;
import weblogic.xml.crypto.encrypt.KeyWrap;
import weblogic.xml.crypto.encrypt.Utils;
import weblogic.xml.crypto.encrypt.WLEncryptionMethod;
import weblogic.xml.crypto.encrypt.WLEncryptionMethodFactory;
import weblogic.xml.crypto.encrypt.api.XMLEncryptionException;

final class EncryptionAlgorithmAES
extends EncryptionAlgorithm
implements WLEncryptionMethodFactory {
    private static final String ALGORITHM_ID = "AES/CBC/NoPadding";
    private static final String KEY_FACTORY_ID = "AES";
    private static final int IV_LEN = 16;
    private int keyLen;

    private EncryptionAlgorithmAES(String string, int n) {
        super(string, null, null);
        this.keyLen = n;
    }

    private EncryptionAlgorithmAES(String string, Integer n, AlgorithmParameterSpec algorithmParameterSpec) {
        super(string, n, algorithmParameterSpec);
        this.keyLen = n;
    }

    static void init() {
        WLEncryptionMethod.register(new EncryptionAlgorithmAES("http://www.w3.org/2001/04/xmlenc#aes128-cbc", 16));
        WLEncryptionMethod.register(new EncryptionAlgorithmAES("http://www.w3.org/2001/04/xmlenc#aes192-cbc", 24));
        WLEncryptionMethod.register(new EncryptionAlgorithmAES("http://www.w3.org/2001/04/xmlenc#aes256-cbc", 32));
    }

    public InputStream decrypt(Key key, InputStream inputStream) throws XMLEncryptionException {
        byte[] byArray = new byte[16];
        Utils.readIV(inputStream, byArray);
        CipherWrapper cipherWrapper = CipherWrapper.getInstance(ALGORITHM_ID, 2, key, byArray);
        return new CipherWrapperInputStream(inputStream, cipherWrapper);
    }

    public OutputStream encrypt(Key key, OutputStream outputStream) throws XMLEncryptionException {
        CipherWrapper cipherWrapper = CipherWrapper.getInstance(ALGORITHM_ID, 1, key);
        Utils.writeIV(outputStream, cipherWrapper.getIV());
        return new CipherWrapperOutputStream(outputStream, cipherWrapper);
    }

    public Key createKey(byte[] byArray) {
        return new SecretKeySpec(byArray, KEY_FACTORY_ID);
    }

    public Key generateKey() {
        byte[] byArray = new byte[this.keyLen];
        rand.nextBytes(byArray);
        return this.createKey(byArray);
    }

    public Key generateKey(byte[] byArray, byte[] byArray2) throws XMLEncryptionException {
        try {
            byte[] byArray3 = Utils.P_SHA1(byArray, byArray2, this.keyLen);
            return this.createKey(byArray3);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new XMLEncryptionException("unable to generate key", noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLEncryptionException("unable to generate key", invalidKeyException);
        }
    }

    public EncryptionAlgorithm getEncryptionAlgorithm(AlgorithmParameterSpec algorithmParameterSpec, Integer n) {
        if (algorithmParameterSpec == null && n == null) {
            return this;
        }
        return new EncryptionAlgorithmAES(this.getAlgorithm(), n, algorithmParameterSpec);
    }

    public KeyWrap getKeyWrap(AlgorithmParameterSpec algorithmParameterSpec, Integer n) {
        throw new UnsupportedOperationException("Algorithm " + this.getAlgorithm() + " cannot be used for key wrapping");
    }

    public AlgorithmParameterSpec readParameters(XMLStreamReader xMLStreamReader) {
        return null;
    }

    public WLEncryptionMethod getEncryptionMethod(AlgorithmParameterSpec algorithmParameterSpec, Integer n) {
        return this.getEncryptionAlgorithm(algorithmParameterSpec, n);
    }
}

