/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.encrypt;

import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_SecretKey;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.xml.stream.XMLStreamReader;
import weblogic.xml.crypto.encrypt.CipherWrapper;
import weblogic.xml.crypto.encrypt.CipherWrapperInputStream;
import weblogic.xml.crypto.encrypt.CipherWrapperOutputStream;
import weblogic.xml.crypto.encrypt.EncryptionAlgorithm;
import weblogic.xml.crypto.encrypt.KeyWrap;
import weblogic.xml.crypto.encrypt.Utils;
import weblogic.xml.crypto.encrypt.WLEncryptionMethod;
import weblogic.xml.crypto.encrypt.WLEncryptionMethodFactory;
import weblogic.xml.crypto.encrypt.api.XMLEncryptionException;

final class EncryptionAlgorithmDES3
extends EncryptionAlgorithm
implements WLEncryptionMethodFactory {
    private static final String ALGORITHM_ID = "3DES_EDE/CBC/NoPad";
    private static final String KEY_FACTORY_ID = "DESEDE";
    private static final String JSAFE_KEY_FACTORY_ID = "3DES_EDE";
    private static final String JSAFE_PROVIDER = "Java";
    private static final int IV_LEN = 8;
    private static final int TRIPLE_DES_KEYLENGTH = 21;

    private EncryptionAlgorithmDES3(String string) {
        super(string, null, null);
    }

    private EncryptionAlgorithmDES3(String string, Integer n, AlgorithmParameterSpec algorithmParameterSpec) {
        super(string, n, algorithmParameterSpec);
    }

    public static void init() {
        WLEncryptionMethod.register(new EncryptionAlgorithmDES3("http://www.w3.org/2001/04/xmlenc#tripledes-cbc"));
    }

    public InputStream decrypt(Key key, InputStream inputStream) throws XMLEncryptionException {
        byte[] byArray = new byte[8];
        Utils.readIV(inputStream, byArray);
        CipherWrapper cipherWrapper = CipherWrapper.getInstance(ALGORITHM_ID, 2, key, byArray);
        return new CipherWrapperInputStream(inputStream, cipherWrapper);
    }

    public OutputStream encrypt(Key key, OutputStream outputStream) throws XMLEncryptionException {
        CipherWrapper cipherWrapper = CipherWrapper.getInstance(ALGORITHM_ID, 1, key);
        Utils.writeIV(outputStream, cipherWrapper.getIV());
        return new CipherWrapperOutputStream(outputStream, cipherWrapper);
    }

    public Key createKey(byte[] byArray) throws XMLEncryptionException {
        try {
            DESedeKeySpec dESedeKeySpec = new DESedeKeySpec(byArray);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(KEY_FACTORY_ID);
            return secretKeyFactory.generateSecret(dESedeKeySpec);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLEncryptionException("Invalid key supplied to " + this.getAlgorithm(), invalidKeyException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new XMLEncryptionException("Cannot locate JCE algorithm (DESEDE) necessary for generating a secret key for: " + this.getAlgorithm(), noSuchAlgorithmException);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new XMLEncryptionException("Unexpected exception when generating key for: " + this.getAlgorithm(), invalidKeySpecException);
        }
    }

    public Key generateKey() throws XMLEncryptionException {
        try {
            JSAFE_SecretKey jSAFE_SecretKey = JSAFE_SecretKey.getInstance((String)JSAFE_KEY_FACTORY_ID, (String)JSAFE_PROVIDER);
            jSAFE_SecretKey.generateInit(null, Utils.getRNG());
            jSAFE_SecretKey.generate();
            return this.createKey(jSAFE_SecretKey.getSecretKeyData());
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new XMLEncryptionException(jSAFE_Exception);
        }
    }

    public Key generateKey(byte[] byArray, byte[] byArray2) throws XMLEncryptionException {
        try {
            byte[] byArray3 = Utils.P_SHA1(byArray, byArray2, 21);
            byte[] byArray4 = Utils.tripleDESParity(byArray3);
            return this.createKey(byArray4);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new XMLEncryptionException("unable to generate key", noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLEncryptionException("unable to generate key", invalidKeyException);
        }
    }

    public WLEncryptionMethod getEncryptionMethod(AlgorithmParameterSpec algorithmParameterSpec, Integer n) {
        return this.getEncryptionAlgorithm(algorithmParameterSpec, n);
    }

    public KeyWrap getKeyWrap(AlgorithmParameterSpec algorithmParameterSpec, Integer n) {
        throw new UnsupportedOperationException("Algorithm " + this.getAlgorithm() + "does not support key wrapping");
    }

    public EncryptionAlgorithm getEncryptionAlgorithm(AlgorithmParameterSpec algorithmParameterSpec, Integer n) {
        if (algorithmParameterSpec == null && n == null) {
            return this;
        }
        return new EncryptionAlgorithmDES3(this.getAlgorithm(), n, algorithmParameterSpec);
    }

    public AlgorithmParameterSpec readParameters(XMLStreamReader xMLStreamReader) {
        return null;
    }
}

