/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.encrypt;

import java.io.InputStream;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.xml.stream.XMLStreamReader;
import weblogic.xml.crypto.encrypt.CipherWrapper;
import weblogic.xml.crypto.encrypt.EncryptionAlgorithm;
import weblogic.xml.crypto.encrypt.KeyWrap;
import weblogic.xml.crypto.encrypt.WLEncryptionMethod;
import weblogic.xml.crypto.encrypt.WLEncryptionMethodFactory;
import weblogic.xml.crypto.encrypt.api.XMLEncryptionException;

final class KeyWrapAES
extends KeyWrap
implements WLEncryptionMethodFactory {
    private static final String ALGORITHM_ID = "AES/ECB/NoPadding";
    private static final String KEY_FACTORY_ID = "AES";
    private static final int BLOCK_LEN = 8;
    private static final byte[] IV = new byte[]{-90, -90, -90, -90, -90, -90, -90, -90};

    private KeyWrapAES(String string) {
        super(string, null, null);
    }

    private KeyWrapAES(String string, AlgorithmParameterSpec algorithmParameterSpec, Integer n) {
        super(string, n, algorithmParameterSpec);
    }

    public static void init() {
        WLEncryptionMethod.register(new KeyWrapAES("http://www.w3.org/2001/04/xmlenc#kw-aes128"));
        WLEncryptionMethod.register(new KeyWrapAES("http://www.w3.org/2001/04/xmlenc#kw-aes192"));
        WLEncryptionMethod.register(new KeyWrapAES("http://www.w3.org/2001/04/xmlenc#kw-aes256"));
    }

    public InputStream decrypt(Key key, InputStream inputStream) {
        throw new AssertionError((Object)"NYI");
    }

    public byte[] decrypt(Key key, byte[] byArray) throws XMLEncryptionException {
        CipherWrapper cipherWrapper = CipherWrapper.getInstance(ALGORITHM_ID, 2, key);
        int n = byArray.length;
        if (n % 8 != 0) {
            throw new XMLEncryptionException("Invalid key passed to " + this.getAlgorithm() + " size=" + n * 8);
        }
        int n2 = (n >> 3) - 1;
        if (n2 < 2 || n2 > 4) {
            throw new AssertionError((Object)("Invalid key size: " + n2 * 8));
        }
        byte[] byArray2 = new byte[IV.length];
        byte[] byArray3 = new byte[n - IV.length];
        byte[] byArray4 = new byte[16];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        System.arraycopy(byArray, byArray2.length, byArray3, 0, byArray3.length);
        for (int i = 5; i >= 0; --i) {
            for (int j = n2; j >= 1; --j) {
                int n3 = j + i * n2;
                byArray2[7] = (byte)(byArray2[7] ^ n3);
                System.arraycopy(byArray2, 0, byArray4, 0, 8);
                System.arraycopy(byArray3, (j - 1) * 8, byArray4, 8, 8);
                cipherWrapper.update(byArray4, 0, byArray4.length, byArray4, 0);
                System.arraycopy(byArray4, 0, byArray2, 0, 8);
                System.arraycopy(byArray4, 8, byArray3, (j - 1) * 8, 8);
            }
        }
        if (!Arrays.equals(byArray2, IV)) {
            throw new XMLEncryptionException("Failed to decrypt key");
        }
        return byArray3;
    }

    public byte[] encrypt(Key key, byte[] byArray) throws XMLEncryptionException {
        CipherWrapper cipherWrapper = CipherWrapper.getInstance(ALGORITHM_ID, 1, key);
        int n = byArray.length;
        if (n % 8 != 0) {
            throw new XMLEncryptionException("Invalid key passed to " + this.getAlgorithm() + " size=" + n * 8);
        }
        int n2 = n >> 3;
        if (n2 < 2 || n2 > 4) {
            throw new AssertionError((Object)("Invalid key size: " + n2 * 8));
        }
        byte[] byArray2 = new byte[IV.length];
        System.arraycopy(IV, 0, byArray2, 0, IV.length);
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray, 0, byArray3, 0, n);
        byte[] byArray4 = new byte[16];
        for (int i = 0; i <= 5; ++i) {
            for (int j = 1; j <= n2; ++j) {
                int n3 = j + i * n2;
                System.arraycopy(byArray2, 0, byArray4, 0, byArray2.length);
                System.arraycopy(byArray3, (j - 1) * 8, byArray4, byArray2.length, 8);
                cipherWrapper.update(byArray4, 0, byArray4.length, byArray4, 0);
                System.arraycopy(byArray4, 0, byArray2, 0, 8);
                System.arraycopy(byArray4, 8, byArray3, (j - 1) * 8, 8);
                byArray2[7] = (byte)(byArray2[7] ^ n3);
            }
        }
        byte[] byArray5 = new byte[byArray2.length + byArray3.length];
        System.arraycopy(byArray2, 0, byArray5, 0, byArray2.length);
        System.arraycopy(byArray3, 0, byArray5, byArray2.length, byArray3.length);
        return byArray5;
    }

    public WLEncryptionMethod getEncryptionMethod(AlgorithmParameterSpec algorithmParameterSpec, Integer n) {
        return this.getKeyWrap(algorithmParameterSpec, n);
    }

    public KeyWrap getKeyWrap(AlgorithmParameterSpec algorithmParameterSpec, Integer n) {
        if (algorithmParameterSpec == null && n == null) {
            return this;
        }
        return new KeyWrapAES(this.getAlgorithm(), algorithmParameterSpec, n);
    }

    public EncryptionAlgorithm getEncryptionAlgorithm(AlgorithmParameterSpec algorithmParameterSpec, Integer n) {
        throw new UnsupportedOperationException("Algorithm " + this.getAlgorithm() + " cannot be used for bulk encryption");
    }

    public AlgorithmParameterSpec readParameters(XMLStreamReader xMLStreamReader) {
        return null;
    }
}

