/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.encrypt;

import java.security.Key;
import java.security.MessageDigest;
import java.security.spec.AlgorithmParameterSpec;
import javax.xml.stream.XMLStreamReader;
import weblogic.xml.crypto.encrypt.CipherWrapper;
import weblogic.xml.crypto.encrypt.EncryptionAlgorithm;
import weblogic.xml.crypto.encrypt.KeyWrap;
import weblogic.xml.crypto.encrypt.WLEncryptionMethod;
import weblogic.xml.crypto.encrypt.WLEncryptionMethodFactory;
import weblogic.xml.crypto.encrypt.api.XMLEncryptionException;
import weblogic.xml.security.signature.DigestMethod;
import weblogic.xml.security.utils.XMLSecurityException;

final class KeyWrapDES3
extends KeyWrap
implements WLEncryptionMethodFactory {
    private static final String ALGORITHM_ID = "3DES_EDE/CBC/NoPad";
    private static final String KEY_FACTORY_ID = "DESEDE";
    private static final byte[] IV = new byte[]{74, -35, -94, 44, 121, -24, 33, 5};

    private KeyWrapDES3() {
        super("http://www.w3.org/2001/04/xmlenc#kw-tripledes", null, null);
    }

    private KeyWrapDES3(Integer n, AlgorithmParameterSpec algorithmParameterSpec) {
        super("http://www.w3.org/2001/04/xmlenc#kw-tripledes", n, algorithmParameterSpec);
    }

    public static void init() {
        WLEncryptionMethod.register(new KeyWrapDES3());
    }

    public byte[] decrypt(Key key, byte[] byArray) throws XMLEncryptionException {
        CipherWrapper cipherWrapper = CipherWrapper.getInstance(ALGORITHM_ID, 2, key, IV);
        byte[] byArray2 = cipherWrapper.decrypt(byArray);
        this.reverse(byArray2);
        byte[] byArray3 = new byte[8];
        System.arraycopy(byArray2, 0, byArray3, 0, 8);
        cipherWrapper = CipherWrapper.getInstance(ALGORITHM_ID, 2, key, byArray3);
        byte[] byArray4 = cipherWrapper.decrypt(byArray2, 8, byArray2.length - 8);
        byte[] byArray5 = new byte[byArray4.length - 8];
        System.arraycopy(byArray4, 0, byArray5, 0, byArray5.length);
        DigestMethod digestMethod = KeyWrapDES3.getDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1");
        MessageDigest messageDigest = digestMethod.getMessageDigest();
        messageDigest.update(byArray5);
        byte[] byArray6 = messageDigest.digest();
        for (int i = 0; i < 8; ++i) {
            if (byArray4[byArray4.length - 8 + i] == byArray6[i]) continue;
            throw new XMLEncryptionException("Cannot decrypt key: bad CMS checksum");
        }
        return byArray5;
    }

    public byte[] encrypt(Key key, byte[] byArray) throws XMLEncryptionException {
        CipherWrapper cipherWrapper = CipherWrapper.getInstance(ALGORITHM_ID, 1, key);
        byte[] byArray2 = cipherWrapper.getIV();
        byte[] byArray3 = new byte[byArray.length + 8];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        DigestMethod digestMethod = KeyWrapDES3.getDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1");
        MessageDigest messageDigest = digestMethod.getMessageDigest();
        messageDigest.update(byArray);
        byte[] byArray4 = messageDigest.digest();
        System.arraycopy(byArray4, 0, byArray3, byArray.length, 8);
        byte[] byArray5 = cipherWrapper.encrypt(byArray3);
        byte[] byArray6 = new byte[byArray5.length + byArray2.length];
        System.arraycopy(byArray2, 0, byArray6, 0, byArray2.length);
        System.arraycopy(byArray5, 0, byArray6, byArray2.length, byArray5.length);
        this.reverse(byArray6);
        cipherWrapper = CipherWrapper.getInstance(ALGORITHM_ID, 1, key, IV);
        return cipherWrapper.encrypt(byArray6);
    }

    private final void reverse(byte[] byArray) {
        int n = byArray.length;
        int n2 = n / 2;
        for (int i = 0; i < n2; ++i) {
            int n3 = i;
            byArray[n3] = (byte)(byArray[n3] ^ byArray[n - 1 - i]);
            int n4 = n - 1 - i;
            byArray[n4] = (byte)(byArray[n4] ^ byArray[i]);
            int n5 = i;
            byArray[n5] = (byte)(byArray[n5] ^ byArray[n - 1 - i]);
        }
    }

    private static DigestMethod getDigestMethod(String string) throws XMLEncryptionException {
        try {
            return DigestMethod.get(string);
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new XMLEncryptionException("DigestMethod: " + string + " not available");
        }
    }

    public WLEncryptionMethod getEncryptionMethod(AlgorithmParameterSpec algorithmParameterSpec, Integer n) {
        return this.getKeyWrap(algorithmParameterSpec, n);
    }

    public KeyWrap getKeyWrap(AlgorithmParameterSpec algorithmParameterSpec, Integer n) {
        if (algorithmParameterSpec == null && n == null) {
            return this;
        }
        return new KeyWrapDES3(n, algorithmParameterSpec);
    }

    public EncryptionAlgorithm getEncryptionAlgorithm(AlgorithmParameterSpec algorithmParameterSpec, Integer n) {
        throw new UnsupportedOperationException("Algorithm " + this.getAlgorithm() + " cannot be used for bulk encryption");
    }

    public AlgorithmParameterSpec readParameters(XMLStreamReader xMLStreamReader) {
        return null;
    }
}

