/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.encrypt;

import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.xml.stream.XMLStreamReader;
import weblogic.xml.crypto.encrypt.CipherWrapper;
import weblogic.xml.crypto.encrypt.EncryptionAlgorithm;
import weblogic.xml.crypto.encrypt.KeyWrap;
import weblogic.xml.crypto.encrypt.WLEncryptionMethod;
import weblogic.xml.crypto.encrypt.WLEncryptionMethodFactory;
import weblogic.xml.crypto.encrypt.api.XMLEncryptionException;

final class KeyWrapRSA
extends KeyWrap
implements WLEncryptionMethodFactory {
    private static final String ALGORITHM_ID = "RSA";
    private static final String KEY_FACTORY_ID = "RSA";

    private KeyWrapRSA() {
        super("http://www.w3.org/2001/04/xmlenc#rsa-1_5", null, null);
    }

    private KeyWrapRSA(Integer n, AlgorithmParameterSpec algorithmParameterSpec) {
        super("http://www.w3.org/2001/04/xmlenc#rsa-1_5", n, algorithmParameterSpec);
    }

    public static void init() {
        WLEncryptionMethod.register(new KeyWrapRSA());
    }

    public byte[] decrypt(Key key, byte[] byArray) throws XMLEncryptionException {
        CipherWrapper cipherWrapper = CipherWrapper.getInstance("RSA", 2, key);
        return cipherWrapper.decrypt(byArray);
    }

    public byte[] encrypt(Key key, byte[] byArray) throws XMLEncryptionException {
        CipherWrapper cipherWrapper = CipherWrapper.getInstance("RSA", 1, key);
        return cipherWrapper.encrypt(byArray);
    }

    public WLEncryptionMethod getEncryptionMethod(AlgorithmParameterSpec algorithmParameterSpec, Integer n) {
        return this.getKeyWrap(algorithmParameterSpec, n);
    }

    public KeyWrap getKeyWrap(AlgorithmParameterSpec algorithmParameterSpec, Integer n) {
        if (algorithmParameterSpec == null && n == null) {
            return this;
        }
        return new KeyWrapRSA(n, algorithmParameterSpec);
    }

    public EncryptionAlgorithm getEncryptionAlgorithm(AlgorithmParameterSpec algorithmParameterSpec, Integer n) {
        throw new UnsupportedOperationException("Algorithm " + this.getAlgorithm() + " cannot be used for bulk encryption");
    }

    public AlgorithmParameterSpec readParameters(XMLStreamReader xMLStreamReader) {
        return null;
    }
}

