/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.encrypt;

import com.bea.security.utils.random.SecureRandomData;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import weblogic.xml.crypto.api.MarshalException;
import weblogic.xml.crypto.dsig.DigestMethodImpl;
import weblogic.xml.crypto.dsig.WLDigestMethod;
import weblogic.xml.crypto.dsig.WLXMLStructure;
import weblogic.xml.crypto.encrypt.CipherWrapper;
import weblogic.xml.crypto.encrypt.EncryptionAlgorithm;
import weblogic.xml.crypto.encrypt.KeyWrap;
import weblogic.xml.crypto.encrypt.Utils;
import weblogic.xml.crypto.encrypt.WLEncryptionMethod;
import weblogic.xml.crypto.encrypt.WLEncryptionMethodFactory;
import weblogic.xml.crypto.encrypt.api.XMLEncryptionException;
import weblogic.xml.crypto.encrypt.api.spec.RSAOAEPParameterSpec;
import weblogic.xml.crypto.utils.StaxUtils;

final class KeyWrapRSAOAEP
extends KeyWrap
implements WLEncryptionMethodFactory {
    private static final String ALGORITHM_ID = "RSA/NoPad";
    public static final String TAG_OAEP_PARAMS = "OAEPparams";
    private static final byte[] EMPTY_PARAMS = new byte[0];

    private KeyWrapRSAOAEP() {
        super("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", null, null);
    }

    private KeyWrapRSAOAEP(Integer n, AlgorithmParameterSpec algorithmParameterSpec) {
        super("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", n, algorithmParameterSpec);
    }

    public static void init() {
        WLEncryptionMethod.register(new KeyWrapRSAOAEP());
    }

    protected void writeParameters(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        Object object;
        byte[] byArray = KeyWrapRSAOAEP.getOAEPParams(this.getParams());
        if (byArray != null && byArray.length > 0) {
            object = Utils.base64(byArray);
            StaxUtils.writeElement(xMLStreamWriter, "http://www.w3.org/2001/04/xmlenc#", TAG_OAEP_PARAMS, (String)object);
        }
        try {
            object = KeyWrapRSAOAEP.getDigestMethod(this.getParams());
            ((WLXMLStructure)object).write(xMLStreamWriter);
        }
        catch (XMLEncryptionException xMLEncryptionException) {
            throw new XMLStreamException(xMLEncryptionException);
        }
        catch (MarshalException marshalException) {
            throw new XMLStreamException(marshalException);
        }
    }

    public static byte[] getOAEPParams(RSAOAEPParameterSpec rSAOAEPParameterSpec) {
        if (rSAOAEPParameterSpec == null) {
            return EMPTY_PARAMS;
        }
        byte[] byArray = rSAOAEPParameterSpec.getOAEPParams();
        return byArray != null ? byArray : EMPTY_PARAMS;
    }

    private RSAOAEPParameterSpec getParams() {
        return (RSAOAEPParameterSpec)this.params;
    }

    public WLEncryptionMethod getEncryptionMethod(AlgorithmParameterSpec algorithmParameterSpec, Integer n) {
        return this.getKeyWrap(algorithmParameterSpec, n);
    }

    public KeyWrap getKeyWrap(AlgorithmParameterSpec algorithmParameterSpec, Integer n) {
        if (algorithmParameterSpec == null && n == null) {
            return this;
        }
        return new KeyWrapRSAOAEP(n, algorithmParameterSpec);
    }

    public EncryptionAlgorithm getEncryptionAlgorithm(AlgorithmParameterSpec algorithmParameterSpec, Integer n) {
        throw new UnsupportedOperationException("Algorithm " + this.getAlgorithm() + " cannot be used for bulk encryption");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AlgorithmParameterSpec readParameters(XMLStreamReader xMLStreamReader) throws MarshalException {
        WLDigestMethod wLDigestMethod;
        byte[] byArray;
        String string;
        try {
            string = StaxUtils.getElementValue(xMLStreamReader, "http://www.w3.org/2001/04/xmlenc#", TAG_OAEP_PARAMS);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException(xMLStreamException);
        }
        byte[] byArray2 = byArray = string != null ? Utils.base64(string) : EMPTY_PARAMS;
        if (xMLStreamReader.isStartElement()) {
            String string2 = xMLStreamReader.getLocalName();
            if (!"DigestMethod".equals(string2)) throw new MarshalException("Unrecognized Element: " + string2);
            try {
                wLDigestMethod = DigestMethodImpl.newDigestMethod(xMLStreamReader);
                return new RSAOAEPParameterSpec(wLDigestMethod, byArray);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new MarshalException(noSuchAlgorithmException);
            }
            catch (MarshalException marshalException) {
                throw new MarshalException(marshalException);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new MarshalException(xMLStreamException);
            }
        } else {
            wLDigestMethod = null;
        }
        return new RSAOAEPParameterSpec(wLDigestMethod, byArray);
    }

    public byte[] decrypt(Key key, byte[] byArray) throws XMLEncryptionException {
        if (!(key instanceof RSAPrivateKey)) {
            throw new XMLEncryptionException("Invalid key supplied to: " + this.getAlgorithm() + ", expecting RSAPrivateKey");
        }
        RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)key;
        CipherWrapper cipherWrapper = CipherWrapper.getInstance(ALGORITHM_ID, 2, key);
        byte[] byArray2 = cipherWrapper.decrypt(byArray);
        int n = rSAPrivateKey.getModulus().bitLength() / 8;
        byte[] byArray3 = new byte[n - 1];
        int n2 = Math.min(byArray2.length, byArray3.length);
        int n3 = byArray2.length - n2;
        int n4 = byArray3.length - n2;
        System.arraycopy(byArray2, n3, byArray3, n4, n2);
        byArray2 = byArray3;
        WLDigestMethod wLDigestMethod = KeyWrapRSAOAEP.getDigestMethod(this.getParams());
        MessageDigest messageDigest = wLDigestMethod.getMessageDigest();
        return KeyWrapRSAOAEP.oaepDecode(messageDigest, byArray2, KeyWrapRSAOAEP.getOAEPParams(this.getParams()));
    }

    private static WLDigestMethod getDigestMethod(RSAOAEPParameterSpec rSAOAEPParameterSpec) throws XMLEncryptionException {
        if (rSAOAEPParameterSpec == null) {
            return KeyWrapRSAOAEP.getDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1");
        }
        WLDigestMethod wLDigestMethod = (WLDigestMethod)rSAOAEPParameterSpec.getDigestMethod();
        return wLDigestMethod != null ? wLDigestMethod : KeyWrapRSAOAEP.getDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1");
    }

    public byte[] encrypt(Key key, byte[] byArray) throws XMLEncryptionException {
        if (!(key instanceof RSAPublicKey)) {
            throw new XMLEncryptionException("Invalid key supplied to: " + this.getAlgorithm() + ", expecting RSAPublicKey");
        }
        RSAPublicKey rSAPublicKey = (RSAPublicKey)key;
        CipherWrapper cipherWrapper = CipherWrapper.getInstance(ALGORITHM_ID, 1, key);
        int n = rSAPublicKey.getModulus().bitLength() / 8;
        WLDigestMethod wLDigestMethod = KeyWrapRSAOAEP.getDigestMethod(this.getParams());
        MessageDigest messageDigest = wLDigestMethod.getMessageDigest();
        byte[] byArray2 = KeyWrapRSAOAEP.oaepEncode(messageDigest, byArray, KeyWrapRSAOAEP.getOAEPParams(this.getParams()), n - 1);
        byte[] byArray3 = new byte[byArray2.length + 1];
        System.arraycopy(byArray2, 0, byArray3, 1, byArray2.length);
        byArray2 = byArray3;
        return cipherWrapper.encrypt(byArray2);
    }

    static byte[] oaepDecode(MessageDigest messageDigest, byte[] byArray, byte[] byArray2) throws XMLEncryptionException {
        int n;
        int n2 = messageDigest.getDigestLength();
        if (byArray.length < 2 * n2 + 1) {
            throw new XMLEncryptionException("decoding error");
        }
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray, 0, byArray3, 0, n2);
        byte[] byArray4 = new byte[byArray.length - n2];
        System.arraycopy(byArray, n2, byArray4, 0, byArray.length - n2);
        byte[] byArray5 = new byte[n2];
        WLDigestMethod wLDigestMethod = KeyWrapRSAOAEP.getDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1");
        MessageDigest messageDigest2 = wLDigestMethod.getMessageDigest();
        KeyWrapRSAOAEP.mgf1(messageDigest2, byArray4, byArray5);
        for (int i = 0; i < n2; ++i) {
            int n3 = i;
            byArray3[n3] = (byte)(byArray3[n3] ^ byArray5[i]);
        }
        messageDigest2.reset();
        byte[] byArray6 = new byte[byArray.length - n2];
        KeyWrapRSAOAEP.mgf1(messageDigest2, byArray3, byArray6);
        for (int i = 0; i < byArray4.length; ++i) {
            int n4 = i;
            byArray4[n4] = (byte)(byArray4[n4] ^ byArray6[i]);
        }
        messageDigest.update(byArray2);
        byte[] byArray7 = messageDigest.digest();
        for (n = 0; n < byArray7.length; ++n) {
            if (byArray7[n] == byArray4[n]) continue;
            throw new XMLEncryptionException("decoding error");
        }
        n = -1;
        for (int i = n2; i < byArray4.length; ++i) {
            if (byArray4[i] != 1) continue;
            n = i + 1;
            break;
        }
        if (n == -1) {
            throw new XMLEncryptionException("decoding error");
        }
        byte[] byArray8 = new byte[byArray4.length - n];
        System.arraycopy(byArray4, n, byArray8, 0, byArray8.length);
        return byArray8;
    }

    static byte[] oaepEncode(MessageDigest messageDigest, byte[] byArray, byte[] byArray2, int n) throws XMLEncryptionException {
        int n2 = messageDigest.getDigestLength();
        if (byArray.length > n - 2 * n2 - 1) {
            throw new XMLEncryptionException("Export strength certificates not supported");
        }
        byte[] byArray3 = messageDigest.digest(byArray2);
        byte[] byArray4 = new byte[n - n2];
        System.arraycopy(byArray3, 0, byArray4, 0, n2);
        int n3 = byArray4.length - byArray.length;
        System.arraycopy(byArray, 0, byArray4, n3, byArray.length);
        byArray4[n3 - 1] = 1;
        byte[] byArray5 = SecureRandomData.getInstance().getRandomBytes(n2);
        byte[] byArray6 = new byte[byArray4.length];
        WLDigestMethod wLDigestMethod = KeyWrapRSAOAEP.getDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1");
        MessageDigest messageDigest2 = wLDigestMethod.getMessageDigest();
        KeyWrapRSAOAEP.mgf1(messageDigest2, byArray5, byArray6);
        for (int i = 0; i < byArray4.length; ++i) {
            int n4 = i;
            byArray6[n4] = (byte)(byArray6[n4] ^ byArray4[i]);
        }
        byte[] byArray7 = new byte[n2];
        messageDigest2.reset();
        KeyWrapRSAOAEP.mgf1(messageDigest2, byArray6, byArray7);
        for (int i = 0; i < byArray7.length; ++i) {
            int n5 = i;
            byArray7[n5] = (byte)(byArray7[n5] ^ byArray5[i]);
        }
        byte[] byArray8 = new byte[byArray7.length + byArray4.length];
        System.arraycopy(byArray7, 0, byArray8, 0, byArray7.length);
        System.arraycopy(byArray6, 0, byArray8, byArray7.length, byArray6.length);
        return byArray8;
    }

    static void mgf1(MessageDigest messageDigest, byte[] byArray, byte[] byArray2) {
        int n = byArray2.length;
        int n2 = messageDigest.getDigestLength();
        int n3 = 0;
        int n4 = n / n2 + (1 % n2 > 0 ? 1 : 0);
        for (int i = 0; i < n4; ++i) {
            messageDigest.update(byArray);
            messageDigest.update(KeyWrapRSAOAEP.i2osp(i));
            byte[] byArray3 = messageDigest.digest();
            int n5 = Math.min(n2, n - n3);
            System.arraycopy(byArray3, 0, byArray2, n3, n5);
            n3 += n5;
        }
    }

    private static WLDigestMethod getDigestMethod(String string) throws XMLEncryptionException {
        try {
            return DigestMethodImpl.newDigestMethod(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new XMLEncryptionException(noSuchAlgorithmException);
        }
    }

    static byte[] i2osp(int n) {
        byte[] byArray = new byte[]{(byte)(n >>> 24), (byte)(n >>> 16), (byte)(n >>> 8), (byte)(n >>> 0)};
        return byArray;
    }
}

