/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.encrypt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import weblogic.xml.crypto.api.MarshalException;
import weblogic.xml.crypto.api.XMLStructure;
import weblogic.xml.crypto.encrypt.WLReferenceType;
import weblogic.xml.crypto.encrypt.api.ReferenceType;
import weblogic.xml.crypto.utils.StaxUtils;

public class ReferenceList
implements XMLStructure {
    public static final String TAG_REFERENCE_LIST = "ReferenceList";
    private List references;

    public ReferenceList() {
    }

    public ReferenceList(List list) {
        this.references = list;
    }

    public List getReferences() {
        return this.references;
    }

    public static String toString(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ReferenceList:\n");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("  ").append(iterator.next()).append("\n");
        }
        return stringBuffer.toString();
    }

    public static List newInstance(XMLStreamReader xMLStreamReader) throws MarshalException {
        List list = ReferenceList.read(xMLStreamReader);
        return list;
    }

    public static void write(XMLStreamWriter xMLStreamWriter, List list) throws MarshalException {
        try {
            xMLStreamWriter.writeStartElement("http://www.w3.org/2001/04/xmlenc#", TAG_REFERENCE_LIST);
            for (WLReferenceType wLReferenceType : list) {
                wLReferenceType.write(xMLStreamWriter);
            }
            xMLStreamWriter.writeEndElement();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException(xMLStreamException);
        }
    }

    public static List read(XMLStreamReader xMLStreamReader, boolean bl) throws MarshalException {
        ArrayList<ReferenceType> arrayList = new ArrayList<ReferenceType>();
        try {
            if (StaxUtils.findStart(xMLStreamReader, "http://www.w3.org/2001/04/xmlenc#", TAG_REFERENCE_LIST, false)) {
                xMLStreamReader.next();
                while (!xMLStreamReader.isEndElement()) {
                    ReferenceType referenceType = WLReferenceType.newInstance(xMLStreamReader);
                    arrayList.add(referenceType);
                }
                if (bl) {
                    StaxUtils.readEnd(xMLStreamReader, "http://www.w3.org/2001/04/xmlenc#", TAG_REFERENCE_LIST);
                }
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException(xMLStreamException);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public static List read(XMLStreamReader xMLStreamReader) throws MarshalException {
        return ReferenceList.read(xMLStreamReader, true);
    }

    public static void main(String[] stringArray) throws Exception {
    }

    public boolean isFeatureSupported(String string) {
        return false;
    }
}

