/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.encrypt;

import java.io.InputStream;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import weblogic.xml.crypto.api.MarshalException;
import weblogic.xml.crypto.api.URIReferenceException;
import weblogic.xml.crypto.encrypt.WLCipherReference;
import weblogic.xml.crypto.encrypt.WLCipherValue;
import weblogic.xml.crypto.encrypt.api.CipherData;
import weblogic.xml.crypto.encrypt.api.XMLDecryptContext;
import weblogic.xml.crypto.encrypt.api.XMLEncryptionException;
import weblogic.xml.crypto.utils.StaxUtils;

public abstract class WLCipherData
implements CipherData {
    public static final String TAG_CIPHER_DATA = "CipherData";

    static WLCipherData newInstance() {
        return new WLCipherValue();
    }

    static WLCipherData newInstance(byte[] byArray) {
        return new WLCipherValue(byArray);
    }

    static WLCipherData newInstance(WLCipherReference wLCipherReference) {
        return wLCipherReference;
    }

    static WLCipherData newInstance(String string, List list) {
        return new WLCipherReference(string, list);
    }

    static WLCipherData newInstance(XMLStreamReader xMLStreamReader) throws MarshalException {
        WLCipherData wLCipherData;
        try {
            StaxUtils.readStart(xMLStreamReader, "http://www.w3.org/2001/04/xmlenc#", TAG_CIPHER_DATA);
            wLCipherData = WLCipherData.readDataSource(xMLStreamReader);
            StaxUtils.readEnd(xMLStreamReader, "http://www.w3.org/2001/04/xmlenc#", TAG_CIPHER_DATA);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException("Unable to read CipherData", xMLStreamException);
        }
        return wLCipherData;
    }

    public abstract void read(XMLStreamReader var1) throws MarshalException;

    public final void write(XMLStreamWriter xMLStreamWriter) throws MarshalException {
        try {
            xMLStreamWriter.writeStartElement("http://www.w3.org/2001/04/xmlenc#", TAG_CIPHER_DATA);
            this.writeDataSource(xMLStreamWriter);
            xMLStreamWriter.writeEndElement();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException("Unable to write CipherData", xMLStreamException);
        }
    }

    protected abstract void writeDataSource(XMLStreamWriter var1) throws MarshalException;

    private static WLCipherData readDataSource(XMLStreamReader xMLStreamReader) throws XMLStreamException, MarshalException {
        WLCipherData wLCipherData;
        if (StaxUtils.findStart(xMLStreamReader, "http://www.w3.org/2001/04/xmlenc#", "CipherValue")) {
            wLCipherData = new WLCipherValue();
        } else if (StaxUtils.findStart(xMLStreamReader, "http://www.w3.org/2001/04/xmlenc#", "CipherReference")) {
            wLCipherData = new WLCipherReference();
        } else {
            String string = xMLStreamReader.getLocalName();
            throw new MarshalException("Unknown child of CipherData: " + string);
        }
        ((WLCipherData)wLCipherData).read(xMLStreamReader);
        return wLCipherData;
    }

    public abstract InputStream getCipherText();

    public abstract byte[] getCipherBytes() throws XMLEncryptionException;

    public abstract void setCipherText(InputStream var1) throws XMLEncryptionException;

    public abstract void clear();

    public abstract InputStream getCipherTextInternal();

    public abstract InputStream getCipherTextInternal(XMLDecryptContext var1) throws URIReferenceException;
}

