/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.encrypt;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import weblogic.xml.crypto.api.Data;
import weblogic.xml.crypto.api.MarshalException;
import weblogic.xml.crypto.api.OctetStreamData;
import weblogic.xml.crypto.api.URIDereferencer;
import weblogic.xml.crypto.api.URIReference;
import weblogic.xml.crypto.api.URIReferenceException;
import weblogic.xml.crypto.dsig.TransformImpl;
import weblogic.xml.crypto.dsig.WLTransform;
import weblogic.xml.crypto.encrypt.WLCipherData;
import weblogic.xml.crypto.encrypt.WLURIReference;
import weblogic.xml.crypto.encrypt.api.CipherReference;
import weblogic.xml.crypto.encrypt.api.XMLDecryptContext;
import weblogic.xml.crypto.encrypt.api.XMLEncryptionException;
import weblogic.xml.crypto.utils.ByteVector;
import weblogic.xml.crypto.utils.StaxUtils;

public class WLCipherReference
extends WLCipherData
implements URIReference,
CipherReference {
    public static final String TAG_CIPHER_REFERENCE = "CipherReference";
    private WLURIReference uriRef;
    private InputStream cipherText;
    private List transforms;
    public static final String ATTR_URI = "URI";
    public static final String TAG_TRANSFORMS = "Transforms";

    WLCipherReference(String string, List list) {
        this.uriRef = new WLURIReference(string, null);
        this.transforms = list != null ? Collections.unmodifiableList(list) : list;
    }

    WLCipherReference() {
        this.uriRef = new WLURIReference(null, null);
    }

    public void setCipherText(InputStream inputStream) {
        this.cipherText = inputStream;
    }

    public void read(XMLStreamReader xMLStreamReader) throws MarshalException {
        try {
            StaxUtils.findStart(xMLStreamReader, "http://www.w3.org/2001/04/xmlenc#", TAG_CIPHER_REFERENCE, true);
            for (int i = 0; i < xMLStreamReader.getAttributeCount(); ++i) {
                String string;
                String string2 = xMLStreamReader.getAttributeNamespace(i);
                if (this.emptyNamespace(string2) || string2.equals("http://www.w3.org/2001/04/xmlenc#")) {
                    String string3 = xMLStreamReader.getAttributeLocalName(i);
                    string = xMLStreamReader.getAttributeValue(i);
                    if (!string3.equals(ATTR_URI)) {
                        throw new MarshalException("Unexpected attribute: " + string3);
                    }
                } else {
                    throw new MarshalException("XML Encryption does not allow non-native attributes: " + string2 + ":" + xMLStreamReader.getAttributeLocalName(i));
                }
                this.uriRef.setURI(string);
            }
            this.readTransforms(xMLStreamReader);
            StaxUtils.findEnd(xMLStreamReader, "http://www.w3.org/2001/04/xmlenc#", TAG_CIPHER_REFERENCE);
            xMLStreamReader.next();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException(xMLStreamException);
        }
    }

    private boolean emptyNamespace(String string) {
        return string == null || "".equals(string);
    }

    private void readTransforms(XMLStreamReader xMLStreamReader) throws MarshalException {
        boolean bl = false;
        try {
            bl = StaxUtils.findStart(xMLStreamReader, "http://www.w3.org/2001/04/xmlenc#", TAG_TRANSFORMS);
            if (bl) {
                this.transforms = new ArrayList();
                while ("http://www.w3.org/2000/09/xmldsig#".equals(xMLStreamReader.getNamespaceURI()) && "Transform".equals(xMLStreamReader.getLocalName())) {
                    this.transforms.add(TransformImpl.readTransform(xMLStreamReader));
                    xMLStreamReader.nextTag();
                }
                StaxUtils.findEnd(xMLStreamReader, "http://www.w3.org/2001/04/xmlenc#", TAG_TRANSFORMS);
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException(xMLStreamException);
        }
    }

    protected void writeDataSource(XMLStreamWriter xMLStreamWriter) throws MarshalException {
        try {
            xMLStreamWriter.writeStartElement("http://www.w3.org/2001/04/xmlenc#", TAG_CIPHER_REFERENCE);
            String string = this.uriRef.getURI();
            if (string != null) {
                xMLStreamWriter.writeAttribute(ATTR_URI, string);
            }
            this.writeTransforms(xMLStreamWriter);
            xMLStreamWriter.writeEndElement();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException(xMLStreamException);
        }
    }

    private void writeTransforms(XMLStreamWriter xMLStreamWriter) throws XMLStreamException, MarshalException {
        if (this.transforms != null && !this.transforms.isEmpty()) {
            xMLStreamWriter.writeStartElement("http://www.w3.org/2001/04/xmlenc#", TAG_TRANSFORMS);
            for (int i = 0; i < this.transforms.size(); ++i) {
                WLTransform wLTransform = (WLTransform)this.transforms.get(i);
                wLTransform.write(xMLStreamWriter);
            }
            xMLStreamWriter.writeEndElement();
        }
    }

    public InputStream getCipherTextInternal() {
        return this.cipherText;
    }

    public InputStream getCipherTextInternal(XMLDecryptContext xMLDecryptContext) throws URIReferenceException {
        URIDereferencer uRIDereferencer = xMLDecryptContext.getURIDereferencer();
        Data data = uRIDereferencer.dereference(this.uriRef, xMLDecryptContext);
        if (data instanceof OctetStreamData) {
            OctetStreamData octetStreamData = (OctetStreamData)data;
            return octetStreamData.getOctetStream();
        }
        throw new URIReferenceException("Unable to resolve reference to " + this.uriRef.getURI());
    }

    public InputStream getCipherText() {
        return this.getCipherTextInternal();
    }

    public byte[] getCipherBytes() throws XMLEncryptionException {
        InputStream inputStream = this.getCipherTextInternal();
        ByteVector byteVector = new ByteVector();
        try {
            byteVector.addElements(inputStream);
        }
        catch (IOException iOException) {
            throw new XMLEncryptionException(iOException);
        }
        return byteVector.minSizedElementArray();
    }

    public void clear() {
    }

    public boolean isFeatureSupported(String string) {
        return false;
    }

    public List getTransforms() {
        return this.transforms;
    }

    public String getType() {
        return this.uriRef.getType();
    }

    public String getURI() {
        return this.uriRef.getURI();
    }
}

