/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.encrypt;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import weblogic.utils.io.UnsyncByteArrayInputStream;
import weblogic.utils.io.UnsyncByteArrayOutputStream;
import weblogic.xml.crypto.api.MarshalException;
import weblogic.xml.crypto.encrypt.Utils;
import weblogic.xml.crypto.encrypt.WLCipherData;
import weblogic.xml.crypto.encrypt.api.CipherValue;
import weblogic.xml.crypto.encrypt.api.XMLDecryptContext;
import weblogic.xml.crypto.encrypt.api.XMLEncryptionException;
import weblogic.xml.crypto.utils.StaxUtils;

public class WLCipherValue
extends WLCipherData
implements CipherValue {
    private String cipherValue;
    public static final String TAG_CIPHER_VALUE = "CipherValue";

    WLCipherValue() {
    }

    WLCipherValue(byte[] byArray) {
        this.cipherValue = Utils.base64(byArray);
    }

    public InputStream getCipherTextInternal() {
        return new UnsyncByteArrayInputStream(this.getCipherBytes());
    }

    public InputStream getCipherTextInternal(XMLDecryptContext xMLDecryptContext) {
        return this.getCipherTextInternal();
    }

    public InputStream getCipherText() {
        throw new IllegalStateException("Cannot throw getCipherText on EncryptedData without CipherReference ");
    }

    public void setCipherText(InputStream inputStream) throws XMLEncryptionException {
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        int n = 0;
        try {
            while ((n = inputStream.read(byArray)) >= 0) {
                unsyncByteArrayOutputStream.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            throw new XMLEncryptionException(iOException);
        }
        this.setCipherBytes(unsyncByteArrayOutputStream.toByteArray());
    }

    public byte[] getCipherBytes() {
        if (this.cipherValue != null) {
            return Utils.base64(this.cipherValue);
        }
        return null;
    }

    public void setCipherBytes(byte[] byArray) {
        this.cipherValue = Utils.base64(byArray);
    }

    public void clear() {
    }

    public String toString() {
        return "CipherValue: " + this.cipherValue;
    }

    private String getCipherValue() {
        return this.cipherValue;
    }

    protected void writeDataSource(XMLStreamWriter xMLStreamWriter) throws MarshalException {
        try {
            String string = this.getCipherValue();
            StaxUtils.writeElement(xMLStreamWriter, "http://www.w3.org/2001/04/xmlenc#", TAG_CIPHER_VALUE, string);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException("Error writing CipherValue", xMLStreamException);
        }
    }

    public void read(XMLStreamReader xMLStreamReader) throws MarshalException {
        try {
            this.cipherValue = StaxUtils.readElement(xMLStreamReader, "http://www.w3.org/2001/04/xmlenc#", TAG_CIPHER_VALUE);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException("Error reading CipherValue", xMLStreamException);
        }
    }

    public boolean isFeatureSupported(String string) {
        return false;
    }

    public byte[] getValue() {
        return this.getCipherBytes();
    }
}

