/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.encrypt;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Node;
import weblogic.utils.io.UnsyncByteArrayOutputStream;
import weblogic.xml.crypto.api.KeySelector;
import weblogic.xml.crypto.api.MarshalException;
import weblogic.xml.crypto.api.URIReferenceException;
import weblogic.xml.crypto.dsig.api.keyinfo.KeyInfo;
import weblogic.xml.crypto.encrypt.EncryptionAlgorithm;
import weblogic.xml.crypto.encrypt.WLCipherData;
import weblogic.xml.crypto.encrypt.WLCipherReference;
import weblogic.xml.crypto.encrypt.WLEncryptedType;
import weblogic.xml.crypto.encrypt.WLEncryptionMethod;
import weblogic.xml.crypto.encrypt.api.CipherReference;
import weblogic.xml.crypto.encrypt.api.EncryptedData;
import weblogic.xml.crypto.encrypt.api.EncryptionMethod;
import weblogic.xml.crypto.encrypt.api.EncryptionProperties;
import weblogic.xml.crypto.encrypt.api.TBE;
import weblogic.xml.crypto.encrypt.api.TBEData;
import weblogic.xml.crypto.encrypt.api.TBEXML;
import weblogic.xml.crypto.encrypt.api.XMLDecryptContext;
import weblogic.xml.crypto.encrypt.api.XMLEncryptContext;
import weblogic.xml.crypto.encrypt.api.XMLEncryptionException;
import weblogic.xml.crypto.encrypt.api.dom.DOMDecryptContext;
import weblogic.xml.crypto.encrypt.api.dom.DOMTBEXML;
import weblogic.xml.crypto.utils.DOMUtils;
import weblogic.xml.crypto.utils.LogUtils;

public class WLEncryptedData
extends WLEncryptedType
implements EncryptedData {
    public static final String VERBOSE_PROPERTY = "weblogic.xml.crypto.encrypt.verbose";
    public static final boolean VERBOSE = Boolean.getBoolean("weblogic.xml.crypto.encrypt.verbose");
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final String TAG_ENCRYPTED_DATA = "EncryptedData";
    private EncryptionAlgorithm encryptionMethod;
    private TBE tbe;

    WLEncryptedData(TBE tBE, EncryptionMethod encryptionMethod, KeyInfo keyInfo, EncryptionProperties encryptionProperties, String string, CipherReference cipherReference) {
        super(keyInfo, encryptionProperties, string, (WLCipherReference)cipherReference);
        this.tbe = tBE;
        if (encryptionMethod instanceof EncryptionAlgorithm) {
            this.encryptionMethod = (EncryptionAlgorithm)encryptionMethod;
        }
    }

    WLEncryptedData() {
    }

    public boolean isFeatureSupported(String string) {
        return false;
    }

    public EncryptionMethod getEncryptionMethod() {
        return this.encryptionMethod;
    }

    protected void setEncryptionMethod(WLEncryptionMethod wLEncryptionMethod) throws XMLEncryptionException {
        if (!(wLEncryptionMethod instanceof EncryptionAlgorithm)) {
            throw new IllegalArgumentException("EncryptionMethod's algorithm (" + wLEncryptionMethod + ") cannot be used for data encryption.");
        }
        this.encryptionMethod = (EncryptionAlgorithm)wLEncryptionMethod;
    }

    public InputStream decrypt(XMLDecryptContext xMLDecryptContext) throws XMLEncryptionException {
        WLCipherData wLCipherData = (WLCipherData)this.getCipherData();
        try {
            return this.encryptionMethod.decrypt(this.getKey(KeySelector.Purpose.DECRYPT, xMLDecryptContext), wLCipherData.getCipherTextInternal(xMLDecryptContext));
        }
        catch (URIReferenceException uRIReferenceException) {
            throw new XMLEncryptionException(uRIReferenceException);
        }
    }

    public void decryptAndReplace(XMLDecryptContext xMLDecryptContext) throws XMLEncryptionException {
        BufferedInputStream bufferedInputStream;
        Object object;
        Object object2;
        if (!(xMLDecryptContext instanceof DOMDecryptContext)) {
            throw new IllegalArgumentException("decryptAndReplace() can only be used with DOMDecryptContext");
        }
        DOMDecryptContext dOMDecryptContext = (DOMDecryptContext)xMLDecryptContext;
        if (VERBOSE) {
            object2 = this.decrypt(xMLDecryptContext);
            int n = 8192;
            object = new byte[n];
            int n2 = 0;
            int n3 = 0;
            do {
                try {
                    n2 = n - n3 >= 1024 ? ((InputStream)object2).read((byte[])object, n3, 1024) : ((InputStream)object2).read((byte[])object, n3, n - n3);
                    n3 += n2;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            } while (n2 > -1 && n3 < n);
            if (n3 == -1) {
                LogUtils.logEncrypt("Partial Decrypted CipherData is empty String");
            } else {
                String string = new String((byte[])object, 0, n3);
                LogUtils.logEncrypt("Partial Decrypted CipherData is " + string);
            }
        }
        InputStream inputStream = this.decrypt(xMLDecryptContext);
        object2 = dOMDecryptContext.getNode();
        if (this.noEncryptedData((Node)object2, bufferedInputStream = new BufferedInputStream(inputStream))) {
            return;
        }
        try {
            object = this.getEncoding();
            if (object == null) {
                object = DEFAULT_ENCODING;
            }
            DOMUtils.replace((Node)object2, bufferedInputStream, (String)object);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new XMLEncryptionException(xMLStreamException);
        }
    }

    private boolean noEncryptedData(Node node, BufferedInputStream bufferedInputStream) throws XMLEncryptionException {
        bufferedInputStream.mark(1);
        try {
            if (bufferedInputStream.read() == -1) {
                node.getParentNode().removeChild(node);
                return true;
            }
            bufferedInputStream.reset();
        }
        catch (IOException iOException) {
            throw new XMLEncryptionException(iOException);
        }
        return false;
    }

    public void encrypt(XMLEncryptContext xMLEncryptContext) throws XMLEncryptionException, MarshalException {
        this.setEncoding(this.tbe.getEncoding());
        this.setMimeType(this.tbe.getMimeType());
        this.setType(this.tbe.getType());
        if (this.tbe == null) {
            throw new IllegalStateException("Cannot encrypt -- a plaintext source has not been provided");
        }
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        OutputStream outputStream = this.encryptionMethod.encrypt(this.getKey(KeySelector.Purpose.ENCRYPT, xMLEncryptContext), (OutputStream)unsyncByteArrayOutputStream);
        if (this.tbe instanceof TBEXML) {
            this.writeTBE((TBEXML)this.tbe, outputStream);
        } else if (this.tbe instanceof TBEData) {
            this.writeTBE((TBEData)this.tbe, outputStream);
        }
        try {
            outputStream.close();
        }
        catch (IOException iOException) {
            throw new XMLEncryptionException(iOException);
        }
        WLCipherData wLCipherData = (WLCipherData)this.getCipherData();
        wLCipherData.setCipherText(new ByteArrayInputStream(unsyncByteArrayOutputStream.toByteArray()));
        this.marshal(xMLEncryptContext);
        this.tbe = null;
    }

    private void writeTBE(TBEData tBEData, OutputStream outputStream) throws XMLEncryptionException {
        InputStream inputStream = tBEData.getInputStream();
        byte[] byArray = new byte[1024];
        int n = 0;
        try {
            while ((n = inputStream.read(byArray)) >= 0) {
                outputStream.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            throw new XMLEncryptionException(iOException);
        }
    }

    private void writeTBE(TBEXML tBEXML, OutputStream outputStream) throws XMLEncryptionException {
        block5: {
            try {
                DOMTBEXML dOMTBEXML = (DOMTBEXML)tBEXML;
                String string = dOMTBEXML.getType();
                if ("http://www.w3.org/2001/04/xmlenc#Element".equals(string)) {
                    DOMUtils.writeNode(dOMTBEXML.getNodeList().item(0), outputStream, this.getEncodingInternal());
                    break block5;
                }
                if ("http://www.w3.org/2001/04/xmlenc#Content".equals(string)) {
                    DOMUtils.writeNodeList(dOMTBEXML.getNodeList(), outputStream, this.getEncodingInternal());
                    break block5;
                }
                throw new XMLEncryptionException("Unrecognized Type " + this.tbe.getType() + " for TBE");
            }
            catch (XMLStreamException xMLStreamException) {
                throw new XMLEncryptionException(xMLStreamException);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new XMLEncryptionException(unsupportedEncodingException);
            }
        }
    }

    private String getEncodingInternal() {
        String string = this.getEncoding();
        if (string != null) {
            return string;
        }
        return DEFAULT_ENCODING;
    }

    public TBE getTBE() {
        return this.tbe;
    }

    WLEncryptionMethod getEncryptionMethodInternal() {
        return this.encryptionMethod;
    }

    public String getLocalName() {
        return TAG_ENCRYPTED_DATA;
    }

    public String getNamespace() {
        return "http://www.w3.org/2001/04/xmlenc#";
    }

    protected void readAttributes(XMLStreamReader xMLStreamReader) {
    }

    protected void readChildren(XMLStreamReader xMLStreamReader) {
    }

    protected void writeAttributes(XMLStreamWriter xMLStreamWriter) {
    }

    protected void writeChildren(XMLStreamWriter xMLStreamWriter) {
    }

    public String childrenToString() {
        return ", encryptionMethod=" + this.encryptionMethod;
    }
}

