/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.encrypt;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.Key;
import java.util.Collections;
import java.util.List;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import weblogic.xml.crypto.api.AlgorithmMethod;
import weblogic.xml.crypto.api.KeySelector;
import weblogic.xml.crypto.api.MarshalException;
import weblogic.xml.crypto.dsig.KeyInfoObjectFactory;
import weblogic.xml.crypto.dsig.api.keyinfo.KeyInfo;
import weblogic.xml.crypto.dsig.keyinfo.KeyInfoObjectBase;
import weblogic.xml.crypto.encrypt.EncryptionAlgorithm;
import weblogic.xml.crypto.encrypt.KeyWrap;
import weblogic.xml.crypto.encrypt.ReferenceList;
import weblogic.xml.crypto.encrypt.WLCipherData;
import weblogic.xml.crypto.encrypt.WLCipherReference;
import weblogic.xml.crypto.encrypt.WLEncryptedType;
import weblogic.xml.crypto.encrypt.WLEncryptionMethod;
import weblogic.xml.crypto.encrypt.api.CipherReference;
import weblogic.xml.crypto.encrypt.api.EncryptionMethod;
import weblogic.xml.crypto.encrypt.api.EncryptionProperties;
import weblogic.xml.crypto.encrypt.api.TBE;
import weblogic.xml.crypto.encrypt.api.TBEKey;
import weblogic.xml.crypto.encrypt.api.XMLDecryptContext;
import weblogic.xml.crypto.encrypt.api.XMLEncryptContext;
import weblogic.xml.crypto.encrypt.api.XMLEncryptionException;
import weblogic.xml.crypto.encrypt.api.keyinfo.EncryptedKey;
import weblogic.xml.crypto.utils.StaxUtils;

public class WLEncryptedKey
extends WLEncryptedType
implements EncryptedKey,
KeyInfoObjectFactory {
    public static final String TAG_ENCRYPTED_KEY = "EncryptedKey";
    public static final String TAG_CARRIED_KEY_NAME = "CarriedKeyName";
    public static final String ATTR_RECIPIENT = "Recipient";
    private List referenceList;
    private String recipient;
    private String carriedKeyName;
    private KeyWrap encryptionMethod;
    private TBEKey tbeKey;

    public WLEncryptedKey(TBEKey tBEKey, EncryptionMethod encryptionMethod, KeyInfo keyInfo, EncryptionProperties encryptionProperties, List list, String string, String string2, String string3, CipherReference cipherReference) {
        super(keyInfo, encryptionProperties, string, (WLCipherReference)cipherReference);
        this.tbeKey = tBEKey;
        if (!(encryptionMethod instanceof KeyWrap)) {
            throw new IllegalArgumentException("Provided EncryptionMethod (" + encryptionMethod.getAlgorithm() + ") is not a keywrap algorithm," + " as required.");
        }
        this.encryptionMethod = (KeyWrap)encryptionMethod;
        this.referenceList = Collections.unmodifiableList(list);
        this.carriedKeyName = string2;
        this.recipient = string3;
    }

    WLEncryptedKey() {
    }

    public TBE getTBE() {
        return this.tbeKey;
    }

    public EncryptionMethod getEncryptionMethod() {
        return this.encryptionMethod;
    }

    protected void setEncryptionMethod(WLEncryptionMethod wLEncryptionMethod) throws XMLEncryptionException {
        if (!(wLEncryptionMethod instanceof KeyWrap)) {
            throw new XMLEncryptionException(wLEncryptionMethod.getAlgorithm() + " cannot be used as a key wrap");
        }
        this.encryptionMethod = (KeyWrap)wLEncryptionMethod;
    }

    void setRecipient(String string) {
        this.recipient = string;
    }

    public String getRecipient() {
        return this.recipient;
    }

    void setCarriedKeyName(String string) {
        this.carriedKeyName = string;
    }

    public String getCarriedKeyName() {
        return this.carriedKeyName;
    }

    public List getReferenceList() {
        return this.referenceList;
    }

    void setReferenceList(List list) {
        this.referenceList = Collections.unmodifiableList(list);
    }

    public Key decryptKey(XMLDecryptContext xMLDecryptContext) throws XMLEncryptionException {
        return new SecretKeySpec(this.decryptBytes(xMLDecryptContext), null);
    }

    public Key decryptKey(XMLDecryptContext xMLDecryptContext, AlgorithmMethod algorithmMethod) throws XMLEncryptionException {
        if (!(algorithmMethod instanceof EncryptionAlgorithm)) {
            throw new XMLEncryptionException(algorithmMethod.getAlgorithm() + " cannot be used as a block cipher.");
        }
        byte[] byArray = this.decryptBytes(xMLDecryptContext);
        return ((EncryptionAlgorithm)algorithmMethod).createKey(byArray);
    }

    private byte[] decryptBytes(XMLDecryptContext xMLDecryptContext) throws XMLEncryptionException {
        Key key = this.getKey(KeySelector.Purpose.DECRYPT, xMLDecryptContext);
        if (key == null) {
            throw new XMLEncryptionException("Unable to select key from context");
        }
        WLCipherData wLCipherData = (WLCipherData)this.getCipherData();
        byte[] byArray = wLCipherData.getCipherBytes();
        byte[] byArray2 = this.encryptionMethod.decrypt(key, byArray);
        return byArray2;
    }

    public InputStream decrypt(XMLDecryptContext xMLDecryptContext) throws XMLEncryptionException {
        return new ByteArrayInputStream(this.decryptBytes(xMLDecryptContext));
    }

    public void encrypt(XMLEncryptContext xMLEncryptContext) throws XMLEncryptionException, MarshalException {
        Key key = this.getKey(KeySelector.Purpose.ENCRYPT, xMLEncryptContext);
        if (key == null) {
            throw new XMLEncryptionException("Unable to select key from context");
        }
        byte[] byArray = this.tbeKey.getKey().getEncoded();
        byte[] byArray2 = this.encryptionMethod.encrypt(key, byArray);
        WLCipherData wLCipherData = (WLCipherData)this.getCipherData();
        wLCipherData.setCipherText(new ByteArrayInputStream(byArray2));
        this.marshal(xMLEncryptContext);
        this.tbeKey = null;
    }

    public String getLocalName() {
        return TAG_ENCRYPTED_KEY;
    }

    public String getNamespace() {
        return "http://www.w3.org/2001/04/xmlenc#";
    }

    protected void readChildren(XMLStreamReader xMLStreamReader) throws MarshalException {
        try {
            this.referenceList = ReferenceList.read(xMLStreamReader);
            this.carriedKeyName = StaxUtils.getElementValue(xMLStreamReader, "http://www.w3.org/2001/04/xmlenc#", TAG_CARRIED_KEY_NAME);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException(xMLStreamException);
        }
    }

    protected void readAttributes(XMLStreamReader xMLStreamReader) {
        this.recipient = StaxUtils.getAttributeValue("http://www.w3.org/2001/04/xmlenc#", ATTR_RECIPIENT, xMLStreamReader);
    }

    protected void writeAttributes(XMLStreamWriter xMLStreamWriter) throws MarshalException {
        if (this.recipient != null) {
            try {
                xMLStreamWriter.writeAttribute(ATTR_RECIPIENT, this.recipient);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new MarshalException(xMLStreamException);
            }
        }
    }

    protected void writeChildren(XMLStreamWriter xMLStreamWriter) throws MarshalException {
        try {
            if (this.referenceList != null && this.referenceList.size() > 0) {
                ReferenceList.write(xMLStreamWriter, this.referenceList);
            }
            if (this.carriedKeyName != null) {
                xMLStreamWriter.writeStartElement(this.getNamespace(), TAG_CARRIED_KEY_NAME);
                xMLStreamWriter.writeCharacters(this.carriedKeyName);
                xMLStreamWriter.writeEndElement();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException(xMLStreamException);
        }
    }

    public String childrenToString() {
        return ", encryptionMethod=" + this.encryptionMethod + ", carriedKeyName='" + this.carriedKeyName + "'" + ", recipient='" + this.recipient + "'" + ", referenceList=" + this.referenceList;
    }

    public boolean isFeatureSupported(String string) {
        return false;
    }

    public static void init() {
        KeyInfoObjectBase.register(new WLEncryptedKey());
    }

    public QName getQName() {
        return new QName("http://www.w3.org/2001/04/xmlenc#", TAG_ENCRYPTED_KEY);
    }

    public Object newKeyInfoObject(XMLStreamReader xMLStreamReader) throws MarshalException {
        WLEncryptedKey wLEncryptedKey = new WLEncryptedKey();
        wLEncryptedKey.readKeyInfo(xMLStreamReader);
        return wLEncryptedKey;
    }
}

