/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.encrypt;

import java.io.InputStream;
import java.security.Key;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weblogic.xml.crypto.api.KeySelector;
import weblogic.xml.crypto.api.KeySelectorException;
import weblogic.xml.crypto.api.KeySelectorResult;
import weblogic.xml.crypto.api.MarshalException;
import weblogic.xml.crypto.api.XMLCryptoContext;
import weblogic.xml.crypto.dsig.WLXMLStructure;
import weblogic.xml.crypto.dsig.api.keyinfo.KeyInfo;
import weblogic.xml.crypto.dsig.keyinfo.KeyInfoImpl;
import weblogic.xml.crypto.encrypt.WLCipherData;
import weblogic.xml.crypto.encrypt.WLCipherReference;
import weblogic.xml.crypto.encrypt.WLEncryptedData;
import weblogic.xml.crypto.encrypt.WLEncryptedKey;
import weblogic.xml.crypto.encrypt.WLEncryptionMethod;
import weblogic.xml.crypto.encrypt.api.CipherData;
import weblogic.xml.crypto.encrypt.api.EncryptedType;
import weblogic.xml.crypto.encrypt.api.EncryptionMethod;
import weblogic.xml.crypto.encrypt.api.EncryptionProperties;
import weblogic.xml.crypto.encrypt.api.TBE;
import weblogic.xml.crypto.encrypt.api.XMLDecryptContext;
import weblogic.xml.crypto.encrypt.api.XMLEncryptContext;
import weblogic.xml.crypto.encrypt.api.XMLEncryptionException;
import weblogic.xml.crypto.encrypt.api.dom.DOMEncryptContext;
import weblogic.xml.crypto.encrypt.api.dom.DOMTBEXML;
import weblogic.xml.crypto.utils.StaxUtils;
import weblogic.xml.crypto.wss11.internal.WSS11Constants;
import weblogic.xml.dom.DOMStreamWriter;
import weblogic.xml.stax.ConfigurationContextBase;
import weblogic.xml.stax.OutputConfigurationContext;

public abstract class WLEncryptedType
implements WLXMLStructure,
EncryptedType {
    public static final String ATTR_ENCODING = "Encoding";
    public static final String ATTR_ID = "Id";
    public static final String ATTR_MIME_TYPE = "MimeType";
    public static final String ATTR_TYPE = "Type";
    public static final int TYPE_ELEMENT = 1;
    public static final int TYPE_CONTENT = 2;
    public static final int TYPE_OTHER = 3;
    private KeyInfo keyInfo;
    private WLCipherData cipherData;
    private EncryptionProperties encryptionProperties;
    private String id;
    private String type;
    private String mimeType;
    private String encoding;
    private static final String XMLDSIG_KEYINFO = "KeyInfo";
    private KeySelectorResult keyResult;
    protected static final OutputConfigurationContext WRITER_CONFIG_CTX = new OutputConfigurationContext();

    protected WLEncryptedType(KeyInfo keyInfo, EncryptionProperties encryptionProperties, String string, WLCipherReference wLCipherReference) {
        this.keyInfo = keyInfo;
        this.encryptionProperties = encryptionProperties;
        this.id = string;
        this.cipherData = wLCipherReference != null ? WLCipherData.newInstance(wLCipherReference) : WLCipherData.newInstance();
    }

    protected WLEncryptedType() {
    }

    public abstract String getLocalName();

    public abstract String getNamespace();

    protected abstract void readChildren(XMLStreamReader var1) throws MarshalException;

    protected abstract void readAttributes(XMLStreamReader var1) throws MarshalException;

    protected abstract void writeAttributes(XMLStreamWriter var1) throws MarshalException;

    protected abstract void writeChildren(XMLStreamWriter var1) throws MarshalException;

    protected abstract String childrenToString();

    public abstract EncryptionMethod getEncryptionMethod();

    protected abstract void setEncryptionMethod(WLEncryptionMethod var1) throws XMLEncryptionException;

    public InputStream getCipherText() {
        return this.cipherData.getCipherText();
    }

    public EncryptionProperties getEncryptionProperties() {
        return this.encryptionProperties;
    }

    public abstract TBE getTBE();

    public KeyInfo getKeyInfo() {
        return this.keyInfo;
    }

    public void setKeyInfo(KeyInfo keyInfo) {
        try {
            this.keyInfo = keyInfo;
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Unknown KeyInfo type " + keyInfo);
        }
    }

    public CipherData getCipherData() {
        return this.cipherData;
    }

    protected void setCipherData(WLCipherData wLCipherData) {
        this.cipherData = wLCipherData;
    }

    public void clear() {
        this.cipherData.clear();
    }

    protected void setEncryptionProperties(EncryptionProperties encryptionProperties) {
        this.encryptionProperties = encryptionProperties;
    }

    protected void setMimeType(String string) {
        this.mimeType = string;
    }

    protected void setEncoding(String string) {
        this.encoding = string;
    }

    public String getType() {
        return this.type;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getEncoding() {
        return this.encoding;
    }

    protected void setId(String string) {
        this.id = string;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        TBE tBE = this.getTBE();
        String string = "weblogic.xml.crypto.encrypt.api.EncryptedType{keyInfo=" + this.keyInfo + ", cipherData=" + this.cipherData + ", id='" + this.id + "'";
        string = tBE != null ? string + ", mimeType='" + this.getTBE().getMimeType() + "'" + ", encoding='" + this.getTBE().getEncoding() + "'" : string + ", mimeType='" + this.mimeType + "'" + ", encoding='" + this.encoding + "'";
        string = string + this.childrenToString() + "}";
        return string;
    }

    public void read(XMLStreamReader xMLStreamReader) throws MarshalException {
        this.readKeyInfo(xMLStreamReader);
        try {
            while (xMLStreamReader.hasNext() && !xMLStreamReader.isStartElement() && !xMLStreamReader.isEndElement()) {
                xMLStreamReader.next();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException(xMLStreamException);
        }
    }

    public void readKeyInfo(XMLStreamReader xMLStreamReader) throws MarshalException {
        try {
            StaxUtils.findStart(xMLStreamReader, "http://www.w3.org/2001/04/xmlenc#", this.getLocalName(), true);
            for (int i = 0; i < xMLStreamReader.getAttributeCount(); ++i) {
                String string = xMLStreamReader.getAttributeNamespace(i);
                if (string == null || string.length() == 0 || string.equals("http://www.w3.org/2001/04/xmlenc#")) {
                    String string2 = xMLStreamReader.getAttributeLocalName(i);
                    String string3 = xMLStreamReader.getAttributeValue(i);
                    if (ATTR_TYPE.equals(string2)) {
                        this.setType(string3);
                        continue;
                    }
                    if (ATTR_ID.equals(string2)) {
                        if (string == null && this.id != null) continue;
                        this.id = string3;
                        continue;
                    }
                    if (ATTR_MIME_TYPE.equals(string2)) {
                        this.mimeType = string3;
                        continue;
                    }
                    if (!ATTR_ENCODING.equals(string2)) continue;
                    this.encoding = string3;
                    continue;
                }
                throw new MarshalException("XML Encryption does not allow non-native attributes: " + string + ":" + xMLStreamReader.getAttributeLocalName(i));
            }
            this.readAttributes(xMLStreamReader);
            xMLStreamReader.next();
            if (StaxUtils.findStart(xMLStreamReader, "http://www.w3.org/2001/04/xmlenc#", "EncryptionMethod")) {
                try {
                    this.setEncryptionMethod(WLEncryptionMethod.newInstance(xMLStreamReader));
                }
                catch (XMLEncryptionException xMLEncryptionException) {
                    throw new MarshalException(xMLEncryptionException);
                }
            }
            if (StaxUtils.findStart(xMLStreamReader, "http://www.w3.org/2000/09/xmldsig#", XMLDSIG_KEYINFO)) {
                this.keyInfo = new KeyInfoImpl();
                ((KeyInfoImpl)this.keyInfo).read(xMLStreamReader);
                xMLStreamReader.nextTag();
            }
            this.cipherData = WLCipherData.newInstance(xMLStreamReader);
            this.readChildren(xMLStreamReader);
            StaxUtils.findEnd(xMLStreamReader, this.getNamespace(), this.getLocalName());
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException(xMLStreamException);
        }
    }

    protected void setType(String string) {
        this.type = string;
    }

    public void write(XMLStreamWriter xMLStreamWriter) throws MarshalException {
        try {
            Object object;
            String string;
            String string2;
            xMLStreamWriter.writeStartElement(this.getNamespace(), this.getLocalName());
            if (this.id != null) {
                xMLStreamWriter.writeAttribute(ATTR_ID, this.id);
            }
            if ((string2 = this.getType()) != null) {
                xMLStreamWriter.writeAttribute(ATTR_TYPE, string2);
            }
            if ((string = this.getMimeType()) != null) {
                xMLStreamWriter.writeAttribute(ATTR_MIME_TYPE, string);
            }
            if (!"http://www.w3.org/2001/04/xmlenc#Element".equals(string2) && !"http://www.w3.org/2001/04/xmlenc#Content".equals(string2)) {
                object = this.getEncoding();
                if (object != null) {
                    xMLStreamWriter.writeAttribute(ATTR_ENCODING, (String)object);
                }
                this.writeAttributes(xMLStreamWriter);
            }
            if ((object = (WLEncryptionMethod)this.getEncryptionMethod()) != null) {
                ((WLEncryptionMethod)object).write(xMLStreamWriter);
            }
            if (this.keyInfo != null) {
                ((KeyInfoImpl)this.keyInfo).write(xMLStreamWriter);
            }
            this.cipherData.write(xMLStreamWriter);
            this.writeChildren(xMLStreamWriter);
            xMLStreamWriter.writeEndElement();
            this.clear();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException(xMLStreamException);
        }
    }

    public abstract InputStream decrypt(XMLDecryptContext var1) throws XMLEncryptionException;

    public abstract void encrypt(XMLEncryptContext var1) throws XMLEncryptionException, MarshalException;

    protected Key getKey(KeySelector.Purpose purpose, XMLCryptoContext xMLCryptoContext) throws XMLEncryptionException {
        if (this.keyResult == null) {
            try {
                KeySelector keySelector = xMLCryptoContext.getKeySelector();
                if (keySelector == null) {
                    throw new XMLEncryptionException("No KeySelector available on context");
                }
                KeySelectorResult keySelectorResult = keySelector.select(this.getKeyInfo(), purpose, this.getEncryptionMethod(), xMLCryptoContext);
                if (keySelectorResult == null) {
                    throw new XMLEncryptionException("Unable to resolve encryption key for " + this);
                }
                this.keyResult = keySelectorResult;
                xMLCryptoContext.setProperty("weblogic.xml.crypto.ksr", keySelectorResult);
            }
            catch (KeySelectorException keySelectorException) {
                throw new XMLEncryptionException(keySelectorException);
            }
        }
        return this.keyResult.getKey();
    }

    public static EncryptedType newInstance(XMLStreamReader xMLStreamReader) throws MarshalException {
        int n = xMLStreamReader.getEventType();
        if (n != 1) {
            throw new MarshalException("Did not receive valid XML for an EncryptedType");
        }
        if (xMLStreamReader.getName().equals(WSS11Constants.ENC_HEADER_QNAME)) {
            try {
                do {
                    xMLStreamReader.nextTag();
                } while (xMLStreamReader.getEventType() != 1);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new MarshalException(xMLStreamException);
            }
        }
        String string = xMLStreamReader.getLocalName();
        String string2 = xMLStreamReader.getNamespaceURI();
        if (!string2.equals("http://www.w3.org/2001/04/xmlenc#")) {
            throw new MarshalException("Unsupported namespace (" + string2 + ") for EncryptedType");
        }
        if ("EncryptedData".equals(string)) {
            WLEncryptedData wLEncryptedData = new WLEncryptedData();
            wLEncryptedData.read(xMLStreamReader);
            return wLEncryptedData;
        }
        if ("EncryptedKey".equals(string)) {
            WLEncryptedKey wLEncryptedKey = new WLEncryptedKey();
            wLEncryptedKey.read(xMLStreamReader);
            return wLEncryptedKey;
        }
        throw new MarshalException("Unknown EncryptedType; " + string);
    }

    protected void marshal(XMLEncryptContext xMLEncryptContext) throws MarshalException {
        if (xMLEncryptContext instanceof DOMEncryptContext) {
            Object object;
            Object object2;
            List list;
            Node node;
            DOMEncryptContext dOMEncryptContext = (DOMEncryptContext)xMLEncryptContext;
            Node node2 = dOMEncryptContext.getParent();
            if (node2 != null) {
                node = dOMEncryptContext.getNextSibling();
                list = null;
            } else {
                try {
                    object2 = (DOMTBEXML)this.getTBE();
                    object = ((DOMTBEXML)object2).getNodeList();
                    list = WLEncryptedType.copyNodes((NodeList)object);
                    node2 = object.item(0).getParentNode();
                    node = object.item(object.getLength() - 1);
                }
                catch (ClassCastException classCastException) {
                    throw new MarshalException("Unable to identify destination for marhaling");
                }
            }
            object2 = node2.getOwnerDocument();
            object = new DOMStreamWriter((Document)object2, node2, node);
            object.setConfigurationContext((ConfigurationContextBase)WLEncryptedData.WRITER_CONFIG_CTX);
            this.write((XMLStreamWriter)object);
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    Node node3 = (Node)list.get(i);
                    node2.removeChild(node3);
                }
            }
        }
    }

    private static List copyNodes(NodeList nodeList) {
        ArrayList<Node> arrayList = new ArrayList<Node>(nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            arrayList.add(node);
        }
        return arrayList;
    }

    static {
        WRITER_CONFIG_CTX.setPrefixDefaulting(true);
    }
}

