/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.encrypt;

import java.security.spec.AlgorithmParameterSpec;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import weblogic.utils.collections.ConcurrentHashMap;
import weblogic.xml.crypto.api.MarshalException;
import weblogic.xml.crypto.dsig.WLXMLStructure;
import weblogic.xml.crypto.encrypt.EncryptionAlgorithm;
import weblogic.xml.crypto.encrypt.EncryptionAlgorithmAES;
import weblogic.xml.crypto.encrypt.EncryptionAlgorithmDES3;
import weblogic.xml.crypto.encrypt.KeyWrap;
import weblogic.xml.crypto.encrypt.KeyWrapAES;
import weblogic.xml.crypto.encrypt.KeyWrapDES3;
import weblogic.xml.crypto.encrypt.KeyWrapRSA;
import weblogic.xml.crypto.encrypt.KeyWrapRSAOAEP;
import weblogic.xml.crypto.encrypt.WLEncryptionMethodFactory;
import weblogic.xml.crypto.encrypt.api.EncryptionMethod;
import weblogic.xml.crypto.encrypt.api.XMLEncryptionException;
import weblogic.xml.crypto.utils.StaxUtils;

public abstract class WLEncryptionMethod
implements WLXMLStructure,
EncryptionMethod {
    public static final String TAG_ENCRYPTION_METHOD = "EncryptionMethod";
    public static final String TAG_KEY_SIZE = "KeySize";
    public static String ATTR_ALGORITHM = "Algorithm";
    private static final ConcurrentHashMap factories = new ConcurrentHashMap();
    private final String algorithm;
    private final Integer keySize;
    protected final AlgorithmParameterSpec params;

    protected WLEncryptionMethod(String string, Integer n, AlgorithmParameterSpec algorithmParameterSpec) {
        this.algorithm = string;
        this.keySize = n;
        this.params = algorithmParameterSpec;
    }

    protected static final void initFactories() {
        EncryptionAlgorithmDES3.init();
        EncryptionAlgorithmAES.init();
        KeyWrapDES3.init();
        KeyWrapAES.init();
        KeyWrapRSA.init();
        KeyWrapRSAOAEP.init();
    }

    public static void register(WLEncryptionMethodFactory wLEncryptionMethodFactory) {
        factories.put((Object)wLEncryptionMethodFactory.getAlgorithm(), (Object)wLEncryptionMethodFactory);
    }

    static WLEncryptionMethod get(String string, Integer n, AlgorithmParameterSpec algorithmParameterSpec) throws XMLEncryptionException {
        WLEncryptionMethodFactory wLEncryptionMethodFactory = WLEncryptionMethod.getFactory(string);
        return wLEncryptionMethodFactory.getEncryptionMethod(algorithmParameterSpec, n);
    }

    private static WLEncryptionMethodFactory getFactory(String string) throws XMLEncryptionException {
        WLEncryptionMethodFactory wLEncryptionMethodFactory = (WLEncryptionMethodFactory)factories.get((Object)string);
        if (wLEncryptionMethodFactory == null) {
            throw new XMLEncryptionException(string + " not supported");
        }
        return wLEncryptionMethodFactory;
    }

    static KeyWrap getKeyWrap(String string, AlgorithmParameterSpec algorithmParameterSpec, Integer n) throws XMLEncryptionException {
        WLEncryptionMethodFactory wLEncryptionMethodFactory = WLEncryptionMethod.getFactory(string);
        return wLEncryptionMethodFactory.getKeyWrap(algorithmParameterSpec, n);
    }

    static EncryptionAlgorithm getEncryptionAlgorithm(String string, AlgorithmParameterSpec algorithmParameterSpec, Integer n) throws XMLEncryptionException {
        WLEncryptionMethodFactory wLEncryptionMethodFactory = WLEncryptionMethod.getFactory(string);
        return wLEncryptionMethodFactory.getEncryptionAlgorithm(algorithmParameterSpec, n);
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final AlgorithmParameterSpec getParameterSpec() {
        return this.params;
    }

    public final Integer getKeySize() {
        return this.keySize;
    }

    public final void read(XMLStreamReader xMLStreamReader) {
        throw new UnsupportedOperationException("Use WLEncryptionMethod.newInstance() instead.");
    }

    public void write(XMLStreamWriter xMLStreamWriter) throws MarshalException {
        try {
            xMLStreamWriter.writeStartElement("http://www.w3.org/2001/04/xmlenc#", TAG_ENCRYPTION_METHOD);
            xMLStreamWriter.writeAttribute(ATTR_ALGORITHM, this.getAlgorithm());
            if (this.keySize != null) {
                StaxUtils.writeElement(xMLStreamWriter, "http://www.w3.org/2001/04/xmlenc#", TAG_KEY_SIZE, this.keySize.toString());
            }
            this.writeParameters(xMLStreamWriter);
            xMLStreamWriter.writeEndElement();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException("Problem writing EncryptionMethod", xMLStreamException);
        }
    }

    public static WLEncryptionMethod newInstance(XMLStreamReader xMLStreamReader) throws MarshalException {
        try {
            xMLStreamReader.require(1, "http://www.w3.org/2001/04/xmlenc#", TAG_ENCRYPTION_METHOD);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException("Error marshalling EncryptionMethod", xMLStreamException);
        }
        String string = StaxUtils.getAttributeValue("http://www.w3.org/2001/04/xmlenc#", ATTR_ALGORITHM, xMLStreamReader);
        if (string == null) {
            throw new MarshalException("EncryptionMethod did not contain required attribute, " + ATTR_ALGORITHM);
        }
        try {
            xMLStreamReader.next();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException(xMLStreamException);
        }
        try {
            WLEncryptionMethodFactory wLEncryptionMethodFactory = WLEncryptionMethod.getFactory(string);
            Integer n = WLEncryptionMethod.readKeySize(xMLStreamReader);
            AlgorithmParameterSpec algorithmParameterSpec = wLEncryptionMethodFactory.readParameters(xMLStreamReader);
            StaxUtils.readEnd(xMLStreamReader, "http://www.w3.org/2001/04/xmlenc#", TAG_ENCRYPTION_METHOD);
            return wLEncryptionMethodFactory.getEncryptionMethod(algorithmParameterSpec, n);
        }
        catch (XMLEncryptionException xMLEncryptionException) {
            throw new MarshalException(xMLEncryptionException);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException(xMLStreamException);
        }
    }

    private static Integer readKeySize(XMLStreamReader xMLStreamReader) throws MarshalException {
        Integer n;
        if (xMLStreamReader.isStartElement() && TAG_KEY_SIZE.equals(xMLStreamReader.getLocalName())) {
            String string;
            try {
                string = StaxUtils.readElement(xMLStreamReader, "http://www.w3.org/2001/04/xmlenc#", TAG_KEY_SIZE);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new MarshalException(xMLStreamException);
            }
            n = string != null ? new Integer(string) : null;
        } else {
            n = null;
        }
        return n;
    }

    public String toString() {
        String string = "EncryptionMethod: algorithm = " + this.getAlgorithm() + ";";
        if (this.keySize != null) {
            string = string + "KeySize = " + this.keySize + ";";
        }
        if (this.params != null) {
            string = string + "Parameters = " + this.params + ";";
        }
        return string;
    }

    AlgorithmParameterSpec readParameters(XMLStreamReader xMLStreamReader) throws MarshalException {
        return null;
    }

    protected void writeParameters(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
    }

    public boolean isFeatureSupported(String string) {
        return false;
    }

    static {
        WLEncryptionMethod.initFactories();
    }
}

