/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.encrypt;

import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import weblogic.xml.crypto.api.MarshalException;
import weblogic.xml.crypto.dsig.WLXMLStructure;
import weblogic.xml.crypto.encrypt.WLDataReference;
import weblogic.xml.crypto.encrypt.WLKeyReference;
import weblogic.xml.crypto.encrypt.WLURIReference;
import weblogic.xml.crypto.encrypt.api.ReferenceType;
import weblogic.xml.crypto.utils.StaxUtils;

public abstract class WLReferenceType
extends WLURIReference
implements WLXMLStructure,
ReferenceType {
    public static final String ATTR_URI = "URI";
    private List content;

    protected WLReferenceType() {
        this(null, null, null);
    }

    protected WLReferenceType(String string) {
        this(string, null, null);
    }

    protected WLReferenceType(String string, List list) {
        this(string, null, list);
    }

    protected WLReferenceType(String string, String string2, List list) {
        super(string, string2);
        this.content = list != null ? Collections.unmodifiableList(list) : null;
    }

    protected abstract String getLocalName();

    protected abstract String getNamespace();

    public String toString() {
        return this.getLocalName() + ":  URI=" + this.getURI();
    }

    public void write(XMLStreamWriter xMLStreamWriter) throws MarshalException {
        try {
            xMLStreamWriter.writeStartElement(this.getNamespace(), this.getLocalName());
            xMLStreamWriter.writeAttribute(ATTR_URI, this.getURI());
            this.writeChildren(xMLStreamWriter);
            xMLStreamWriter.writeEndElement();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException(xMLStreamException);
        }
    }

    protected void writeChildren(XMLStreamWriter xMLStreamWriter) {
    }

    public void read(XMLStreamReader xMLStreamReader) throws MarshalException {
        try {
            StaxUtils.findStart(xMLStreamReader, this.getNamespace(), this.getLocalName(), true);
            String string = StaxUtils.getAttributeValue("http://www.w3.org/2001/04/xmlenc#", ATTR_URI, xMLStreamReader);
            this.setURI(string);
            this.readChildren(xMLStreamReader);
            StaxUtils.skipChildren(xMLStreamReader);
            StaxUtils.readEnd(xMLStreamReader, this.getNamespace(), this.getLocalName());
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException(xMLStreamException);
        }
        if (this.getURI() == null) {
            throw new MarshalException(this.getLocalName() + " did not have required URI attribute");
        }
    }

    protected void readChildren(XMLStreamReader xMLStreamReader) {
    }

    static ReferenceType newInstance(XMLStreamReader xMLStreamReader) throws MarshalException {
        WLReferenceType wLReferenceType;
        try {
            if (StaxUtils.findStart(xMLStreamReader, "http://www.w3.org/2001/04/xmlenc#", "DataReference")) {
                wLReferenceType = new WLDataReference();
            } else if (StaxUtils.findStart(xMLStreamReader, "http://www.w3.org/2001/04/xmlenc#", "KeyReference")) {
                wLReferenceType = new WLKeyReference();
            } else {
                throw new MarshalException("found unknown Reference type");
            }
            wLReferenceType.read(xMLStreamReader);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException("failed to read reference", xMLStreamException);
        }
        return wLReferenceType;
    }

    public boolean isFeatureSupported(String string) {
        return false;
    }

    public List getContent() {
        return this.content;
    }
}

