/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.encrypt.api.dom;

import java.security.Key;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.xml.crypto.URIDereferenceUtils;
import weblogic.xml.crypto.api.KeySelector;
import weblogic.xml.crypto.api.URIDereferencer;
import weblogic.xml.crypto.api.dom.DOMIdMap;
import weblogic.xml.crypto.encrypt.api.XMLEncryptContext;
import weblogic.xml.crypto.encrypt.api.dom.DOMURIDerferencer;

public class DOMEncryptContext
implements DOMIdMap,
XMLEncryptContext {
    private String baseURI;
    private URIDereferencer dereferencer;
    private KeySelector keyselector;
    private final Map properties = new HashMap();
    private static final String DEFAULT_BASE_URI = "";
    private Node nextSibling;
    private Node parent;
    private static final String ID_QNAMES_PROPERTY = "weblogic.xml.crypto.idqnames";

    public DOMEncryptContext(Key key) {
        this(key, null);
    }

    public DOMEncryptContext(Key key, Node node) {
        this(key, node, null);
    }

    public DOMEncryptContext(Key key, Node node, Node node2) {
        if (key != null) {
            this.keyselector = KeySelector.singletonKeySelector(key);
        }
        this.baseURI = DEFAULT_BASE_URI;
        this.parent = node;
        this.nextSibling = node2;
        this.dereferencer = DOMURIDerferencer.getInstance();
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public KeySelector getKeySelector() {
        return this.keyselector;
    }

    public Object getProperty(String string) {
        return this.properties.get(string);
    }

    public URIDereferencer getURIDereferencer() {
        return this.dereferencer;
    }

    public void setBaseURI(String string) {
        this.baseURI = string;
    }

    public void setKeySelector(KeySelector keySelector) {
        this.keyselector = keySelector;
    }

    public Object setProperty(String string, Object object) {
        return this.properties.put(string, object);
    }

    public void setURIDereferencer(URIDereferencer uRIDereferencer) {
        this.dereferencer = uRIDereferencer;
    }

    public Element getElementById(String string) {
        Set set = (Set)this.getProperty(ID_QNAMES_PROPERTY);
        Element element = (Element)URIDereferenceUtils.findNodeById(string, set, this.parent);
        return element;
    }

    public void setIdAttributeNS(Element element, String string, String string2) {
    }

    public Node getNextSibling() {
        return this.nextSibling;
    }

    public Node getParent() {
        return this.parent;
    }

    public void setParent(Node node) {
        this.parent = node;
    }

    public void setNextSibling(Node node) {
        this.nextSibling = node;
    }
}

