/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.encrypt.api.dom;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import org.w3c.dom.Element;
import weblogic.xml.crypto.NodeSetDataImpl;
import weblogic.xml.crypto.api.Data;
import weblogic.xml.crypto.api.OctetStreamData;
import weblogic.xml.crypto.api.URIDereferencer;
import weblogic.xml.crypto.api.URIReference;
import weblogic.xml.crypto.api.URIReferenceException;
import weblogic.xml.crypto.api.XMLCryptoContext;
import weblogic.xml.crypto.api.dom.DOMIdMap;
import weblogic.xml.crypto.encrypt.api.dom.DOMDecryptContext;
import weblogic.xml.crypto.encrypt.api.dom.DOMEncryptContext;
import weblogic.xml.crypto.utils.DOMUtils;

public class DOMURIDerferencer
implements URIDereferencer {
    private String baseURI;

    public DOMURIDerferencer() {
        this(null);
    }

    public DOMURIDerferencer(String string) {
        this.baseURI = string;
    }

    public static DOMURIDerferencer getInstance() {
        return new DOMURIDerferencer();
    }

    public Data dereference(URIReference uRIReference, XMLCryptoContext xMLCryptoContext) throws URIReferenceException {
        DOMIdMap dOMIdMap;
        Object object;
        String string = uRIReference.getURI();
        if (xMLCryptoContext instanceof DOMEncryptContext) {
            object = (DOMEncryptContext)xMLCryptoContext;
            if (string == null || string.length() == 0) {
                Element element = ((DOMEncryptContext)object).getParent().getOwnerDocument().getDocumentElement();
                return new NodeSetDataImpl(DOMUtils.getNodeSet(element, false));
            }
            dOMIdMap = object;
        } else if (xMLCryptoContext instanceof DOMDecryptContext) {
            object = (DOMDecryptContext)xMLCryptoContext;
            dOMIdMap = object;
        } else {
            throw new IllegalArgumentException("This dereferencer depends on its parent context; it cannot be used with other contexts");
        }
        if (string.startsWith("#")) {
            object = dOMIdMap.getElementById(string.substring(1, string.length()));
            HashSet<Object> hashSet = new HashSet<Object>();
            hashSet.add(object);
            return new NodeSetDataImpl(hashSet);
        }
        try {
            object = new OctetStreamData(new URL(uRIReference.getURI()).openStream());
        }
        catch (MalformedURLException malformedURLException) {
            throw new URIReferenceException("Unsupported reference format.");
        }
        catch (IOException iOException) {
            throw new URIReferenceException("Failed to open stream to URI " + uRIReference.getURI() + ".");
        }
        return object;
    }
}

