/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.utils;

import java.io.Serializable;
import javax.xml.namespace.QName;
import org.w3c.dom.Node;

public final class AttrNodeAsHashKey
implements Serializable {
    private String id;
    private String name;
    private String namespaceURI;

    private AttrNodeAsHashKey() {
    }

    public static AttrNodeAsHashKey valueOf(Node node) {
        AttrNodeAsHashKey attrNodeAsHashKey = new AttrNodeAsHashKey();
        if (node == null) {
            return attrNodeAsHashKey;
        }
        String string = node.getLocalName();
        if (string == null) {
            string = node.getNodeName();
        }
        attrNodeAsHashKey.name = string;
        attrNodeAsHashKey.id = node.getNodeValue();
        attrNodeAsHashKey.namespaceURI = node.getNamespaceURI();
        return attrNodeAsHashKey;
    }

    public static AttrNodeAsHashKey valueOf(String string, QName qName) {
        AttrNodeAsHashKey attrNodeAsHashKey = new AttrNodeAsHashKey();
        attrNodeAsHashKey.id = string;
        if (qName != null) {
            attrNodeAsHashKey.name = qName.getLocalPart();
            attrNodeAsHashKey.namespaceURI = qName.getNamespaceURI();
        }
        return attrNodeAsHashKey;
    }

    private boolean compareStrings(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        return string != null && string.equals(string2);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof AttrNodeAsHashKey)) {
            return false;
        }
        AttrNodeAsHashKey attrNodeAsHashKey = (AttrNodeAsHashKey)object;
        return this.compareStrings(this.id, attrNodeAsHashKey.id) && this.compareStrings(this.name, attrNodeAsHashKey.name) && this.compareStrings(this.namespaceURI == null ? "" : this.namespaceURI, attrNodeAsHashKey.namespaceURI == null ? "" : attrNodeAsHashKey.namespaceURI);
    }

    public int hashCode() {
        return ((this.id == null ? "#&#" : this.id) + "&&&" + (this.name == null ? "#&#" : this.id) + "&&&" + (this.namespaceURI == null ? "" : this.namespaceURI)).hashCode();
    }
}

