/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.utils;

import java.io.IOException;
import java.io.InputStream;

public class ByteVector {
    byte[] array;
    int count;

    public ByteVector() {
        this(8);
    }

    public ByteVector(int n) {
        this.array = new byte[n];
        this.count = 0;
    }

    public int count() {
        return this.count;
    }

    public int size() {
        return this.count;
    }

    public void setCount(int n) {
        this.count = n;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public void addElements(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        int n = byArray.length;
        if (this.array == null || this.count + n >= this.array.length) {
            this.ensureCapacity(this.count + n);
        }
        System.arraycopy(byArray, 0, this.array, this.count, n);
        this.count += n;
    }

    public void addElements(InputStream inputStream) throws IOException {
        while (true) {
            int n;
            int n2;
            if (this.array.length < this.count + (n2 = inputStream.available())) {
                this.ensureCapacity(this.count + n2);
            }
            if (n2 == 0) {
                n2 = 1;
            }
            if ((n = inputStream.read(this.array, this.count, n2)) < 0) break;
            this.count += n;
        }
    }

    public byte[] elementArray() {
        return this.array;
    }

    public byte[] minSizedElementArray() {
        byte[] byArray = new byte[this.count];
        System.arraycopy(this.array, 0, byArray, 0, this.count);
        return byArray;
    }

    public void ensureCapacity(int n) {
        int n2;
        if (this.array == null) {
            this.array = new byte[8];
        }
        if (n < this.array.length) {
            return;
        }
        for (n2 = this.array.length < 8 ? 8 : this.array.length; n2 < n; n2 = 2 * n2) {
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this.array, 0, byArray, 0, this.count);
        this.array = byArray;
    }

    public int capacity() {
        if (this.array == null) {
            return 0;
        }
        return this.array.length;
    }

    public void removeAllElements() {
        this.count = 0;
    }
}

