/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import weblogic.xml.babel.baseparser.PrefixMapping;
import weblogic.xml.babel.baseparser.SymbolTable;
import weblogic.xml.babel.stream.XMLWriter;
import weblogic.xml.crypto.dsig.DsigConstants;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.ChangePrefixMapping;
import weblogic.xml.stream.CharacterData;
import weblogic.xml.stream.ElementFactory;
import weblogic.xml.stream.EndDocument;
import weblogic.xml.stream.EndElement;
import weblogic.xml.stream.EndPrefixMapping;
import weblogic.xml.stream.ProcessingInstruction;
import weblogic.xml.stream.Space;
import weblogic.xml.stream.StartDocument;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.StartPrefixMapping;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLStreamException;
import weblogic.xml.stream.events.AttributeImpl;
import weblogic.xml.stream.events.ChangePrefixMappingEvent;
import weblogic.xml.stream.events.CharacterDataEvent;
import weblogic.xml.stream.events.CommentEvent;
import weblogic.xml.stream.events.EndDocumentEvent;
import weblogic.xml.stream.events.EndElementEvent;
import weblogic.xml.stream.events.EndPrefixMappingEvent;
import weblogic.xml.stream.events.Name;
import weblogic.xml.stream.events.ProcessingInstructionEvent;
import weblogic.xml.stream.events.SpaceEvent;
import weblogic.xml.stream.events.StartDocumentEvent;
import weblogic.xml.stream.events.StartElementEvent;
import weblogic.xml.stream.events.StartPrefixMappingEvent;

public class C14NDOMAdapter {
    private static final String PREFIX_SEP = ":";
    private static final String EMPTY_STRING = "";
    private static final String NEW_LINE = "\n";
    private XMLWriter writer;
    private SymbolTable nameSpaceTable = new SymbolTable();
    private StartElementEvent currentStartElement;
    private List nonVisiblyUsed = new ArrayList();
    private Map externalNamespaces;

    public C14NDOMAdapter(XMLWriter xMLWriter, Map map) {
        this.writer = xMLWriter;
        this.externalNamespaces = map;
    }

    public String[] getNonVisiblyUsed() {
        String[] stringArray = new String[this.nonVisiblyUsed.size()];
        this.nonVisiblyUsed.toArray(stringArray);
        return stringArray;
    }

    public void adaptNodeStart(Node node) throws XMLStreamException {
        this.adapt(node, true);
    }

    public void adaptNodeEnd(Node node) throws XMLStreamException {
        this.adapt(node, false);
    }

    private void writeCurrentStartElement() throws XMLStreamException {
        if (this.currentStartElement != null) {
            this.writer.write((StartElement)this.currentStartElement);
            this.currentStartElement = null;
        }
    }

    private void setCurrentStartElement(StartElementEvent startElementEvent) {
        this.currentStartElement = startElementEvent;
    }

    public void adapt(Node node, boolean bl) throws XMLStreamException {
        String string = node.getLocalName();
        if (string == null) {
            string = node.getNodeName();
        }
        switch (node.getNodeType()) {
            case 9: {
                Document document = (Document)node;
                this.adaptDocument(document, bl);
                break;
            }
            case 1: {
                this.adaptElement(node, bl);
                break;
            }
            case 3: {
                if (!bl) break;
                this.adaptText(node);
                break;
            }
            case 4: {
                if (!bl) break;
                this.adaptCDATA(node);
                break;
            }
            case 7: {
                if (!bl) break;
                this.adaptProcessingInstruction((org.w3c.dom.ProcessingInstruction)node);
                break;
            }
            case 8: {
                if (!bl) break;
                this.adaptComment((Comment)node);
                break;
            }
            case 10: {
                break;
            }
            case 2: {
                if (!bl) break;
                this.adaptAttribute(node);
                break;
            }
            default: {
                throw new XMLStreamException("Unknown DOM Node Type");
            }
        }
    }

    public void adaptDocument(Document document, boolean bl) throws XMLStreamException {
        if (bl) {
            this.writer.write((StartDocument)new StartDocumentEvent());
        } else {
            this.writer.write((EndDocument)new EndDocumentEvent());
        }
    }

    private void adaptNamespace(StartElementEvent startElementEvent, String string, String string2) throws XMLStreamException {
        Attribute attribute = ElementFactory.createNamespaceAttribute((String)string, (String)string2);
        startElementEvent.addNamespace(attribute);
        if (string == null) {
            string = EMPTY_STRING;
        }
        this.nameSpaceTable.put(string, string2);
        this.writer.write((StartPrefixMapping)new StartPrefixMappingEvent(string, string2));
    }

    public void adaptAttribute(Node node) throws XMLStreamException {
        String string;
        String string2 = node.getLocalName();
        if (string2 == null) {
            string2 = node.getNodeName();
        }
        if (string2 == null) {
            throw new XMLStreamException("The local name of an attribute cannot be null");
        }
        if (string2.equals("xmlns")) {
            this.adaptNamespace(this.currentStartElement, null, node.getNodeValue());
            return;
        }
        String string3 = node.getPrefix();
        if (string3 != null && string3.equals("xmlns")) {
            this.adaptNamespace(this.currentStartElement, node.getLocalName(), node.getNodeValue());
            return;
        }
        if (DsigConstants.QNAME_VALUE_ATTRIBUTES.contains(new QName(node.getNamespaceURI(), string2)) && (string = C14NDOMAdapter.parsePrefix(node.getNodeValue())) != null) {
            String string4 = this.nameSpaceTable.get(string);
            if (string4 == null) {
                string4 = (String)this.externalNamespaces.get(string);
            }
            if (string4 != null) {
                this.nonVisiblyUsed.add(string);
                this.adaptNamespace(this.currentStartElement, string, string4);
            }
        }
        this.currentStartElement.addAttribute((Attribute)new AttributeImpl((XMLName)new Name(node.getNamespaceURI(), string2, node.getPrefix()), node.getNodeValue(), "CDATA"));
    }

    private static String parsePrefix(String string) {
        int n = string.indexOf(PREFIX_SEP);
        if (n < 0) {
            return null;
        }
        if (n == 0) {
            return EMPTY_STRING;
        }
        return string.substring(0, n);
    }

    public void adaptElement(Node node, boolean bl) throws XMLStreamException {
        this.writeCurrentStartElement();
        String string = node.getLocalName();
        if (string == null) {
            string = node.getNodeName();
        }
        if (bl) {
            this.nameSpaceTable.openScope();
            if (string == null) {
                string = node.getNodeName();
            }
            StartElementEvent startElementEvent = new StartElementEvent((XMLName)new Name(node.getNamespaceURI(), string, node.getPrefix()));
            this.setCurrentStartElement(startElementEvent);
        } else {
            this.writer.write((EndElement)new EndElementEvent((XMLName)new Name(node.getNamespaceURI(), string, node.getPrefix())));
            List list = this.nameSpaceTable.closeScope();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                PrefixMapping prefixMapping = (PrefixMapping)list.get(i);
                if (prefixMapping.getUri() == null) {
                    this.writer.write((EndPrefixMapping)new EndPrefixMappingEvent(prefixMapping.getPrefix()));
                    continue;
                }
                this.writer.write((ChangePrefixMapping)new ChangePrefixMappingEvent(prefixMapping.getOldUri(), prefixMapping.getUri(), prefixMapping.getPrefix()));
            }
        }
    }

    protected boolean isSpace(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n';
    }

    public void adaptComment(Comment comment) throws XMLStreamException {
        this.writeCurrentStartElement();
        this.writer.write((weblogic.xml.stream.Comment)new CommentEvent(comment.getData()));
    }

    public void adaptText(Node node) throws XMLStreamException {
        this.writeCurrentStartElement();
        String string = node.getNodeValue();
        this.writer.write((CharacterData)new CharacterDataEvent(string));
    }

    public void adaptCDATA(Node node) throws XMLStreamException {
        this.writeCurrentStartElement();
        boolean bl = true;
        String string = node.getNodeValue();
        int n = 97;
        int n2 = 1;
        for (int i = 0; i < string.length(); ++i) {
            if (!this.isSpace(string.charAt(i))) {
                bl = false;
            }
            if (n == 13) {
                if (string.charAt(i) == '\n') {
                    ((CDATASection)node).replaceData(i - n2, 1, EMPTY_STRING);
                    ++n2;
                }
                if (string.charAt(i) != '\n') {
                    ((CDATASection)node).replaceData(i - n2, 1, NEW_LINE);
                }
            }
            n = string.charAt(i);
        }
        if (string.charAt(string.length() - 1) == '\r') {
            ((CDATASection)node).replaceData(string.length() - n2, 1, NEW_LINE);
        }
        if (bl) {
            this.writer.write((Space)new SpaceEvent(node.getNodeValue()));
        } else {
            this.writer.write((CharacterData)new CharacterDataEvent(node.getNodeValue()));
        }
    }

    public void adaptProcessingInstruction(org.w3c.dom.ProcessingInstruction processingInstruction) throws XMLStreamException {
        this.writer.write((ProcessingInstruction)new ProcessingInstructionEvent((XMLName)new Name(processingInstruction.getNodeName()), processingInstruction.getData()));
    }
}

