/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.utils;

import com.bea.security.utils.wss.WSSThumbprint;
import com.bea.security.utils.wss.WSSThumbprintException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import weblogic.security.pk.CertPathBuilderParameters;
import weblogic.security.pk.CertPathSelector;
import weblogic.security.pk.CertPathValidatorParameters;
import weblogic.security.pk.EndCertificateSelector;
import weblogic.security.pk.IssuerDNSerialNumberSelector;
import weblogic.security.pk.SubjectKeyIdentifierSelector;
import weblogic.security.pk.X509ThumbprintSelector;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.shared.LoggerWrapper;
import weblogic.security.utils.SSLContextManager;
import weblogic.utils.io.UnsyncByteArrayInputStream;
import weblogic.xml.crypto.wss.WSSecurityConfigurationException;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.security.utils.Utils;

public class CertUtils {
    private static final LoggerWrapper logger = LoggerWrapper.getInstance("weblogic.xml.crypto.Logger");

    public static X509Certificate getCertificate(byte[] byArray) {
        X509Certificate x509Certificate = null;
        UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(byArray);
        try {
            x509Certificate = (X509Certificate)Utils.getCertFactory().generateCertificate((InputStream)unsyncByteArrayInputStream);
        }
        catch (CertificateException certificateException) {
            throw new AssertionError((Object)("Unable to decode certificate: " + certificateException));
        }
        return x509Certificate;
    }

    public static X509CRL getCRL(byte[] byArray) {
        X509CRL x509CRL = null;
        UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(byArray);
        try {
            x509CRL = (X509CRL)Utils.getCertFactory().generateCRL((InputStream)unsyncByteArrayInputStream);
        }
        catch (CRLException cRLException) {
            throw new AssertionError((Object)("Unable to decode certificate revocation list: " + cRLException));
        }
        return x509CRL;
    }

    public static boolean validateCertPath(CertPath certPath) {
        String string = SecurityServiceManager.getDefaultRealmName();
        if (string == null) {
            logger.error("CertPathBuilder cannot be used off-platform");
            return false;
        }
        CertPathValidatorParameters certPathValidatorParameters = new CertPathValidatorParameters(string, null, null);
        CertPathValidator certPathValidator = null;
        try {
            certPathValidator = CertPathValidator.getInstance("WLSCertPathValidator");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError((Object)noSuchAlgorithmException);
        }
        try {
            certPathValidator.validate(certPath, certPathValidatorParameters);
            return true;
        }
        catch (CertPathValidatorException certPathValidatorException) {
            return false;
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            return false;
        }
    }

    public static boolean validateCertificate(X509Certificate x509Certificate) {
        CertPathBuilderResult certPathBuilderResult = CertUtils.buildCertPath((CertPathSelector)new EndCertificateSelector(x509Certificate));
        return certPathBuilderResult != null;
    }

    public static X509Certificate lookupCertificate(String string) {
        X509ThumbprintSelector x509ThumbprintSelector = new X509ThumbprintSelector(string);
        return CertUtils.lookupCertificate((CertPathSelector)x509ThumbprintSelector);
    }

    public static X509Certificate lookupCertificate(String string, BigInteger bigInteger) {
        IssuerDNSerialNumberSelector issuerDNSerialNumberSelector = new IssuerDNSerialNumberSelector(string, bigInteger);
        return CertUtils.lookupCertificate((CertPathSelector)issuerDNSerialNumberSelector);
    }

    public static X509Certificate lookupCertificate(byte[] byArray) {
        SubjectKeyIdentifierSelector subjectKeyIdentifierSelector = new SubjectKeyIdentifierSelector(byArray);
        return CertUtils.lookupCertificate((CertPathSelector)subjectKeyIdentifierSelector);
    }

    public static X509Certificate lookupCertificate(CertPathSelector certPathSelector) {
        CertPathBuilderResult certPathBuilderResult = CertUtils.buildCertPath(certPathSelector);
        if (certPathBuilderResult != null) {
            Certificate certificate = certPathBuilderResult.getCertPath().getCertificates().get(0);
            if (certificate instanceof X509Certificate) {
                return (X509Certificate)certificate;
            }
            return null;
        }
        return null;
    }

    private static CertPathBuilderResult buildCertPath(CertPathSelector certPathSelector) {
        String string = SecurityServiceManager.getDefaultRealmName();
        if (string == null) {
            logger.error("CertPathBuilder cannot be used off-platform");
            return null;
        }
        CertPathBuilderParameters certPathBuilderParameters = new CertPathBuilderParameters(string, certPathSelector, null, null);
        CertPathBuilder certPathBuilder = null;
        try {
            certPathBuilder = CertPathBuilder.getInstance("WLSCertPathBuilder");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError((Object)noSuchAlgorithmException);
        }
        try {
            return certPathBuilder.build(certPathBuilderParameters);
        }
        catch (CertPathBuilderException certPathBuilderException) {
            logger.error("Failed to build CertPath", certPathBuilderException);
            return null;
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            logger.error("CertPathBuilder does not support building cert path from " + certPathSelector.getClass(), invalidAlgorithmParameterException);
            return null;
        }
    }

    public static boolean supportsSign(X509Certificate x509Certificate) {
        boolean[] blArray = x509Certificate.getKeyUsage();
        if (blArray == null) {
            return true;
        }
        return blArray[0];
    }

    public static boolean supportsKeyEncrypt(X509Certificate x509Certificate) {
        boolean[] blArray = x509Certificate.getKeyUsage();
        if (blArray == null) {
            return true;
        }
        return blArray[2];
    }

    public static X509Certificate[] getTrustedCAs() throws WSSecurityConfigurationException {
        try {
            return SSLContextManager.getServerTrustedCAs();
        }
        catch (Exception exception) {
            throw new WSSecurityConfigurationException("Failed to get trusted CAs.");
        }
    }

    public static final byte[] getThumbprint(X509Certificate x509Certificate) throws WSSecurityException {
        try {
            return weblogic.xml.crypto.encrypt.Utils.base64(WSSThumbprint.generateThumbprint((X509Certificate)x509Certificate));
        }
        catch (WSSThumbprintException wSSThumbprintException) {
            throw new WSSecurityException((Exception)((Object)wSSThumbprintException));
        }
    }
}

