/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.utils;

import java.security.cert.X509Certificate;
import javax.xml.rpc.handler.MessageContext;
import weblogic.security.SSL.TrustManager;
import weblogic.security.service.ContextHandler;
import weblogic.xml.crypto.wss.WSSecurityContext;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss.api.BinarySecurityToken;
import weblogic.xml.crypto.wss.provider.CredentialProvider;
import weblogic.xml.crypto.wss.provider.Purpose;
import weblogic.xml.crypto.wss.provider.SecurityToken;

public final class ClientBSTUtils {
    private static final String SERVER_VERIFY_CERT = "weblogic.wsee.security.bst.serverVerifyCert";
    private static final String SERVER_ENCRYPT_CERT = "weblogic.wsee.security.bst.serverEncryptCert";
    private static final boolean VALIDATION_OFF = Boolean.getBoolean("weblogic.xml.crypto.wss.X509ValidationOff");

    public static boolean isTrusted(SecurityToken securityToken, MessageContext messageContext, WSSecurityContext wSSecurityContext, ContextHandler contextHandler) throws WSSecurityException {
        if (VALIDATION_OFF) {
            return true;
        }
        X509Certificate x509Certificate = ((BinarySecurityToken)securityToken).getCertificate();
        TrustManager trustManager = (TrustManager)wSSecurityContext.getProperty("weblogic.wsee.security.wss.TrustManager");
        if (trustManager != null) {
            X509Certificate[] x509CertificateArray = new X509Certificate[]{x509Certificate};
            return trustManager.certificateCallback(x509CertificateArray, 16);
        }
        X509Certificate x509Certificate2 = (X509Certificate)messageContext.getProperty(SERVER_ENCRYPT_CERT);
        if (x509Certificate2 == null) {
            throw new WSSecurityException("Could not validate certificate: no TrustManager set and no server cert set.");
        }
        if (x509Certificate2.equals(x509Certificate)) {
            return true;
        }
        X509Certificate x509Certificate3 = (X509Certificate)messageContext.getProperty(SERVER_VERIFY_CERT);
        if (x509Certificate3 != null && x509Certificate3.equals(x509Certificate)) {
            return true;
        }
        Purpose purpose = (Purpose)messageContext.getProperty("weblogic.xml.crypto.wss.provider.Purpose");
        if (purpose == null) {
            return false;
        }
        CredentialProvider credentialProvider = wSSecurityContext.getCredentialProvider("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3");
        Object object = credentialProvider.getCredential("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3", null, contextHandler, purpose);
        if (object != null) {
            return true;
        }
        credentialProvider = wSSecurityContext.getCredentialProvider("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v1");
        object = credentialProvider.getCredential("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v1", null, contextHandler, purpose);
        return object != null;
    }
}

