/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.utils;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import weblogic.rjvm.LocalRJVM;
import weblogic.xml.dom.DOMStreamReader;
import weblogic.xml.dom.DOMStreamWriter;
import weblogic.xml.dom.Util;
import weblogic.xml.domimpl.Saver;
import weblogic.xml.stax.XMLStreamInputFactory;
import weblogic.xml.stax.XMLWriterBase;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLInputStreamFactory;
import weblogic.xml.stream.XMLStreamException;

public class DOMUtils {
    public static final String QNAME_SEPARATOR = ":";
    private static final String ID_DELIM = "_";
    public static final XMLStreamInputFactory STREAM_FAC = new XMLStreamInputFactory();
    public static final String EMPTY_STRING = "";
    private static final byte[] ID_CHARS = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 50, 49};

    public static Map getNamespaceMap(Node node) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        if (node instanceof Document) {
            node = ((Document)node).getDocumentElement();
        }
        while (node != null) {
            arrayList.add(node);
            node = node.getParentNode();
        }
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            Node node2 = (Node)arrayList.get(i);
            NamedNodeMap namedNodeMap = node2.getAttributes();
            if (namedNodeMap == null) continue;
            for (int j = 0; j < namedNodeMap.getLength(); ++j) {
                Attr attr = (Attr)namedNodeMap.item(j);
                String string = attr.getNamespaceURI();
                if (string == null || !string.equals("http://www.w3.org/2000/xmlns/")) continue;
                String string2 = attr.getLocalName();
                if ("xmlns".equals(string2)) {
                    string2 = EMPTY_STRING;
                }
                String string3 = attr.getValue();
                hashMap.put(string2, string3);
            }
        }
        return hashMap;
    }

    public static boolean isIdQName(Node node, Set set) {
        String string = node.getLocalName();
        if (string == null) {
            string = node.getNodeName();
        }
        String string2 = node.getNamespaceURI();
        QName qName = new QName(string2, string);
        return set.contains(qName);
    }

    public static List getNodeListAndIdAttrNodeMap(Node node, HashMap hashMap, Set set, boolean bl) {
        if (hashMap == null) {
            throw new IllegalArgumentException("The second parameter must not NULL");
        }
        ArrayList arrayList = new ArrayList();
        DOMUtils.traverseNodeAndIdAttrNodeMap(node, arrayList, hashMap, set, bl);
        return arrayList;
    }

    private static void traverseNodeAndIdAttrNodeMap(Node node, List list, HashMap hashMap, Set set, boolean bl) {
        int n;
        Object object;
        if (!bl && node.getNodeType() == 8) {
            return;
        }
        int[] nArray = new int[2];
        nArray[0] = list.size();
        list.add(node);
        if (node.getNodeType() == 1) {
            object = node.getAttributes();
            for (n = 0; n < object.getLength(); ++n) {
                list.add(object.item(n));
                if (!DOMUtils.isIdQName(object.item(n), set)) continue;
                String string = object.item(n).getNodeValue();
                hashMap.put(string, nArray);
            }
        }
        if (node.hasChildNodes()) {
            object = node.getChildNodes();
            for (n = 0; n < object.getLength(); ++n) {
                DOMUtils.traverseNodeAndIdAttrNodeMap(object.item(n), list, hashMap, set, bl);
            }
        }
        nArray[1] = list.size();
    }

    public static Set getNodeSet(Node node, boolean bl) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        DOMUtils.traverseNode(node, linkedHashSet, bl);
        return linkedHashSet;
    }

    private static void traverseNode(Node node, Set set, boolean bl) {
        int n;
        Object object;
        if (!bl && node.getNodeType() == 8) {
            return;
        }
        set.add(node);
        if (node.getNodeType() == 1) {
            object = node.getAttributes();
            for (n = 0; n < object.getLength(); ++n) {
                set.add(object.item(n));
            }
        }
        if (node.hasChildNodes()) {
            object = node.getChildNodes();
            for (n = 0; n < object.getLength(); ++n) {
                DOMUtils.traverseNode(object.item(n), set, bl);
            }
        }
    }

    public static QName getQName(Node node) {
        String string = node.getLocalName();
        if (string == null) {
            return new QName(node.getNodeName());
        }
        String string2 = node.getPrefix();
        if (string2 == null) {
            return new QName(node.getNamespaceURI(), string);
        }
        return new QName(node.getNamespaceURI(), string, string2);
    }

    public static Element createElement(Element element, QName qName, String string) {
        string = DOMUtils.getPrefix(string);
        Element element2 = element.getOwnerDocument().createElementNS(qName.getNamespaceURI(), string + qName.getLocalPart());
        return element2;
    }

    public static Element createAndAddElement(Element element, QName qName, String string) {
        Element element2 = DOMUtils.createElement(element, qName, string);
        element.appendChild(element2);
        return element2;
    }

    public static void addNoNSAttribute(Element element, QName qName, String string) {
        element.setAttribute(qName.getLocalPart(), string);
    }

    public static void addAttribute(Element element, QName qName, Map map, String string) {
        String string2 = (String)map.get(qName.getNamespaceURI());
        string2 = DOMUtils.getPrefix(string2);
        element.setAttributeNS(qName.getNamespaceURI(), qName.getLocalPart(), string);
    }

    public static void addAttribute(Element element, QName qName, String string) {
        element.setAttributeNS(qName.getNamespaceURI(), qName.getLocalPart(), string);
    }

    public static void addPrefixedAttribute(Element element, QName qName, String string, String string2) {
        string = DOMUtils.getPrefix(string);
        element.setAttributeNS(qName.getNamespaceURI(), string + qName.getLocalPart(), string2);
    }

    private static String getPrefix(String string) {
        if (string != null && string.length() > 0) {
            return string + QNAME_SEPARATOR;
        }
        return EMPTY_STRING;
    }

    public static void addText(Element element, String string) {
        Text text = element.getOwnerDocument().createTextNode(string);
        element.appendChild(text);
    }

    public static String getAttributeValue(Element element, QName qName, String string) {
        String string2 = DOMUtils.getAttributeValue(element, qName);
        if (string2 == null || string2.length() == 0) {
            return string;
        }
        return string2;
    }

    public static String getAttributeValue(Element element, QName qName) {
        String string = qName.getLocalPart();
        Attr attr = element.getAttributeNodeNS(qName.getNamespaceURI(), string);
        if (attr == null) {
            attr = element.getAttributeNode(string);
        }
        if (attr != null) {
            return attr.getValue();
        }
        return null;
    }

    public static void require(Node node, QName qName) throws DOMException {
        QName qName2 = DOMUtils.getQName(node);
        if (!qName2.equals(qName)) {
            throw new DOMException(11, "Node " + qName + " required, found " + qName2);
        }
    }

    public static boolean is(Node node, String string, String string2) {
        if (node == null || string2 == null) {
            return false;
        }
        if (!string2.equals(node.getLocalName())) {
            return false;
        }
        if (string != null) {
            return string.equals(node.getNamespaceURI());
        }
        return node.getNamespaceURI() == null;
    }

    public static boolean is(Node node, QName qName) {
        if (node == null || qName == null) {
            return false;
        }
        QName qName2 = DOMUtils.getQName(node);
        return qName.equals(qName2);
    }

    public static String getText(Element element) {
        return element.getFirstChild().getNodeValue();
    }

    public static Element getFirstElement(Node node) {
        Node node2;
        for (node2 = node.getFirstChild(); node2 != null && node2.getNodeType() != 1; node2 = node2.getNextSibling()) {
        }
        return (Element)node2;
    }

    public static Element getLastElement(Node node) {
        Node node2;
        for (node2 = node.getLastChild(); node2 != null && node2.getNodeType() != 1; node2 = node2.getPreviousSibling()) {
        }
        return (Element)node2;
    }

    public static Element getNextElement(Node node) {
        Node node2;
        for (node2 = node.getNextSibling(); node2 != null && node2.getNodeType() != 1; node2 = node2.getNextSibling()) {
        }
        return (Element)node2;
    }

    public static Map getNSMap(Node node) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        while (node != null) {
            arrayList.add(node);
            node = node.getParentNode();
        }
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            Node node2 = (Node)arrayList.get(i);
            NamedNodeMap namedNodeMap = node2.getAttributes();
            if (namedNodeMap == null) continue;
            for (int j = 0; j < namedNodeMap.getLength(); ++j) {
                Attr attr = (Attr)namedNodeMap.item(j);
                String string = attr.getNamespaceURI();
                if (string == null || !string.equals("http://www.w3.org/2000/xmlns/")) continue;
                String string2 = attr.getLocalName();
                if ("xmlns".equals(string2)) {
                    string2 = EMPTY_STRING;
                }
                String string3 = attr.getValue();
                hashMap.put(string2, string3);
                hashMap.put(string3, string2);
            }
        }
        return hashMap;
    }

    public static String assignId(Element element, QName qName, String string, Set set) {
        String string2 = DOMUtils.getExistingId(element, set);
        if (string2 == null || string2.length() == 0) {
            string2 = DOMUtils.generateId(element.getLocalName());
            DOMUtils.addPrefixedAttribute(element, qName, string, string2);
        }
        return string2;
    }

    public static String getExistingId(Element element, Set set) {
        String string = null;
        for (QName qName : set) {
            String string2 = qName.getNamespaceURI();
            if (EMPTY_STRING.equals(string2)) {
                string2 = null;
            }
            if ((string = element.getAttributeNS(string2, qName.getLocalPart())) == null || string.length() <= 0) continue;
            break;
        }
        return string;
    }

    public static String generateId(String string) {
        return string + ID_DELIM + DOMUtils.generateId();
    }

    public static String generateId() {
        int n = 16;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byte[] byArray2 = new byte[1];
            LocalRJVM.getLocalRJVM().getSecureRandom().nextBytes(byArray2);
            byArray[i] = ID_CHARS[(byArray2[0] + 128) % 64];
        }
        return new String(byArray);
    }

    public static void declareNamespace(Element element, String string, String string2) {
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string2, string);
    }

    public static void declareNamespace(Element element, String string, String string2, Map map) {
        String string3 = (String)map.get(string2);
        if (string3 == null || !string3.equals(string)) {
            DOMUtils.declareNamespace(element, string, string2);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        Document document = documentBuilderFactory.newDocumentBuilder().parse(new InputSource(new StringReader("<foo1 xmlns:foo='foo1'><foo2 xmlns:foo='foo2'><bar id='bar'/></foo2></foo1>")));
        System.out.println("document: " + Util.printNode(document));
        Node node = document.getElementsByTagName("bar").item(0);
        if (node != null) {
            System.out.println("node: " + Util.printNode(node));
        }
        Map map = DOMUtils.getNamespaceMap(node);
        System.out.println(map);
        map.clear();
        document = documentBuilderFactory.newDocumentBuilder().parse(new InputSource(new StringReader("<foo1 xmlns:foo1='foo'><foo2 xmlns:foo2='foo'><bar id='bar'/></foo2></foo1>")));
        System.out.println("document: " + Util.printNode(document));
        node = document.getElementsByTagName("bar").item(0);
        if (node != null) {
            System.out.println(Util.printNode(node));
        }
        map = DOMUtils.getNamespaceMap(node);
        System.out.println(map);
    }

    public static void writeNode(Node node, OutputStream outputStream, String string) throws UnsupportedEncodingException, javax.xml.stream.XMLStreamException {
        XMLWriterBase xMLWriterBase = DOMUtils.createStreamWriter(outputStream, string);
        Saver.save((XMLStreamWriter)xMLWriterBase, (Node)node);
        xMLWriterBase.flush();
    }

    private static XMLWriterBase createStreamWriter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string);
        XMLWriterBase xMLWriterBase = new XMLWriterBase((Writer)outputStreamWriter);
        return xMLWriterBase;
    }

    private static void writeNode(Node node, XMLWriterBase xMLWriterBase) throws javax.xml.stream.XMLStreamException {
        DOMStreamReader dOMStreamReader = new DOMStreamReader(node);
        DOMUtils.writeAll(dOMStreamReader, xMLWriterBase);
    }

    private static void writeAll(XMLStreamReader xMLStreamReader, XMLWriterBase xMLWriterBase) throws javax.xml.stream.XMLStreamException {
        xMLWriterBase.write(xMLStreamReader);
        while (xMLStreamReader.hasNext()) {
            xMLStreamReader.next();
            xMLWriterBase.write(xMLStreamReader);
        }
    }

    public static void writeNodeList(NodeList nodeList, OutputStream outputStream, String string) throws javax.xml.stream.XMLStreamException, UnsupportedEncodingException {
        int n = nodeList.getLength();
        XMLWriterBase xMLWriterBase = DOMUtils.createStreamWriter(outputStream, string);
        xMLWriterBase.setEscapingCR(true);
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            DOMUtils.writeNode(node, xMLWriterBase);
        }
        xMLWriterBase.flush();
    }

    public static byte[] getBytes(Node node, String string) throws javax.xml.stream.XMLStreamException, UnsupportedEncodingException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DOMUtils.writeNode(node, byteArrayOutputStream, string);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] getBytes(NodeList nodeList, String string) throws javax.xml.stream.XMLStreamException, UnsupportedEncodingException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DOMUtils.writeNodeList(nodeList, byteArrayOutputStream, string);
        return byteArrayOutputStream.toByteArray();
    }

    public static void replace(Node node, InputStream inputStream, String string) throws javax.xml.stream.XMLStreamException {
        Node node2 = node.getParentNode();
        Node node3 = node.getNextSibling();
        node2.removeChild(node);
        DOMUtils.insertChild(node2, node3, inputStream, string);
    }

    public static void insertChild(Node node, Node node2, InputStream inputStream, String string) throws javax.xml.stream.XMLStreamException {
        Map map = DOMUtils.getNSMap(node);
        XMLStreamReader xMLStreamReader = STREAM_FAC.createXMLStreamFragmentReader(inputStream, string, map);
        DOMUtils.insertChild(xMLStreamReader, node, node2);
    }

    public static void insertChild(XMLStreamReader xMLStreamReader, Node node, Node node2) throws javax.xml.stream.XMLStreamException {
        Document document = node.getOwnerDocument();
        DOMStreamWriter dOMStreamWriter = node2 != null ? new DOMStreamWriter(document, node, node2) : new DOMStreamWriter(document, node);
        dOMStreamWriter.writeAll(xMLStreamReader);
    }

    public static String getPrefix(String string, Element element) {
        assert (string != null);
        assert (element != null);
        do {
            NamedNodeMap namedNodeMap = element.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                String string2;
                Node node = namedNodeMap.item(i);
                String string3 = node.getNodeName();
                if (!string3.startsWith("xmlns:") || !string.equals(string2 = node.getNodeValue())) continue;
                return string3.substring(6);
            }
        } while ((element = (Element)element.getParentNode()) != null);
        return null;
    }

    public static Node findNode(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string2 = node2.getLocalName();
            if (string2 == null || !string2.equals(string)) continue;
            return node2;
        }
        return null;
    }

    public static XMLInputStream getXMLInputStream(Node node) throws XMLStreamException {
        return XMLInputStreamFactory.newInstance().newInputStream(node);
    }
}

