/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.utils;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.w3c.dom.Node;
import weblogic.xml.crypto.NodeSetDataImpl;
import weblogic.xml.crypto.OctetData;
import weblogic.xml.crypto.api.Data;
import weblogic.xml.crypto.api.NodeSetData;
import weblogic.xml.crypto.api.OctetStreamData;
import weblogic.xml.crypto.dsig.api.XMLSignatureException;
import weblogic.xml.crypto.utils.ByteVector;
import weblogic.xml.crypto.utils.DOMUtils;
import weblogic.xml.dom.Builder;
import weblogic.xml.dom.ElementNode;
import weblogic.xml.stream.XMLStreamException;

public class DataUtils {
    public static Node getNode(Data data) throws XMLSignatureException {
        Node node = null;
        if (data instanceof NodeSetData) {
            Iterator iterator = ((NodeSetData)data).iterator();
            if (!iterator.hasNext()) {
                return null;
            }
            node = (Node)iterator.next();
            if (iterator.hasNext()) {
                throw new XMLSignatureException("NodeSetData has more than one node.");
            }
        }
        return node;
    }

    public static NodeSetData extractNodeSetData(Data data) throws XMLSignatureException {
        if (data instanceof NodeSetData) {
            return (NodeSetData)data;
        }
        if (data instanceof OctetStreamData) {
            InputStream inputStream = ((OctetStreamData)data).getOctetStream();
            return DataUtils.getNodeSetData(inputStream);
        }
        if (data instanceof OctetData) {
            OctetData octetData = (OctetData)data;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(octetData.getBytes());
            return DataUtils.getNodeSetData(byteArrayInputStream);
        }
        throw new XMLSignatureException("Unsupported Data object.");
    }

    private static NodeSetData getNodeSetData(InputStream inputStream) throws XMLSignatureException {
        Node node = null;
        try {
            node = DataUtils.getNode(inputStream);
        }
        catch (javax.xml.stream.XMLStreamException xMLStreamException) {
            throw new XMLSignatureException("Failed to convert stream to node.", xMLStreamException);
        }
        return new NodeSetDataImpl(DOMUtils.getNodeSet(node, true));
    }

    public static InputStream getInputStream(Data data) throws XMLSignatureException {
        InputStream inputStream = null;
        if (data instanceof OctetStreamData) {
            inputStream = ((OctetStreamData)data).getOctetStream();
        }
        return inputStream;
    }

    private static Node getNode(InputStream inputStream) throws javax.xml.stream.XMLStreamException {
        XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
        XMLStreamReader xMLStreamReader = xMLInputFactory.createXMLStreamReader(inputStream);
        Builder.nextTag(xMLStreamReader);
        return Builder.read(new ElementNode(), xMLStreamReader);
    }

    public static byte[] getBytes(Data data) throws XMLSignatureException, XMLStreamException, IOException {
        InputStream inputStream;
        if (data instanceof OctetData) {
            return ((OctetData)data).getBytes();
        }
        if (data instanceof OctetStreamData && (inputStream = ((OctetStreamData)data).getOctetStream()) != null) {
            return DataUtils.getBytes(inputStream);
        }
        throw new XMLSignatureException("Can not convert Data object " + data + " into byte[].");
    }

    private static byte[] getBytes(InputStream inputStream) throws IOException {
        ByteVector byteVector = new ByteVector();
        byteVector.addElements(new BufferedInputStream(inputStream));
        return byteVector.minSizedElementArray();
    }

    public static String toString(Data data) {
        if (data instanceof NodeSetData) {
            NodeSetData nodeSetData = (NodeSetData)data;
            StringBuffer stringBuffer = new StringBuffer("[NodeSetData:");
            Iterator iterator = nodeSetData.iterator();
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                String string = node.getLocalName();
                if (string == null) {
                    string = node.getNodeName();
                } else {
                    short s = node.getNodeType();
                    if (s == 1 || s == 2) {
                        string = string + "[" + node.getPrefix() + "=" + node.getNamespaceURI() + "]";
                    }
                }
                stringBuffer.append("[Node:" + string);
                stringBuffer.append("]");
            }
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
        if (data instanceof OctetStreamData) {
            return "[OctetStreamData, not reading it]";
        }
        if (data instanceof OctetData) {
            return new String("[OctetData, as String in platform default encoding:" + new String(((OctetData)data).getBytes())) + "]";
        }
        return "Unsupported Data object.";
    }
}

