/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.utils;

import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class DebugStreamReader
implements XMLStreamReader {
    int depth = 0;
    final XMLStreamReader delegate;
    private static final String PREFIX = "";
    private static final String INDENT = "  ";

    public DebugStreamReader(XMLStreamReader xMLStreamReader) {
        this.delegate = xMLStreamReader;
    }

    public XMLStreamReader getDelegate() {
        return this.delegate;
    }

    public int next() throws XMLStreamException {
        int n = this.delegate.next();
        switch (n) {
            case 1: {
                this.printStart();
                ++this.depth;
                break;
            }
            case 2: {
                --this.depth;
                this.printEnd();
                break;
            }
            case 4: {
                this.printCharacters();
                break;
            }
        }
        return n;
    }

    private void printCharacters() {
        String string = this.getIndent();
        System.out.println(string + "[CHARACTERS ");
        System.out.println(string + "]");
        System.out.flush();
    }

    private void printEnd() {
        String string = this.getIndent();
        System.out.println(string + "[END ELEMENT " + this.getNamespaceURI() + ":" + this.getLocalName() + "]");
        System.out.flush();
    }

    private void printStart() {
        String string;
        String string2;
        int n;
        String string3 = this.getIndent();
        System.out.println(string3 + "[START ELEMENT " + this.getNamespaceURI() + ":" + this.getLocalName());
        for (n = 0; n < this.delegate.getNamespaceCount(); ++n) {
            string2 = this.delegate.getNamespacePrefix(n);
            string = this.delegate.getNamespaceURI(n);
            System.out.println(string3 + "  NAMESPACE " + string2 + " = " + string);
        }
        for (n = 0; n < this.delegate.getAttributeCount(); ++n) {
            string2 = this.delegate.getAttributeNamespace(n);
            string = this.delegate.getAttributeLocalName(n);
            String string4 = this.delegate.getAttributeValue(n);
            System.out.println(string3 + "  ATTRIBUTE " + string2 + ":" + string + " = " + string4);
        }
        System.out.println(string3 + "]");
        System.out.flush();
    }

    private String getIndent() {
        String string = PREFIX;
        for (int i = this.depth; i > 0; --i) {
            string = string + INDENT;
        }
        return string;
    }

    public Object getProperty(String string) throws IllegalArgumentException {
        return this.delegate.getProperty(string);
    }

    public void require(int n, String string, String string2) throws XMLStreamException {
        this.delegate.require(n, string, string2);
    }

    public String getElementText() throws XMLStreamException {
        return this.delegate.getElementText();
    }

    public int nextTag() throws XMLStreamException {
        int n;
        do {
            if ((n = this.next()) == 8) {
                throw new XMLStreamException("Unexpected end of Document");
            }
            if (!this.isCharacters() || this.isWhiteSpace()) continue;
            throw new XMLStreamException("Unexpected text");
        } while (1 != n && 2 != n);
        return this.getEventType();
    }

    public boolean hasNext() throws XMLStreamException {
        return this.delegate.hasNext();
    }

    public void close() throws XMLStreamException {
        this.delegate.close();
    }

    public String getNamespaceURI(String string) {
        return this.delegate.getNamespaceURI(string);
    }

    public boolean isStartElement() {
        return this.delegate.isStartElement();
    }

    public boolean isEndElement() {
        return this.delegate.isEndElement();
    }

    public boolean isCharacters() {
        return this.delegate.isCharacters();
    }

    public boolean isWhiteSpace() {
        return this.delegate.isWhiteSpace();
    }

    public String getAttributeValue(String string, String string2) {
        return this.delegate.getAttributeValue(string, string2);
    }

    public int getAttributeCount() {
        return this.delegate.getAttributeCount();
    }

    public QName getAttributeName(int n) {
        return this.delegate.getAttributeName(n);
    }

    public String getAttributeNamespace(int n) {
        return this.delegate.getAttributeNamespace(n);
    }

    public String getAttributeLocalName(int n) {
        return this.delegate.getAttributeLocalName(n);
    }

    public String getAttributePrefix(int n) {
        return this.delegate.getAttributePrefix(n);
    }

    public String getAttributeType(int n) {
        return this.delegate.getAttributeType(n);
    }

    public String getAttributeValue(int n) {
        return this.delegate.getAttributeValue(n);
    }

    public boolean isAttributeSpecified(int n) {
        return this.delegate.isAttributeSpecified(n);
    }

    public int getNamespaceCount() {
        return this.delegate.getNamespaceCount();
    }

    public String getNamespacePrefix(int n) {
        return this.delegate.getNamespacePrefix(n);
    }

    public String getNamespaceURI(int n) {
        return this.delegate.getNamespaceURI(n);
    }

    public NamespaceContext getNamespaceContext() {
        return this.delegate.getNamespaceContext();
    }

    public int getEventType() {
        return this.delegate.getEventType();
    }

    public String getText() {
        return this.delegate.getText();
    }

    public char[] getTextCharacters() {
        return this.delegate.getTextCharacters();
    }

    public int getTextCharacters(int n, char[] cArray, int n2, int n3) throws XMLStreamException {
        return this.delegate.getTextCharacters(n, cArray, n2, n3);
    }

    public int getTextStart() {
        return this.delegate.getTextStart();
    }

    public int getTextLength() {
        return this.delegate.getTextLength();
    }

    public String getEncoding() {
        return this.delegate.getEncoding();
    }

    public boolean hasText() {
        return this.delegate.hasText();
    }

    public Location getLocation() {
        return this.delegate.getLocation();
    }

    public QName getName() {
        return this.delegate.getName();
    }

    public String getLocalName() {
        return this.delegate.getLocalName();
    }

    public boolean hasName() {
        return this.delegate.hasName();
    }

    public String getNamespaceURI() {
        return this.delegate.getNamespaceURI();
    }

    public String getPrefix() {
        return this.delegate.getPrefix();
    }

    public String getVersion() {
        return this.delegate.getVersion();
    }

    public boolean isStandalone() {
        return this.delegate.isStandalone();
    }

    public boolean standaloneSet() {
        return this.delegate.standaloneSet();
    }

    public String getCharacterEncodingScheme() {
        return this.delegate.getCharacterEncodingScheme();
    }

    public String getPITarget() {
        return this.delegate.getPITarget();
    }

    public String getPIData() {
        return this.delegate.getPIData();
    }
}

