/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.utils;

import java.security.Key;
import java.util.ArrayList;
import weblogic.xml.crypto.api.KeySelector;
import weblogic.xml.crypto.api.KeySelectorException;
import weblogic.xml.crypto.api.KeySelectorResult;
import weblogic.xml.crypto.common.keyinfo.KeyProvider;
import weblogic.xml.crypto.dsig.api.keyinfo.KeyInfo;
import weblogic.xml.crypto.encrypt.EncryptionAlgorithm;
import weblogic.xml.crypto.encrypt.api.EncryptionMethod;
import weblogic.xml.crypto.encrypt.api.XMLEncryptionException;
import weblogic.xml.crypto.wss.WSSecurityContext;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss.provider.SecurityTokenReference;

public class EncryptedKeyUtils {
    public static final Key generateKey(EncryptionMethod encryptionMethod) {
        Key key = null;
        try {
            key = ((EncryptionAlgorithm)encryptionMethod).generateKey();
        }
        catch (XMLEncryptionException xMLEncryptionException) {
            // empty catch block
        }
        return key;
    }

    public static final KeyInfo getKeyInfo(WSSecurityContext wSSecurityContext, SecurityTokenReference securityTokenReference) {
        ArrayList<SecurityTokenReference> arrayList = new ArrayList<SecurityTokenReference>();
        arrayList.add(securityTokenReference);
        KeyInfo keyInfo = wSSecurityContext.getSignatureFactory().getKeyInfoFactory().newKeyInfo(arrayList);
        return keyInfo;
    }

    public static final Key getKey(KeySelector keySelector, KeyProvider keyProvider, EncryptionMethod encryptionMethod) throws WSSecurityException {
        KeySelectorResult keySelectorResult = null;
        try {
            keySelectorResult = keyProvider != null ? keyProvider.getKey(encryptionMethod.getAlgorithm(), KeySelector.Purpose.ENCRYPT) : keySelector.select(null, KeySelector.Purpose.ENCRYPT, encryptionMethod, null);
        }
        catch (KeySelectorException keySelectorException) {
            throw new WSSecurityException(keySelectorException);
        }
        if (keySelectorResult == null) {
            throw new WSSecurityException("Failed to select key for algorithm " + encryptionMethod.getAlgorithm());
        }
        Key key = keySelectorResult.getKey();
        return key;
    }
}

