/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.utils;

import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_SecretKey;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.SecretKeySpec;
import weblogic.xml.crypto.api.KeySelector;
import weblogic.xml.crypto.common.keyinfo.KeyProvider;
import weblogic.xml.security.encryption.EncryptionException;
import weblogic.xml.security.encryption.Utils;

public class KeyUtils {
    public static final KeySelector.Purpose[] ALL_PURPOSES = new KeySelector.Purpose[]{KeySelector.Purpose.SIGN, KeySelector.Purpose.VERIFY, KeySelector.Purpose.ENCRYPT, KeySelector.Purpose.DECRYPT};
    public static final KeySelector.Purpose[] PRIVATE_KEY_PURPOSES = new KeySelector.Purpose[]{KeySelector.Purpose.SIGN, KeySelector.Purpose.DECRYPT};
    public static final KeySelector.Purpose[] PUBLIC_KEY_PURPOSES = new KeySelector.Purpose[]{KeySelector.Purpose.VERIFY, KeySelector.Purpose.ENCRYPT};
    public static final KeySelector.Purpose[] DSA_PRIVATE_KEY_PURPOSES = new KeySelector.Purpose[]{KeySelector.Purpose.SIGN};
    public static final KeySelector.Purpose[] DSA_PUBLIC_KEY_PURPOSES = new KeySelector.Purpose[]{KeySelector.Purpose.VERIFY};
    private static final String AES_KEY_FACTORY_ID = "AES";
    private static final String DES_KEY_FACTORY_ID = "DESEDE";
    private static final String DES_JSAFE_KEY_FACTORY_ID = "3DES_EDE";
    private static final String DES_JSAFE_PROVIDER = "Java";
    private static final String DES3_URI = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
    protected static final SecureRandom rand = new SecureRandom();
    private static final String[] desAlgs = new String[]{"http://www.w3.org/2001/04/xmlenc#kw-tripledes", "http://www.w3.org/2001/04/xmlenc#tripledes-cbc"};
    private static final String[] aesAlgs = new String[]{"http://www.w3.org/2001/04/xmlenc#aes128-cbc", "http://www.w3.org/2001/04/xmlenc#aes192-cbc", "http://www.w3.org/2001/04/xmlenc#aes256-cbc", "http://www.w3.org/2001/04/xmlenc#kw-aes128", "http://www.w3.org/2001/04/xmlenc#kw-aes192", "http://www.w3.org/2001/04/xmlenc#kw-aes256"};
    private static final Integer KL128 = new Integer(128);
    private static final Integer KL192 = new Integer(192);
    private static final Integer KL256 = new Integer(256);
    private static final Map keyLengths = new HashMap();

    public static final boolean supports(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2 == null || !string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public static final String[] getAlgorithms(Key key) {
        if (key == null) {
            throw new IllegalArgumentException("Provided null, expected key");
        }
        String string = key.getAlgorithm();
        if (DES_KEY_FACTORY_ID.equalsIgnoreCase(string)) {
            return KeyProvider.TRIPLEDES_ALGORITHMS;
        }
        if (AES_KEY_FACTORY_ID.equals(string)) {
            return KeyProvider.AES_ALGORITHMS;
        }
        if ("RSA".equals(string)) {
            return KeyProvider.RSA_ALGORITHMS;
        }
        if ("DSA".equals(string)) {
            return KeyProvider.DSA_ALGORITHMS;
        }
        throw new IllegalArgumentException("Unsupported algorithm: " + string);
    }

    public static final KeySelector.Purpose[] getPurposes(Key key) {
        if (key == null) {
            throw new IllegalArgumentException("Provided null, expected key");
        }
        if (key instanceof PublicKey) {
            return "DSA".equals(key.getAlgorithm()) ? DSA_PUBLIC_KEY_PURPOSES : PUBLIC_KEY_PURPOSES;
        }
        if (key instanceof PrivateKey) {
            return "DSA".equals(key.getAlgorithm()) ? DSA_PRIVATE_KEY_PURPOSES : PRIVATE_KEY_PURPOSES;
        }
        return ALL_PURPOSES;
    }

    public static final boolean serves(KeySelector.Purpose[] purposeArray, KeySelector.Purpose purpose) {
        for (int i = 0; i < purposeArray.length; ++i) {
            KeySelector.Purpose purpose2 = purposeArray[i];
            if (purpose != purpose2) continue;
            return true;
        }
        return false;
    }

    public static boolean matches(byte[] byArray, byte[] byArray2) {
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            byte by2 = byArray2[i];
            if (by == by2) continue;
            return false;
        }
        return true;
    }

    public static Key generateKey(String string) throws EncryptionException {
        Key key = null;
        if (KeyUtils.isAlg(string, aesAlgs)) {
            key = KeyUtils.generateAESKey(KeyUtils.getKeyLength(string));
        }
        if (KeyUtils.isAlg(string, desAlgs)) {
            key = KeyUtils.generateDES3Key();
        }
        return key;
    }

    private static boolean isAlg(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2 == null || !string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    private static int getKeyLength(String string) {
        Integer n = (Integer)keyLengths.get(string);
        if (n != null) {
            return n;
        }
        throw new IllegalArgumentException("Unsupported algorithm.");
    }

    private static Key generateAESKey(int n) throws EncryptionException {
        byte[] byArray = new byte[n];
        rand.nextBytes(byArray);
        return KeyUtils.createAESKey(byArray);
    }

    private static Key createAESKey(byte[] byArray) throws EncryptionException {
        return new SecretKeySpec(byArray, AES_KEY_FACTORY_ID);
    }

    private static Key generateDES3Key() throws EncryptionException {
        try {
            JSAFE_SecretKey jSAFE_SecretKey = JSAFE_SecretKey.getInstance((String)DES_JSAFE_KEY_FACTORY_ID, (String)DES_JSAFE_PROVIDER);
            jSAFE_SecretKey.generateInit(null, Utils.getRNG());
            jSAFE_SecretKey.generate();
            return KeyUtils.createDES3Key(jSAFE_SecretKey.getSecretKeyData());
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new EncryptionException(jSAFE_Exception);
        }
    }

    private static Key createDES3Key(byte[] byArray) throws EncryptionException {
        try {
            DESedeKeySpec dESedeKeySpec = new DESedeKeySpec(byArray);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(DES_KEY_FACTORY_ID);
            return secretKeyFactory.generateSecret(dESedeKeySpec);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new EncryptionException("Invalid key supplied to http://www.w3.org/2001/04/xmlenc#tripledes-cbc", invalidKeyException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new EncryptionException("Cannot locate JCE algorithm (DESEDE) necessary for generating a secret key for: http://www.w3.org/2001/04/xmlenc#tripledes-cbc", noSuchAlgorithmException);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new EncryptionException("Unexpected exception when generating key for: http://www.w3.org/2001/04/xmlenc#tripledes-cbc", invalidKeySpecException);
        }
    }

    public static byte[] createNonce() {
        byte[] byArray = new byte[16];
        rand.nextBytes(byArray);
        return byArray;
    }

    public static final SecretKey newSecretKey(String string, int n) throws NoSuchAlgorithmException, IllegalArgumentException {
        KeyGenerator keyGenerator = KeyGenerator.getInstance(string);
        keyGenerator.init(n);
        return keyGenerator.generateKey();
    }

    public static Key generateKey(byte[] byArray, byte[] byArray2, String string, int n) throws NoSuchAlgorithmException, InvalidKeyException {
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, string);
        byte[] byArray3 = KeyUtils.P_SHA1(secretKeySpec, byArray2, n / 8);
        return new SecretKeySpec(byArray3, string);
    }

    public static byte[] P_SHA1(Key key, byte[] byArray, int n) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac mac = Mac.getInstance("HmacSHA1");
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = byArray;
        int n2 = 0;
        do {
            mac.init(key);
            byArray3 = mac.doFinal(byArray3);
            mac.reset();
            mac.init(key);
            mac.update(byArray3);
            byte[] byArray4 = mac.doFinal(byArray);
            mac.reset();
            for (int i = 0; n2 < n && i < byArray4.length; ++n2, ++i) {
                byArray2[n2] = byArray4[i];
            }
        } while (n2 < n);
        return byArray2;
    }

    static {
        keyLengths.put("http://www.w3.org/2001/04/xmlenc#aes128-cbc", KL128);
        keyLengths.put("http://www.w3.org/2001/04/xmlenc#aes192-cbc", KL192);
        keyLengths.put("http://www.w3.org/2001/04/xmlenc#aes256-cbc", KL256);
        keyLengths.put("http://www.w3.org/2001/04/xmlenc#kw-aes128", KL128);
        keyLengths.put("http://www.w3.org/2001/04/xmlenc#kw-aes192", KL192);
        keyLengths.put("http://www.w3.org/2001/04/xmlenc#kw-aes256", KL256);
    }
}

