/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.utils;

import java.util.logging.Level;
import java.util.logging.Logger;
import weblogic.logging.LoggingHelper;

public class LogUtils {
    public static final String DSIG_VERBOSE_PROPERTY = "weblogic.xml.crypto.dsig.verbose";
    public static final boolean DSIG_VERBOSE = Boolean.getBoolean("weblogic.xml.crypto.dsig.verbose");
    public static final String ENCRYPT_VERBOSE_PROPERTY = "weblogic.xml.crypto.encrypt.verbose";
    public static final boolean ENCRYPT_VERBOSE = Boolean.getBoolean("weblogic.xml.crypto.encrypt.verbose");
    public static final String WSS_VERBOSE_PROPERTY = "weblogic.xml.crypto.wss.verbose";
    public static final boolean WSS_VERBOSE = Boolean.getBoolean("weblogic.xml.crypto.wss.verbose");
    public static final String WSS_DEBUG_PROPERTY = "weblogic.xml.crypto.wss.debug";
    public static final boolean WSS_DEBUG = Boolean.getBoolean("weblogic.xml.crypto.wss.debug");
    public static final String KEYINFO_VERBOSE_PROPERTY = "weblogic.xml.crypto.keyinfo.verbose";
    public static final boolean KEYINFO_VERBOSE = Boolean.getBoolean("weblogic.xml.crypto.keyinfo.verbose");
    private static Logger logger = null;
    private static final Level logLevel = Level.INFO;
    public static final String INCLUDE_METHOD_INFO_PROPERTY = "weblogic.xml.crypto.utils.LogUtils.INCLUDE_METHOD_INFO";
    public static final boolean INCLUDE_METHOD_INFO = Boolean.getBoolean("weblogic.xml.crypto.utils.LogUtils.INCLUDE_METHOD_INFO");

    public static void logDsig(String string) {
        if (DSIG_VERBOSE) {
            LogUtils.log(string);
        }
    }

    public static void logDsig(Object object) {
        if (DSIG_VERBOSE) {
            LogUtils.log(object.toString());
        }
    }

    public static void logDsig(String string, Object object) {
        if (DSIG_VERBOSE) {
            if (string == null) {
                LogUtils.log(object.toString());
            } else {
                LogUtils.log(string + object);
            }
        }
    }

    public static void logDsig(LogMethod logMethod) {
        if (DSIG_VERBOSE) {
            LogUtils.log(logMethod.log());
        }
    }

    public static void logEncrypt(String string) {
        if (ENCRYPT_VERBOSE) {
            LogUtils.log(string);
        }
    }

    public static void logEncrypt(LogMethod logMethod) {
        if (ENCRYPT_VERBOSE) {
            LogUtils.log(logMethod.log());
        }
    }

    public static void logWss(String string) {
        if (WSS_VERBOSE) {
            LogUtils.log(string);
        }
    }

    public static void logWss(String string, Object object) {
        if (WSS_VERBOSE) {
            LogUtils.log(string + object);
        }
    }

    public static void debugWss(String string) {
        if (WSS_DEBUG) {
            LogUtils.log(string);
        }
    }

    public static void logKeyInfo(String string) {
        if (KEYINFO_VERBOSE) {
            LogUtils.log(string);
        }
    }

    private static void log(String string) {
        if (INCLUDE_METHOD_INFO) {
            StackTraceElement[] stackTraceElementArray = new Exception().getStackTrace();
            StringBuilder stringBuilder = new StringBuilder(string);
            stringBuilder.append("<").append(LogUtils.shortName(stackTraceElementArray[2].getClassName()));
            stringBuilder.append(".");
            stringBuilder.append(stackTraceElementArray[2].getMethodName());
            int n = stackTraceElementArray[2].getLineNumber();
            if (n > -1) {
                stringBuilder.append(":");
                stringBuilder.append(n);
            }
            stringBuilder.append(">");
            string = stringBuilder.toString();
        }
        logger.log(logLevel, string);
    }

    private static String shortName(String string) {
        int n = string.lastIndexOf(46);
        if (n != -1) {
            string = string.substring(n + 1, string.length());
        }
        return string;
    }

    static {
        logger = LoggingHelper.getServerLogger();
        if (logger == null) {
            logger = LoggingHelper.getClientLogger();
        }
    }

    public static interface LogMethod {
        public String log();
    }
}

