/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.utils;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import weblogic.xml.dom.DOMStreamReader;
import weblogic.xml.stax.ReaderToWriter;

public class StaxUtils {
    public static void forwardToEndElement(String string, String string2, XMLStreamReader xMLStreamReader) throws XMLStreamException {
        while (xMLStreamReader.getEventType() != 2 || !string.equals(xMLStreamReader.getNamespaceURI()) || !string2.equals(xMLStreamReader.getLocalName())) {
            xMLStreamReader.next();
        }
    }

    public static void writeElement(XMLStreamWriter xMLStreamWriter, String string, String string2, String string3) throws XMLStreamException {
        xMLStreamWriter.writeStartElement(string, string2);
        xMLStreamWriter.writeCharacters(string3);
        xMLStreamWriter.writeEndElement();
    }

    public static void skipChildren(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        int n = 0;
        int n2 = xMLStreamReader.getEventType();
        block4: while (n > 0 || n == 0 && n2 != 2) {
            n2 = xMLStreamReader.next();
            switch (n2) {
                case 1: {
                    ++n;
                    continue block4;
                }
                case 2: {
                    --n;
                    continue block4;
                }
            }
        }
    }

    public static String getAttributeValue(String string, String string2, XMLStreamReader xMLStreamReader) {
        if (xMLStreamReader.getEventType() != 1) {
            // empty if block
        }
        String string3 = null;
        for (int i = 0; i < xMLStreamReader.getAttributeCount(); ++i) {
            String string4 = xMLStreamReader.getAttributeLocalName(i);
            if (!string4.equals(string2)) continue;
            String string5 = xMLStreamReader.getAttributeNamespace(i);
            String string6 = xMLStreamReader.getAttributeValue(i);
            if (string5 == null || string5.length() == 0) {
                string3 = string6;
                if (string != null) continue;
                break;
            }
            if (!string5.equals(string)) continue;
            string3 = string6;
            break;
        }
        return string3;
    }

    public static boolean findStart(XMLStreamReader xMLStreamReader, String string, String string2) throws XMLStreamException {
        if (string2 == null) {
            throw new IllegalArgumentException("name parameter cannot be null");
        }
        int n = !xMLStreamReader.isStartElement() && !xMLStreamReader.isEndElement() ? xMLStreamReader.nextTag() : xMLStreamReader.getEventType();
        switch (n) {
            case 1: {
                String string3 = xMLStreamReader.getNamespaceURI();
                String string4 = xMLStreamReader.getLocalName();
                return string2.equals(string4) && (string == null ? string3 == null : string.equals(string3));
            }
        }
        return false;
    }

    public static int skipWS(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        int n = xMLStreamReader.getEventType();
        boolean bl = true;
        do {
            switch (n) {
                case 3: 
                case 5: 
                case 6: {
                    n = xMLStreamReader.next();
                    break;
                }
                case 4: {
                    if (xMLStreamReader.isWhiteSpace()) {
                        n = xMLStreamReader.next();
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    bl = false;
                }
            }
        } while (bl);
        return n;
    }

    public static boolean findStart(XMLStreamReader xMLStreamReader, String string, String string2, boolean bl) throws XMLStreamException {
        if (StaxUtils.findStart(xMLStreamReader, string, string2)) {
            return true;
        }
        if (bl) {
            throw new XMLStreamException("Did not find expected element " + string + ":" + string2);
        }
        return false;
    }

    public static void findEnd(XMLStreamReader xMLStreamReader, String string, String string2) throws XMLStreamException {
        StaxUtils.skipChildren(xMLStreamReader);
        xMLStreamReader.require(2, string, string2);
    }

    public static String getElementValue(XMLStreamReader xMLStreamReader, String string, String string2) throws XMLStreamException {
        String string3;
        if (StaxUtils.findStart(xMLStreamReader, string, string2)) {
            xMLStreamReader.next();
            int n = StaxUtils.skipWS(xMLStreamReader);
            string3 = n == 4 ? xMLStreamReader.getText() : null;
            StaxUtils.findEnd(xMLStreamReader, string, string2);
            xMLStreamReader.next();
        } else {
            string3 = null;
        }
        return string3;
    }

    public static String readElement(XMLStreamReader xMLStreamReader, String string, String string2) throws XMLStreamException {
        StaxUtils.readStart(xMLStreamReader, string, string2);
        String string3 = StaxUtils.readCharacters(xMLStreamReader);
        StaxUtils.readEnd(xMLStreamReader, string, string2);
        return string3;
    }

    public static int readEnd(XMLStreamReader xMLStreamReader, String string, String string2) throws XMLStreamException {
        StaxUtils.findEnd(xMLStreamReader, string, string2);
        if (xMLStreamReader.hasNext()) {
            return xMLStreamReader.nextTag();
        }
        return 8;
    }

    public static String readCharacters(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        StaxUtils.skipWS(xMLStreamReader);
        xMLStreamReader.require(4, null, null);
        String string = xMLStreamReader.getText();
        xMLStreamReader.next();
        return string;
    }

    public static int readStart(XMLStreamReader xMLStreamReader, String string, String string2) throws XMLStreamException {
        StaxUtils.findStart(xMLStreamReader, string, string2, true);
        return xMLStreamReader.next();
    }

    public static void writeNode(XMLStreamWriter xMLStreamWriter, Node node) throws XMLStreamException {
        if (node.getNodeType() == 9) {
            node = ((Document)node).getDocumentElement();
        }
        DOMStreamReader dOMStreamReader = new DOMStreamReader(node);
        ReaderToWriter readerToWriter = new ReaderToWriter(xMLStreamWriter);
        readerToWriter.writeSubTree((XMLStreamReader)dOMStreamReader);
    }

    public static boolean is(XMLStreamReader xMLStreamReader, QName qName) {
        return qName.getNamespaceURI().equals(xMLStreamReader.getNamespaceURI()) && qName.getLocalPart().equals(xMLStreamReader.getLocalName());
    }
}

