/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.wss;

import java.math.BigInteger;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.security.service.ContextHandler;
import weblogic.xml.crypto.dsig.api.keyinfo.X509IssuerSerial;
import weblogic.xml.crypto.utils.CertUtils;
import weblogic.xml.crypto.utils.DOMUtils;
import weblogic.xml.crypto.utils.KeyUtils;
import weblogic.xml.crypto.utils.LogUtils;
import weblogic.xml.crypto.wss.WSSConstants;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss.X509Credential;
import weblogic.xml.crypto.wss.api.BinarySecurityToken;
import weblogic.xml.crypto.wss.api.KeyIdentifier;
import weblogic.xml.crypto.wss.policy.ClaimsBuilder;
import weblogic.xml.dom.marshal.MarshalException;
import weblogic.xml.security.utils.Utils;

public class BSTUtils {
    private static final String POLICY_URI = "http://www.bea.com/wls90/security/policy";
    private static final QName POLICY_SUBJECT_NAME = new QName("http://www.bea.com/wls90/security/policy", "SubjectName");

    public static boolean matches(X509Credential x509Credential, ContextHandler contextHandler) {
        Object object;
        Object object2 = contextHandler.getValue("com.bea.contextelement.xml.IssuerSerial");
        if (object2 != null && !BSTUtils.matches((X509IssuerSerial)(object = (X509IssuerSerial)object2), x509Credential)) {
            return false;
        }
        object2 = contextHandler.getValue("com.bea.contextelement.xml.KeyIdentifier");
        if (object2 != null && !BSTUtils.matches((KeyIdentifier)(object = (KeyIdentifier)object2), x509Credential) && !BSTUtils.matchesThumbprint((KeyIdentifier)object, x509Credential)) {
            return false;
        }
        object2 = contextHandler.getValue("weblogic.wsee.security.wss11.thumbprint");
        if (object2 != null && !BSTUtils.matchesThumbprint((KeyIdentifier)(object = (KeyIdentifier)object2), x509Credential)) {
            return false;
        }
        object2 = contextHandler.getValue("weblogic.xml.crypto.wss.policy.Claims");
        if (object2 != null && !BSTUtils.matches((Node)(object = (Node)object2), x509Credential)) {
            return false;
        }
        object2 = contextHandler.getValue("weblogic.xml.crypto.keyinfo.keyname");
        return object2 == null || BSTUtils.matches((String)(object = (String)object2), x509Credential);
    }

    private static boolean matches(String string, X509Credential x509Credential) {
        X509Certificate x509Certificate = x509Credential.getCertificate();
        Principal principal = x509Certificate.getSubjectDN();
        String string2 = principal.getName();
        System.out.println("trying to match keyname " + string + " and subject dn principal name " + string2);
        if (string2.equals(string)) {
            return true;
        }
        LogUtils.logWss("X509 certificate's subject DN does not match keyname " + string);
        return false;
    }

    public static boolean matchesThumbprint(KeyIdentifier keyIdentifier, X509Credential x509Credential) {
        return x509Credential != null && BSTUtils.matchesThumbprint(x509Credential.getCertificate(), keyIdentifier.getIdentifier());
    }

    public static boolean matchesThumbprint(X509Certificate x509Certificate, byte[] byArray) {
        try {
            if (KeyUtils.matches(CertUtils.getThumbprint(x509Certificate), byArray)) {
                return true;
            }
        }
        catch (WSSecurityException wSSecurityException) {
            // empty catch block
        }
        LogUtils.logWss("X509 certificate's thumbprint does not match.");
        return false;
    }

    public static boolean matches(KeyIdentifier keyIdentifier, X509Credential x509Credential) {
        if (x509Credential == null) {
            return false;
        }
        X509Certificate x509Certificate = x509Credential.getCertificate();
        byte[] byArray = Utils.getSubjectKeyIdentifier(x509Certificate);
        if (KeyUtils.matches(keyIdentifier.getIdentifier(), byArray)) {
            return true;
        }
        LogUtils.logWss("X509 certificate's key identifier does not match.");
        return false;
    }

    public static boolean matches(X509IssuerSerial x509IssuerSerial, X509Credential x509Credential) {
        X509Certificate x509Certificate = x509Credential.getCertificate();
        BigInteger bigInteger = x509Certificate.getSerialNumber();
        if (!x509IssuerSerial.getSerialNumber().equals(bigInteger)) {
            LogUtils.logWss("X509 certificate's serial number " + bigInteger + " does not match " + x509IssuerSerial.getSerialNumber());
            return false;
        }
        return BSTUtils.matches(x509IssuerSerial.getIssuerName(), x509Certificate);
    }

    public static boolean matches(String string, X509Certificate x509Certificate) {
        boolean bl;
        String string2 = x509Certificate.getIssuerX500Principal().getName();
        String string3 = x509Certificate.getIssuerDN().getName();
        boolean bl2 = bl = BSTUtils.compareIssuerName(string, string2) || BSTUtils.compareIssuerName(string, string3);
        if (!bl) {
            LogUtils.logWss("X509 certificate's issuer name " + string2 + "/" + string3 + " does not match " + string);
        }
        return bl;
    }

    private static boolean compareIssuerName(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        if (string2 == null) {
            return false;
        }
        Object[] objectArray = string.replaceAll("\\s", "").split(",");
        Object[] objectArray2 = string2.replaceAll("\\s", "").split(",");
        Arrays.sort(objectArray);
        Arrays.sort(objectArray2);
        boolean bl = Arrays.equals(objectArray, objectArray2);
        if (bl || objectArray.length < 3 || objectArray2.length < 3) {
            return bl;
        }
        int n = string.indexOf(" S=");
        int n2 = string2.indexOf(" S=");
        if (n == -1 && n2 == -1) {
            return bl;
        }
        if (n != -1) {
            objectArray = BSTUtils.replace2ST((String[])objectArray);
        }
        if (n2 != -1) {
            objectArray2 = BSTUtils.replace2ST((String[])objectArray2);
        }
        return Arrays.equals(objectArray, objectArray2);
    }

    private static String[] replace2ST(String[] stringArray) {
        for (int i = stringArray.length - 1; i > 1; --i) {
            if (stringArray[i] == null || !stringArray[i].startsWith("S=")) continue;
            stringArray[i] = "ST=" + stringArray[i].substring(2);
            break;
        }
        return stringArray;
    }

    public static boolean matches(BinarySecurityToken binarySecurityToken, X509Credential x509Credential) {
        return X509Credential.matches((X509Credential)binarySecurityToken.getCredential(), x509Credential);
    }

    public static boolean matches(Node node, X509Credential x509Credential) {
        X509Certificate x509Certificate = x509Credential.getCertificate();
        String string = ClaimsBuilder.getClaimFromElt(node, POLICY_SUBJECT_NAME);
        if (string != null && !x509Certificate.getSubjectX500Principal().getName().equals(string)) {
            LogUtils.logWss("X509 certificate's subject name " + x509Certificate.getSubjectX500Principal().getName() + " does not match claims " + "subject name " + string);
            return false;
        }
        return true;
    }

    public static void marshalToken(BinarySecurityToken binarySecurityToken, Element element, Map map, Node node, boolean bl) throws MarshalException {
        String string;
        Map map2 = DOMUtils.getNamespaceMap(element);
        String string2 = (String)map.get("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        String string3 = (String)map.get("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        Element element2 = DOMUtils.createElement(element, WSSConstants.BST_QNAME, string2);
        DOMUtils.declareNamespace(element2, WSSConstants.BST_QNAME.getNamespaceURI(), string2);
        if (binarySecurityToken.getId() != null) {
            DOMUtils.addPrefixedAttribute(element2, WSSConstants.WSU_ID_QNAME, string3, binarySecurityToken.getId());
            DOMUtils.declareNamespace(element2, WSSConstants.WSU_ID_QNAME.getNamespaceURI(), string3, map2);
        }
        if ((string = binarySecurityToken.getValueType()) != null) {
            DOMUtils.addAttribute(element2, WSSConstants.VALUE_TYPE_QNAME, string);
        }
        if (bl) {
            DOMUtils.addAttribute(element2, WSSConstants.ENCODING_TYPE_QNAME, binarySecurityToken.getEncodingType());
        }
        String string4 = null;
        try {
            string4 = binarySecurityToken.getEncodedValue();
        }
        catch (WSSecurityException wSSecurityException) {
            throw new MarshalException("Failed to encode BinarySecurityToken.", wSSecurityException);
        }
        DOMUtils.addText(element2, string4);
        if (node != null) {
            element.insertBefore(element2, node);
        } else {
            element.appendChild(element2);
        }
    }

    public static boolean isX509Type(String string) {
        for (int i = 0; i < WSSConstants.BUILTIN_BST_VALUETYPES.length; ++i) {
            String string2 = WSSConstants.BUILTIN_BST_VALUETYPES[i];
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }
}

