/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.wss;

import java.security.AccessController;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.MessageContext;
import org.w3c.dom.Node;
import weblogic.security.KeyPairCredential;
import weblogic.security.PublicCertCredential;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.ContextHandler;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.wsee.security.serviceref.ServiceRefUtils;
import weblogic.xml.crypto.common.keyinfo.KeyProvider;
import weblogic.xml.crypto.common.keyinfo.KeyProviderFactory;
import weblogic.xml.crypto.dsig.api.keyinfo.X509IssuerSerial;
import weblogic.xml.crypto.utils.CertUtils;
import weblogic.xml.crypto.utils.LogUtils;
import weblogic.xml.crypto.wss.BSTUtils;
import weblogic.xml.crypto.wss.BinarySecurityTokenImpl;
import weblogic.xml.crypto.wss.BinarySecurityTokenReference;
import weblogic.xml.crypto.wss.SecurityTokenContextHandler;
import weblogic.xml.crypto.wss.SecurityTokenValidateResult;
import weblogic.xml.crypto.wss.SecurityUtils;
import weblogic.xml.crypto.wss.WSSConstants;
import weblogic.xml.crypto.wss.WSSecurityContext;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss.WSSecurityInfo;
import weblogic.xml.crypto.wss.WrapperCredentialProvider;
import weblogic.xml.crypto.wss.X509Credential;
import weblogic.xml.crypto.wss.api.BinarySecurityToken;
import weblogic.xml.crypto.wss.api.BinarySecurityTokenType;
import weblogic.xml.crypto.wss.api.KeyIdentifier;
import weblogic.xml.crypto.wss.provider.CredentialProvider;
import weblogic.xml.crypto.wss.provider.Purpose;
import weblogic.xml.crypto.wss.provider.SecurityToken;
import weblogic.xml.crypto.wss.provider.SecurityTokenHandler;
import weblogic.xml.crypto.wss.provider.SecurityTokenReference;
import weblogic.xml.crypto.wss11.internal.enckey.EncryptedKeyCredentialProvider;
import weblogic.xml.dom.marshal.MarshalException;

public class BinarySecurityTokenHandler
implements SecurityTokenHandler {
    private static final AuthenticatedSubject kernelID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private boolean isAuthorizationToken;
    private String valueType = null;

    public String[] getValueTypes() {
        return WSSConstants.BUILTIN_BST_VALUETYPES;
    }

    public KeyProvider getKeyProvider(SecurityToken securityToken, MessageContext messageContext) {
        return KeyProviderFactory.create((BinarySecurityToken)securityToken);
    }

    public SecurityToken getSecurityToken(SecurityTokenReference securityTokenReference, MessageContext messageContext) throws WSSecurityException {
        WSSecurityContext wSSecurityContext = WSSecurityContext.getSecurityContext(messageContext);
        String string = securityTokenReference.getValueType();
        List list = wSSecurityContext.getSecurityTokens();
        Purpose purpose = (Purpose)messageContext.getProperty("weblogic.xml.crypto.wss.provider.Purpose");
        String string2 = securityTokenReference.getReferenceURI();
        if (string2 != null) {
            return this.getTokenByURI(string2, list, purpose, wSSecurityContext);
        }
        KeyIdentifier keyIdentifier = securityTokenReference.getKeyIdentifier();
        if (keyIdentifier != null) {
            return this.getTokenByKeyId(keyIdentifier, string, securityTokenReference.getValueType(), list, purpose, wSSecurityContext);
        }
        X509IssuerSerial x509IssuerSerial = securityTokenReference.getIssuerSerial();
        if (x509IssuerSerial != null) {
            return this.getTokenByIssuerSerial(x509IssuerSerial, string, list, purpose, wSSecurityContext);
        }
        throw new WSSecurityException("Failed to resolve SecurityToken from STR " + securityTokenReference, WSSConstants.FAILURE_TOKEN_UNAVAILABLE);
    }

    protected SecurityToken getTokenByKeyId(KeyIdentifier keyIdentifier, String string, String string2, List list, Purpose purpose, WSSecurityContext wSSecurityContext) throws WSSecurityException {
        Object object2;
        for (Object object2 : list) {
            if (!(object2 instanceof BinarySecurityToken) || !BSTUtils.matches(keyIdentifier, (X509Credential)object2.getCredential())) continue;
            return this.amend((BinarySecurityToken)object2, purpose, wSSecurityContext);
        }
        Object object3 = this.getCredential("com.bea.contextelement.xml.KeyIdentifier", keyIdentifier, string, purpose, wSSecurityContext);
        if (object3 != null) {
            if (BSTUtils.matches(keyIdentifier, (X509Credential)object3)) {
                return this.getToken(object3, string, wSSecurityContext);
            }
            if (BSTUtils.matchesThumbprint(keyIdentifier, (X509Credential)object3)) {
                return this.getToken(object3, string, wSSecurityContext);
            }
        }
        if ((object2 = CertUtils.lookupCertificate(keyIdentifier.getIdentifier())) != null) {
            return this.getToken((X509Certificate)object2, string, wSSecurityContext);
        }
        throw new WSSecurityException("Failed to resolve security token from key identifier " + keyIdentifier, WSSConstants.FAILURE_TOKEN_UNAVAILABLE);
    }

    private SecurityToken getTokenByIssuerSerial(X509IssuerSerial x509IssuerSerial, String string, List list, Purpose purpose, WSSecurityContext wSSecurityContext) throws WSSecurityException {
        Object object2;
        for (Object object2 : list) {
            if (!(object2 instanceof BinarySecurityToken) || !BSTUtils.matches(x509IssuerSerial, (X509Credential)object2.getCredential())) continue;
            return this.amend((BinarySecurityToken)object2, purpose, wSSecurityContext);
        }
        Object object3 = this.getCredential("com.bea.contextelement.xml.IssuerSerial", x509IssuerSerial, string, purpose, wSSecurityContext);
        if (object3 != null && BSTUtils.matches(x509IssuerSerial, (X509Credential)object3)) {
            return this.getToken(object3, string, wSSecurityContext);
        }
        object2 = CertUtils.lookupCertificate(x509IssuerSerial.getIssuerName(), x509IssuerSerial.getSerialNumber());
        if (object2 != null) {
            return this.getToken((X509Certificate)object2, string, wSSecurityContext);
        }
        throw new WSSecurityException("Failed to resolve security token for issuer serial " + x509IssuerSerial, WSSConstants.FAILURE_TOKEN_UNAVAILABLE);
    }

    protected SecurityToken getToken(X509Certificate x509Certificate, String string, WSSecurityContext wSSecurityContext) throws WSSecurityException {
        SecurityToken securityToken = this.getToken(new X509Credential(x509Certificate), string, wSSecurityContext);
        return securityToken;
    }

    protected SecurityToken getToken(Object object, String string, WSSecurityContext wSSecurityContext) throws WSSecurityException {
        SecurityTokenHandler securityTokenHandler = wSSecurityContext.getRequiredTokenHandler(string);
        return securityTokenHandler.getSecurityToken(string, object, null);
    }

    protected Object getCredential(String string, Object object, String string2, Purpose purpose, WSSecurityContext wSSecurityContext) throws WSSecurityException {
        Object object2;
        CredentialProvider credentialProvider = null;
        ContextHandler contextHandler = this.getContextHandler(wSSecurityContext, string, object);
        LogUtils.logWss("--->Trying to get credential from token type = " + string2 + " and ctxElementName = " + string);
        if (("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#ThumbprintSHA1".equals(string2) || "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier".equals(string2)) && string != null && string.endsWith("KeyIdentifier")) {
            LogUtils.logWss("Changed token type from " + string2 + " to " + "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3");
            if (null == purpose) {
                purpose = Purpose.VERIFY;
            }
            if ((credentialProvider = wSSecurityContext.getRequiredCredentialProvider(string2 = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3")) instanceof WrapperCredentialProvider && (object2 = ((WrapperCredentialProvider)credentialProvider).getCredentialByKeyIdentifier(string2, null, contextHandler, purpose)) != null) {
                return object2;
            }
        } else {
            credentialProvider = wSSecurityContext.getRequiredCredentialProvider(string2);
        }
        object2 = credentialProvider.getCredential(string2, null, contextHandler, purpose);
        return object2;
    }

    private SecurityToken getTokenByURI(String string, List list, Purpose purpose, WSSecurityContext wSSecurityContext) throws WSSecurityException {
        String string2 = string.substring(1);
        for (SecurityToken securityToken : list) {
            if (!(securityToken instanceof BinarySecurityToken) || !string2.equals(securityToken.getId())) continue;
            return this.amend((BinarySecurityToken)securityToken, purpose, wSSecurityContext);
        }
        throw new WSSecurityException("Failed to retrieve token for reference URI " + string, WSSConstants.FAILURE_TOKEN_UNAVAILABLE);
    }

    public SecurityTokenValidateResult validateUnmarshalled(SecurityToken securityToken, MessageContext messageContext) throws WSSecurityException {
        SecurityTokenValidateResult securityTokenValidateResult = new SecurityTokenValidateResult(true);
        securityTokenValidateResult.setDefferedValidation(true);
        return securityTokenValidateResult;
    }

    public SecurityTokenValidateResult validateProcessed(SecurityToken securityToken, MessageContext messageContext) {
        BinarySecurityTokenType binarySecurityTokenType;
        List list;
        boolean bl = true;
        BinarySecurityToken binarySecurityToken = (BinarySecurityToken)securityToken;
        X509Certificate x509Certificate = ((BinarySecurityToken)securityToken).getCertificate();
        WSSecurityContext wSSecurityContext = WSSecurityContext.getSecurityContext(messageContext);
        boolean bl2 = false;
        List list2 = wSSecurityContext.getSignatures(securityToken);
        if (list2 != null && list2.size() > 0) {
            bl2 = true;
            if (!CertUtils.supportsSign(x509Certificate)) {
                bl = false;
            }
        } else if (wSSecurityContext.getIdTokens().contains(securityToken)) {
            bl = false;
        }
        if ((list = wSSecurityContext.getEncryptions(securityToken)) != null && list.size() > 0) {
            bl2 = true;
            if (!CertUtils.supportsKeyEncrypt(x509Certificate)) {
                bl = false;
            }
        }
        if (bl && bl2 && !(bl = (binarySecurityTokenType = BinarySecurityTokenImpl.getBSTType(securityToken.getValueType())).validate(binarySecurityToken, messageContext))) {
            return new SecurityTokenValidateResult(bl, binarySecurityToken.getCertificate());
        }
        if (bl) {
            binarySecurityToken.setValidated(true);
        }
        return new SecurityTokenValidateResult(bl);
    }

    protected SecurityToken amend(BinarySecurityToken binarySecurityToken, Purpose purpose, WSSecurityContext wSSecurityContext) throws WSSecurityException {
        String string = binarySecurityToken.getValueType();
        CredentialProvider credentialProvider = wSSecurityContext.getCredentialProvider(string);
        if (credentialProvider == null) {
            return binarySecurityToken;
        }
        ContextHandler contextHandler = this.getContextHandler(wSSecurityContext, "com.bea.contextelement.xml.SecurityToken", binarySecurityToken);
        Object object = credentialProvider.getCredential(string, null, contextHandler, purpose);
        if (object != null && BSTUtils.matches(binarySecurityToken, (X509Credential)object)) {
            SecurityTokenHandler securityTokenHandler = wSSecurityContext.getRequiredTokenHandler(string);
            SecurityToken securityToken = securityTokenHandler.getSecurityToken(string, object, contextHandler);
            securityToken.setId(binarySecurityToken.getId());
            return securityToken;
        }
        return binarySecurityToken;
    }

    public boolean matches(SecurityToken securityToken, String string, String string2, ContextHandler contextHandler, Purpose purpose) {
        if (securityToken == null) {
            return false;
        }
        Object object = securityToken.getCredential();
        if (object == null) {
            LogUtils.logWss("Unable to find credetail for token type " + string);
            return false;
        }
        WSSecurityContext wSSecurityContext = (WSSecurityContext)contextHandler.getValue("com.bea.contextelement.xml.SecurityInfo");
        if (object instanceof EncryptedKeyCredentialProvider || "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKeySHA1".equals(string) || "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey".equals(string)) {
            LogUtils.logWss("Checking Encrypted Key with token type " + string);
            if (Purpose.IDENTITY.equals(purpose) && !this.isAuthToken(securityToken, wSSecurityContext)) {
                LogUtils.logWss("X509 token is not a auth Token!");
                return false;
            }
            return true;
        }
        if (!(object instanceof X509Credential && ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3".equals(string) || "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v1".equals(string) || "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier".equals(string) || "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509PKIPathv1".equals(string) || "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#PKCS7".equals(string)))) {
            LogUtils.logWss("X509 token doesn't match. No token or wrong token type " + string);
            return false;
        }
        if (Purpose.IDENTITY.equals(purpose) && !this.isAuthToken(securityToken, wSSecurityContext)) {
            LogUtils.logWss("X509 token is not a auth Token!");
            return false;
        }
        X509Credential x509Credential = (X509Credential)securityToken.getCredential();
        if (Purpose.DECRYPT.equals(purpose) && x509Credential.getPrivateKey() == null) {
            LogUtils.logWss("X509 token doesn't match because purpose is DECRYPT and private key is null.");
            return false;
        }
        X509Certificate x509Certificate = x509Credential.getCertificate();
        if (Purpose.ENCRYPT.equals(purpose) && !CertUtils.supportsKeyEncrypt(x509Certificate)) {
            LogUtils.logWss("X509 token does not match because purpose is ENCRYPT but the certificate does not support key encryption.");
            return false;
        }
        if (Purpose.SIGN.equals(purpose) && !CertUtils.supportsSign(x509Certificate)) {
            LogUtils.logWss("X509 token does not match because purpose is SIGN butthe certificate does not support sign.");
            return false;
        }
        if (string2 != null && !x509Certificate.getIssuerX500Principal().getName().equals(string2)) {
            LogUtils.logWss("X509 token does not match because its issuerName " + x509Certificate.getIssuerX500Principal().getName() + " does not match required " + "issuerName " + string2);
            return false;
        }
        return BSTUtils.matches(x509Credential, contextHandler);
    }

    public SecurityToken getSecurityToken(String string, Object object, ContextHandler contextHandler) throws WSSecurityException {
        if (object == null) {
            return null;
        }
        return new BinarySecurityTokenImpl(string, object, contextHandler);
    }

    public SecurityToken getSecurityToken(String string, String string2, Purpose purpose, ContextHandler contextHandler) throws WSSecurityException {
        SecurityToken securityToken = this.getTokenFromContext(string, string2, purpose, contextHandler);
        if (securityToken == null) {
            securityToken = this.getTokenFromSubject(string, string2, purpose, contextHandler);
        }
        return securityToken;
    }

    private SecurityToken getTokenFromSubject(String string, String string2, Purpose purpose, ContextHandler contextHandler) throws WSSecurityException {
        Object object = null;
        if (purpose.equals(Purpose.ENCRYPT)) {
            LogUtils.logWss("Trying to get trusted cert credential from PKICredMapper.");
            object = ServiceRefUtils.getCredential(kernelID, "weblogic.pki.TrustedCertificate", string2, contextHandler);
            if (object != null) {
                PublicCertCredential publicCertCredential = (PublicCertCredential)object;
                object = new X509Credential((X509Certificate)publicCertCredential.getCertificate());
                return this.getSecurityToken(string, object, contextHandler);
            }
        } else {
            LogUtils.logWss("Trying to get key pair credential from PKICredMapper.");
            object = ServiceRefUtils.getCredential(kernelID, "weblogic.pki.Keypair", string2, contextHandler);
            if (object != null) {
                KeyPairCredential keyPairCredential = (KeyPairCredential)object;
                object = new X509Credential((X509Certificate)keyPairCredential.getCertificate(), (PrivateKey)keyPairCredential.getKey());
                return this.getSecurityToken(string, object, contextHandler);
            }
        }
        return null;
    }

    private SecurityToken getTokenFromContext(String string, String string2, Purpose purpose, ContextHandler contextHandler) {
        LogUtils.logWss("Trying to get token for token type " + string + " and purpose " + purpose + " from context.");
        WSSecurityInfo wSSecurityInfo = (WSSecurityInfo)contextHandler.getValue("com.bea.contextelement.xml.SecurityInfo");
        List list = wSSecurityInfo.getSecurityTokens();
        if (list == null) {
            return null;
        }
        for (SecurityToken securityToken : list) {
            if (!securityToken.getValueType().equals(string)) continue;
            PrivateKey privateKey = securityToken.getPrivateKey();
            if (Purpose.ENCRYPT.equals(purpose)) {
                if (privateKey == null) {
                    List list2 = wSSecurityInfo.getEncryptions(securityToken);
                    if (list2.size() != 0) {
                        LogUtils.logWss("Token for token type " + string + " from context " + "doesn't match because purpose is ENCRYPT and token has been " + "used to encrypt request.");
                        continue;
                    }
                } else {
                    LogUtils.logWss("Token for token type " + string + " from context" + " doesn't match because purpose is ENCRYPT and token contains " + "private key.");
                    continue;
                }
            }
            if (this.matches(securityToken, string, string2, contextHandler, purpose)) {
                LogUtils.logWss("Got token for token type " + string + " and purpose " + purpose + " from context.");
                return securityToken;
            }
            LogUtils.logWss("Token for token type " + string + " and purpose " + purpose + " from context doesn't match.");
        }
        return null;
    }

    public SecurityToken newSecurityToken(Node node) throws weblogic.xml.crypto.api.MarshalException {
        BinarySecurityTokenImpl binarySecurityTokenImpl = new BinarySecurityTokenImpl();
        try {
            binarySecurityTokenImpl.unmarshal(node);
        }
        catch (MarshalException marshalException) {
            throw new weblogic.xml.crypto.api.MarshalException("Failed to unmarshal BinarySecurityToken.", marshalException);
        }
        this.valueType = binarySecurityTokenImpl.getValueType();
        return binarySecurityTokenImpl;
    }

    public QName[] getQNames() {
        return WSSConstants.BUILTIN_BST_QNAMES;
    }

    public SecurityTokenReference getSTR(QName qName, String string, SecurityToken securityToken) throws WSSecurityException {
        if (securityToken == null) {
            return null;
        }
        return new BinarySecurityTokenReference(qName, string, securityToken);
    }

    public SecurityTokenReference newSecurityTokenReference(Node node) {
        return new BinarySecurityTokenReference();
    }

    public Subject getSubject(SecurityToken securityToken, MessageContext messageContext) throws WSSecurityException {
        WSSecurityContext wSSecurityContext = WSSecurityContext.getSecurityContext(messageContext);
        return this.getSubject(securityToken, wSSecurityContext);
    }

    public Subject getSubject(SecurityToken securityToken, WSSecurityContext wSSecurityContext) throws WSSecurityException {
        if (!this.isAuthToken(securityToken, wSSecurityContext)) {
            return null;
        }
        String string = SecurityServiceManager.getDefaultRealmName();
        BinarySecurityToken binarySecurityToken = (BinarySecurityToken)securityToken;
        X509Certificate[] x509CertificateArray = new X509Certificate[]{binarySecurityToken.getCertificate()};
        try {
            Subject subject = SecurityUtils.assertIdentity(x509CertificateArray, string).getSubject();
            if (null != subject) {
                wSSecurityContext.setProperty("BinarySecurityTokenHandler.AuthenticatedSubject.Cert", binarySecurityToken.getCertificate());
                LogUtils.logWss("BinarySecurityTokenHandler.AuthenticatedSubject.Cert saved for " + binarySecurityToken.getCertificate());
            }
            return subject;
        }
        catch (LoginException loginException) {
            throw new WSSecurityException("Failed to derive subject from token." + loginException, WSSConstants.FAILURE_AUTH);
        }
    }

    private boolean isAuthToken(SecurityToken securityToken, WSSecurityContext wSSecurityContext) {
        if (!this.isAuthorizationToken) {
            return false;
        }
        boolean bl = Boolean.getBoolean("weblogic.xml.crypto.wss.X509AuthWithoutSig");
        if (bl) {
            return true;
        }
        List list = wSSecurityContext.getSignatures(securityToken);
        return list != null && list.size() != 0;
    }

    public void setAuthorizationToken(boolean bl) {
        this.isAuthorizationToken = bl;
    }

    public boolean isAuthorizationToken() {
        return this.isAuthorizationToken;
    }

    protected ContextHandler getContextHandler(WSSecurityInfo wSSecurityInfo, String string, Object object) {
        SecurityTokenContextHandler securityTokenContextHandler = new SecurityTokenContextHandler(wSSecurityInfo);
        securityTokenContextHandler.addContextElement(string, object);
        return securityTokenContextHandler;
    }
}

