/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.wss;

import java.io.Serializable;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.security.service.ContextHandler;
import weblogic.utils.collections.ConcurrentHashMap;
import weblogic.xml.crypto.utils.CertUtils;
import weblogic.xml.crypto.utils.DOMUtils;
import weblogic.xml.crypto.wss.BSTUtils;
import weblogic.xml.crypto.wss.Base64Encoding;
import weblogic.xml.crypto.wss.SecurityTokenImpl;
import weblogic.xml.crypto.wss.WSSConstants;
import weblogic.xml.crypto.wss.WSSecurityConfigurationException;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss.X509CertPath;
import weblogic.xml.crypto.wss.X509V1BSTType;
import weblogic.xml.crypto.wss.X509V3BSTType;
import weblogic.xml.crypto.wss.api.BinarySecurityToken;
import weblogic.xml.crypto.wss.api.BinarySecurityTokenType;
import weblogic.xml.crypto.wss.api.Encoding;
import weblogic.xml.crypto.wss.provider.CredentialProvider;
import weblogic.xml.crypto.wss.provider.Purpose;
import weblogic.xml.crypto.wss.provider.SecurityTokenPolicyInfo;
import weblogic.xml.dom.marshal.MarshalException;

public class BinarySecurityTokenImpl
extends SecurityTokenImpl
implements BinarySecurityToken,
SecurityTokenPolicyInfo,
Serializable {
    private static final long serialVersionUID = -2889267257952778022L;
    private static String defaultEncoding = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary";
    private static String ID_PREFIX = "bst";
    private static final ConcurrentHashMap types = new ConcurrentHashMap();
    private static final ConcurrentHashMap encodings = new ConcurrentHashMap();
    private String id;
    private Object credentials;
    private byte[] decodedValue;
    private String encodedValue;
    private String valueType;
    private String encodingType = defaultEncoding;
    private BinarySecurityTokenType type;
    private boolean validated = false;

    public BinarySecurityTokenImpl() {
        this.type = (BinarySecurityTokenType)types.get((Object)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3");
        this.valueType = null != this.type && null != this.type.getValueType() ? this.type.getValueType() : "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3";
    }

    public BinarySecurityTokenImpl(String string, Object object, ContextHandler contextHandler) {
        if (object == null) {
            throw new IllegalArgumentException("Credential must not be null.");
        }
        this.valueType = string;
        this.type = (BinarySecurityTokenType)types.get((Object)string);
        if (this.type == null) {
            this.type = (BinarySecurityTokenType)types.get((Object)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3");
            this.valueType = this.type.getValueType();
        }
        this.credentials = object;
        this.id = DOMUtils.generateId(ID_PREFIX);
    }

    private static final void initTypes() {
        BinarySecurityTokenImpl.register(new X509V3BSTType());
        BinarySecurityTokenImpl.register(new X509V1BSTType());
        BinarySecurityTokenImpl.register(X509CertPath.getPKCS7());
        BinarySecurityTokenImpl.register(X509CertPath.getPKIPath());
    }

    public static void initEncodings() {
        encodings.put((Object)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary", (Object)new Base64Encoding());
    }

    public static void register(Encoding encoding) {
        encodings.put((Object)encoding.getURI(), (Object)encoding);
    }

    public static void register(BinarySecurityTokenType binarySecurityTokenType) {
        types.put((Object)binarySecurityTokenType.getValueType(), (Object)binarySecurityTokenType);
    }

    public static BinarySecurityTokenType getBSTType(String string) {
        return (BinarySecurityTokenType)types.get((Object)string);
    }

    public String getValueType() {
        return this.valueType;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public PrivateKey getPrivateKey() {
        return this.type.getPrivateKey(this.getCredential());
    }

    public PublicKey getPublicKey() {
        return this.type.getPublicKey(this.getCredential());
    }

    public Key getSecretKey() {
        return this.type.getSecretKey(this.getCredential());
    }

    public X509Certificate getCertificate() {
        return this.type.getCertificate(this.getCredential());
    }

    public Object getCredential() {
        if (this.credentials == null) {
            this.credentials = this.type.getCredentials(this.decodedValue);
        }
        return this.credentials;
    }

    public String getEncodedValue() throws WSSecurityException {
        if (this.encodedValue == null) {
            this.encodedValue = ((Encoding)encodings.get((Object)this.getEncodingType())).encode(this.getDecodedValue());
        }
        return this.encodedValue;
    }

    public byte[] getDecodedValue() throws WSSecurityException {
        if (this.decodedValue == null) {
            this.decodedValue = ((BinarySecurityTokenType)types.get((Object)this.valueType)).getUnencodedValue(this.credentials);
        }
        return this.decodedValue;
    }

    public String getEncodingType() {
        return this.encodingType;
    }

    public void marshal(Element element, Node node, Map map) throws MarshalException {
        BSTUtils.marshalToken(this, element, map, node, true);
    }

    public void unmarshal(Node node) throws MarshalException {
        Element element = (Element)node;
        this.setId(DOMUtils.getAttributeValue(element, WSSConstants.WSU_ID_QNAME));
        this.valueType = DOMUtils.getAttributeValue(element, WSSConstants.VALUE_TYPE_QNAME);
        if (this.valueType == null) {
            throw new MarshalException("Attribute " + WSSConstants.VALUE_TYPE_QNAME + " required in " + WSSConstants.BST_QNAME);
        }
        this.type = (BinarySecurityTokenType)types.get((Object)this.valueType);
        String string = DOMUtils.getAttributeValue(element, WSSConstants.ENCODING_TYPE_QNAME);
        if (string != null) {
            this.encodingType = string;
        }
        this.encodedValue = DOMUtils.getText((Element)node);
        this.decodedValue = ((Encoding)encodings.get((Object)this.encodingType)).decode(this.encodedValue);
        this.validated = false;
    }

    public boolean isFeatureSupported(String string) {
        return false;
    }

    public boolean supports(Purpose purpose) {
        return true;
    }

    public Element getSecurityTokenAssertion(Element element, Purpose purpose, ContextHandler contextHandler) throws WSSecurityConfigurationException {
        Object object;
        if (Purpose.IDENTITY.equals(purpose) && ((object = (Boolean)contextHandler.getValue("UseX509ForIdentity")) == null || !((Boolean)object).booleanValue())) {
            return null;
        }
        object = this.getTrustedCANames();
        String string = DOMUtils.getPrefix("http://www.bea.com/wls90/security/policy", element);
        Element element2 = DOMUtils.createAndAddElement(element, WSSConstants.POLICY_TOKEN_QNAME, string);
        DOMUtils.addAttribute(element2, WSSConstants.POLICY_TOKEN_TYPE_QNAME, this.getValueType());
        if (Purpose.SIGN.equals(purpose)) {
            DOMUtils.addAttribute(element2, WSSConstants.POLICY_INCLUDE_IN_MESSAGE_QNAME, "true");
            if (object != null) {
                Element element3 = DOMUtils.createAndAddElement(element2, WSSConstants.POLICY_TOKEN_ISSUER, string);
                DOMUtils.addText(element3, (String)object);
            }
        } else if (Purpose.ENCRYPT.equals(purpose)) {
            Element element4 = DOMUtils.createAndAddElement(element, new QName("http://www.bea.com/wls90/security/policy", "SecurityTokenReference"), string);
            Element element5 = DOMUtils.createAndAddElement(element4, new QName("http://www.bea.com/wls90/security/policy", "Embedded"), string);
            List list = null;
            try {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse");
                hashMap.put("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu");
                list = (List)contextHandler.getValue("com.bea.contextelement.wsee.credentialProviders");
                if (list == null) {
                    throw new WSSecurityConfigurationException("com.bea.contextelement.wsee.credentialProviders can not be found from the context handler");
                }
                for (CredentialProvider credentialProvider : list) {
                    Object object2 = credentialProvider.getCredential(this.getValueType(), null, contextHandler, purpose);
                    if (object2 == null) continue;
                    this.credentials = object2;
                    break;
                }
                if (this.credentials == null) {
                    throw new WSSecurityConfigurationException("Can not resolve credentials for encryption during customizing the abstract policy. \nPlease check the credential providers " + list);
                }
                this.marshal(element5, null, hashMap);
            }
            catch (MarshalException marshalException) {
                throw new WSSecurityConfigurationException(marshalException.getMessage());
            }
        }
        return element2;
    }

    private String getTrustedCANames() throws WSSecurityConfigurationException {
        X509Certificate[] x509CertificateArray = CertUtils.getTrustedCAs();
        if (x509CertificateArray.length == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            X509Certificate x509Certificate = x509CertificateArray[i];
            String string = x509Certificate.getSubjectX500Principal().getName();
            stringBuffer.append(string);
            stringBuffer.append(',');
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.getValueType() + " [id: " + this.getId() + ", cert: [" + this.getCertificate() + "]]";
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof BinarySecurityToken)) {
            return false;
        }
        BinarySecurityToken binarySecurityToken = (BinarySecurityToken)object;
        return binarySecurityToken.getCertificate().equals(this.getCertificate());
    }

    public int hashCode() {
        return this.getCertificate().hashCode();
    }

    public void setValidated(boolean bl) {
        this.validated = bl;
    }

    public boolean isValidated() {
        return this.validated;
    }

    static {
        BinarySecurityTokenImpl.initEncodings();
        BinarySecurityTokenImpl.initTypes();
    }
}

