/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.wss;

import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.xml.crypto.dsig.DsigConstants;
import weblogic.xml.crypto.dsig.WLXMLStructure;
import weblogic.xml.crypto.dsig.api.XMLSignatureException;
import weblogic.xml.crypto.dsig.api.XMLSignatureFactory;
import weblogic.xml.crypto.dsig.api.keyinfo.KeyInfoFactory;
import weblogic.xml.crypto.dsig.api.keyinfo.X509Data;
import weblogic.xml.crypto.dsig.api.keyinfo.X509IssuerSerial;
import weblogic.xml.crypto.dsig.keyinfo.X509DataImpl;
import weblogic.xml.crypto.dsig.keyinfo.X509IssuerSerialImpl;
import weblogic.xml.crypto.utils.DOMUtils;
import weblogic.xml.crypto.utils.LogUtils;
import weblogic.xml.crypto.wss.BSTEncodingException;
import weblogic.xml.crypto.wss.BinarySecurityTokenHandler;
import weblogic.xml.crypto.wss.BinarySecurityTokenImpl;
import weblogic.xml.crypto.wss.KeyIdentifierImpl;
import weblogic.xml.crypto.wss.SecurityTokenReferenceImpl;
import weblogic.xml.crypto.wss.WSSConstants;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss.api.BinarySecurityToken;
import weblogic.xml.crypto.wss.api.BinarySecurityTokenType;
import weblogic.xml.crypto.wss.provider.SecurityToken;
import weblogic.xml.dom.DOMStreamReader;
import weblogic.xml.dom.DOMStreamWriter;
import weblogic.xml.dom.marshal.MarshalException;

public class BinarySecurityTokenReference
extends SecurityTokenReferenceImpl {
    public static final String VERBOSE_PROPERTY = "weblogic.xml.crypto.wss.verbose";
    public static final boolean VERBOSE = Boolean.getBoolean("weblogic.xml.crypto.wss.verbose");
    private X509Data x509Data = null;
    private X509IssuerSerial issuerSerial = null;
    private static final String DEFAULT_VALUE_TYPE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3";
    private boolean useIssuerSerial = false;

    public BinarySecurityTokenReference() {
        this.setValueType(DEFAULT_VALUE_TYPE);
    }

    public BinarySecurityTokenReference(QName qName, String string, SecurityToken securityToken) throws WSSecurityException {
        super(qName, string, securityToken);
        if (VERBOSE) {
            LogUtils.logWss("STRType =" + qName.toString() + " Value Type =" + string + " useIssuerSerial =" + this.useIssuerSerial);
        }
        this.init(qName, string, securityToken);
    }

    protected void init(QName qName, String string, SecurityToken securityToken) throws WSSecurityException {
        if (WSSConstants.KEY_IDENTIFIER_QNAME.equals(qName)) {
            if (this.useIssuerSerial) {
                this.initIssuerSerial(securityToken);
            } else {
                try {
                    this.initKeyIdentifier(string, securityToken);
                    LogUtils.logWss("Got Key Identifier STR OK for value type =" + string + " for token id =" + securityToken.getId() + " value type =" + securityToken.getValueType());
                }
                catch (WSSecurityException wSSecurityException) {
                    LogUtils.logWss("BinarySecurityTokenReference init error on KeyIdentifier, " + wSSecurityException.getMessage() + " Try IssuerSerial");
                    this.initIssuerSerial(securityToken);
                }
            }
        } else if (DsigConstants.X509ISSUER_SERIAL_QNAME.equals(qName)) {
            this.initIssuerSerial(securityToken);
        }
    }

    private void initKeyIdentifier(String string, SecurityToken securityToken) throws WSSecurityException {
        BinarySecurityTokenType binarySecurityTokenType = BinarySecurityTokenImpl.getBSTType(string);
        if (null == binarySecurityTokenType) {
            LogUtils.logWss("BinarySecurityTokenReference initKeyIdentifier error, Invalid value type " + string + " for BST");
            throw new WSSecurityException("Invalid value type " + string + " for BST");
        }
        String string2 = binarySecurityTokenType.getKeyIdentifierValueType();
        KeyIdentifierImpl keyIdentifierImpl = null;
        byte[] byArray = null;
        try {
            byArray = BinarySecurityTokenImpl.getBSTType(string).getKeyIdRefValue(securityToken);
            if (byArray == null) {
                throw new WSSecurityException("Failed to create KeyIdentifier STR for BST, for value type =" + string + "  for token id =" + securityToken.getId() + " value type =" + securityToken.getValueType() + " and keyIdValueType = " + string2);
            }
            this.setValueType(string2);
            keyIdentifierImpl = new KeyIdentifierImpl(byArray);
        }
        catch (BSTEncodingException bSTEncodingException) {
            LogUtils.logWss("BinarySecurityTokenReference initKeyIdentifier error, error =" + bSTEncodingException.toString());
            bSTEncodingException.printStackTrace(System.err);
            throw new WSSecurityException(bSTEncodingException);
        }
        this.setKeyIdentifier(keyIdentifierImpl);
    }

    private void initIssuerSerial(SecurityToken securityToken) throws WSSecurityException {
        try {
            BinarySecurityToken binarySecurityToken = (BinarySecurityToken)securityToken;
            X509Certificate x509Certificate = binarySecurityToken.getCertificate();
            KeyInfoFactory keyInfoFactory = XMLSignatureFactory.getInstance().getKeyInfoFactory();
            String string = x509Certificate.getIssuerX500Principal().getName();
            BigInteger bigInteger = x509Certificate.getSerialNumber();
            this.issuerSerial = keyInfoFactory.newX509IssuerSerial(string, bigInteger);
            ArrayList<X509IssuerSerial> arrayList = new ArrayList<X509IssuerSerial>();
            arrayList.add(this.issuerSerial);
            this.x509Data = keyInfoFactory.newX509Data(Collections.unmodifiableList(arrayList));
            this.setValueType(securityToken.getValueType());
            this.setSTRType(DsigConstants.X509ISSUER_SERIAL_QNAME);
        }
        catch (XMLSignatureException xMLSignatureException) {
            throw new WSSecurityException(xMLSignatureException);
        }
    }

    static void init() {
        BinarySecurityTokenReference.register(new BinarySecurityTokenHandler());
    }

    public boolean isFeatureSupported(String string) {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void unmarshal(Node node) throws MarshalException {
        Element element = DOMUtils.getLastElement(node);
        try {
            DOMStreamReader dOMStreamReader = new DOMStreamReader(element);
            if (DOMUtils.is(element, DsigConstants.X509DATA_QNAME)) {
                super.unmarshalInternal(node);
                this.x509Data = (X509DataImpl)X509DataImpl.readKeyInfoObject(dOMStreamReader);
                Object e = this.x509Data.getContent().get(0);
                if (!(e instanceof X509IssuerSerial)) throw new MarshalException("Invalid content in SecurityTokenReferrence/X509Data.");
                this.issuerSerial = (X509IssuerSerial)e;
                return;
            } else if (DOMUtils.is(element, DsigConstants.X509ISSUER_SERIAL_QNAME)) {
                super.unmarshalInternal(node);
                X509IssuerSerialImpl x509IssuerSerialImpl = new X509IssuerSerialImpl();
                x509IssuerSerialImpl.read(dOMStreamReader, false);
                this.issuerSerial = x509IssuerSerialImpl;
                return;
            } else {
                super.unmarshal(node);
                if (this.getValueType() != null) return;
                this.setValueType(DEFAULT_VALUE_TYPE);
            }
            return;
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException("Failed to unmarshal SecurityTokenReference child " + DOMUtils.getQName(element) + ", " + xMLStreamException.getMessage(), xMLStreamException);
        }
        catch (weblogic.xml.crypto.api.MarshalException marshalException) {
            throw new MarshalException("Failed to unmarshal SecurityTokenReference child " + DOMUtils.getQName(element) + ", " + marshalException.getMessage(), marshalException);
        }
    }

    public void marshal(Element element, Node node, Map map) throws MarshalException {
        if (this.getSTRType().equals(DsigConstants.X509ISSUER_SERIAL_QNAME)) {
            try {
                this.marshalIssuerSerialRef(element, node, map);
            }
            catch (weblogic.xml.crypto.api.MarshalException marshalException) {
                throw new MarshalException(marshalException);
            }
        }
        super.marshal(element, node, map);
    }

    private void marshalIssuerSerialRef(Element element, Node node, Map map) throws weblogic.xml.crypto.api.MarshalException {
        String string = (String)map.get("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        String string2 = (String)map.get("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        Element element2 = DOMUtils.createElement(element, WSSConstants.STR_QNAME, string);
        if (this.getId() != null) {
            DOMUtils.addPrefixedAttribute(element2, WSSConstants.WSU_ID_QNAME, string2, this.getId());
        }
        if (node != null) {
            element.insertBefore(element2, node);
        } else {
            element.appendChild(element2);
        }
        DOMStreamWriter dOMStreamWriter = new DOMStreamWriter(element2.getOwnerDocument(), element2);
        ((WLXMLStructure)((Object)this.x509Data)).write((XMLStreamWriter)((Object)dOMStreamWriter));
    }

    public void unmarshalEmbeddedRef(Element element) throws MarshalException {
        BinarySecurityTokenImpl binarySecurityTokenImpl = new BinarySecurityTokenImpl();
        binarySecurityTokenImpl.unmarshal(element.getFirstChild());
    }

    public String toString() {
        return super.toString() + " URI: " + this.getId();
    }

    public X509IssuerSerial getIssuerSerial() {
        return this.issuerSerial;
    }
}

