/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.wss;

import weblogic.xml.crypto.wss.WSSConstants;
import weblogic.xml.crypto.wss.api.KeyIdentifier;

public class KeyIdentifierImpl
implements KeyIdentifier {
    private byte[] identifier;
    private String encoding;
    private static final String DEFAULT_ENCODING = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary";

    public KeyIdentifierImpl(byte[] byArray) {
        this(byArray, DEFAULT_ENCODING);
    }

    public KeyIdentifierImpl(byte[] byArray, String string) {
        this.identifier = byArray;
        if (string != null && !string.equals(DEFAULT_ENCODING)) {
            throw new IllegalArgumentException("Unsupported " + WSSConstants.ENCODING_TYPE_QNAME + ": " + string);
        }
        this.encoding = string;
    }

    public byte[] getIdentifier() {
        return this.identifier;
    }

    public String getEncodingType() {
        return this.encoding;
    }
}

