/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.wss;

import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.utils.io.UnsyncByteArrayOutputStream;
import weblogic.xml.crypto.NodeSetDataImpl;
import weblogic.xml.crypto.OctetData;
import weblogic.xml.crypto.api.Data;
import weblogic.xml.crypto.api.NodeSetData;
import weblogic.xml.crypto.api.XMLCryptoContext;
import weblogic.xml.crypto.dom.WLDOMSignContext;
import weblogic.xml.crypto.dsig.CanonicalizationMethodImpl;
import weblogic.xml.crypto.dsig.OctetTransform;
import weblogic.xml.crypto.dsig.TransformFactory;
import weblogic.xml.crypto.dsig.TransformImpl;
import weblogic.xml.crypto.dsig.WLCanonicalizationMethod;
import weblogic.xml.crypto.dsig.WLXMLStructure;
import weblogic.xml.crypto.dsig.api.CanonicalizationMethod;
import weblogic.xml.crypto.dsig.api.Transform;
import weblogic.xml.crypto.dsig.api.XMLSignatureException;
import weblogic.xml.crypto.dsig.api.spec.TransformParameterSpec;
import weblogic.xml.crypto.utils.DOMUtils;
import weblogic.xml.crypto.utils.DataUtils;
import weblogic.xml.crypto.utils.LogUtils;
import weblogic.xml.crypto.utils.StaxUtils;
import weblogic.xml.crypto.wss.BSTUtils;
import weblogic.xml.crypto.wss.SecurityTokenReferenceImpl;
import weblogic.xml.crypto.wss.WSSecurityContext;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss.api.BinarySecurityToken;
import weblogic.xml.crypto.wss.provider.SecurityToken;
import weblogic.xml.crypto.wss.provider.SecurityTokenReference;
import weblogic.xml.dom.marshal.MarshalException;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public class STRTransform
extends TransformImpl
implements OctetTransform,
TransformFactory {
    private static STRTransform exclC14nStrTransform = new STRTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
    private static STRTransform inclC14nStrTransform = new STRTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
    private CanonicalizationMethod c14nMethod;

    private STRTransform(String string) {
        try {
            this.c14nMethod = CanonicalizationMethodImpl.newCanonicalizationMethod(string + "_augmented");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalArgumentException(noSuchAlgorithmException);
        }
    }

    public static void init() {
        STRTransform.register(exclC14nStrTransform);
    }

    public static STRTransform getInstance() {
        return new STRTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
    }

    public String getAlgorithm() {
        return "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform";
    }

    public Data transform(Data data, XMLCryptoContext xMLCryptoContext) throws XMLSignatureException {
        Node node;
        Object object;
        NodeSetData nodeSetData = DataUtils.extractNodeSetData(data);
        Object object2 = null;
        Iterator iterator = nodeSetData.iterator();
        if (iterator.hasNext()) {
            object2 = (Node)iterator.next();
        }
        if (null == object2) {
            throw new XMLSignatureException("Null input STR node found. ");
        }
        boolean bl = false;
        if (xMLCryptoContext instanceof WLDOMSignContext && object2.getParentNode() == null) {
            Element element = ((WLDOMSignContext)((Object)xMLCryptoContext)).getXMLSignature().getSignatureNode();
            try {
                object = element.getOwnerDocument().adoptNode((Node)object2);
                if (null != object) {
                    LogUtils.logDsig("Good output STR node found after adoptNode into signatureNode: " + object);
                    object2 = object;
                } else {
                    LogUtils.logDsig("Try again, after Null Node found during signatureNode adoptNode process. Input was", object2);
                    object2 = element.getOwnerDocument().importNode((Node)object2, true);
                    nodeSetData = new NodeSetDataImpl(DOMUtils.getNodeSet((Node)object2, false));
                }
            }
            catch (Throwable throwable) {
                LogUtils.logDsig("Error during signatureNode adoptNode process. Exception =", throwable);
                object2 = element.getOwnerDocument().importNode((Node)object2, true);
                nodeSetData = new NodeSetDataImpl(DOMUtils.getNodeSet((Node)object2, false));
            }
            if (object2 == null) {
                throw new XMLSignatureException("Problem on import STR node to signature node. STR node was: " + object2);
            }
            element.appendChild((Node)object2);
            bl = true;
        }
        boolean bl2 = false;
        object = new LinkedHashMap();
        Object object3 = nodeSetData.iterator();
        while (object3.hasNext()) {
            node = (Node)object3.next();
            if (node.getNodeType() != 1) continue;
            if (!bl2 && "http://www.w3.org/2000/09/xmldsig#".equals(node.getNamespaceURI()) && "KeyInfo".equals(node.getLocalName())) {
                bl2 = true;
            }
            if (!"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(node.getNamespaceURI()) || !"SecurityTokenReference".equals(node.getLocalName())) continue;
            object.put(node, null);
        }
        if (object.isEmpty()) {
            throw new XMLSignatureException("Input node set for STR-Transform can not be empty.");
        }
        object3 = (WSSecurityContext)xMLCryptoContext.getProperty("weblogic.xml.crypto.wss.WSSecurityContext");
        if (object3 == null) {
            throw new IllegalArgumentException("WSSecurityContext must be set on XMLCryptoContext");
        }
        node = (MessageContext)((WSSecurityContext)object3).getProperty("javax.xml.rpc.handler.MessageContext");
        if (node == null) {
            throw new IllegalArgumentException("MessageContext must be set on WSSecurityContext");
        }
        try {
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            Object object8;
            SecurityToken securityToken;
            Object object922;
            for (Object object922 : object.keySet()) {
                securityToken = null;
                object8 = DOMUtils.getExistingId((Element)object922, ((WSSecurityContext)object3).getIdQNames());
                object7 = ((WSSecurityContext)object3).getSTR((String)object8);
                if (object7 != null) {
                    securityToken = object7.getSecurityToken();
                } else {
                    object7 = SecurityTokenReferenceImpl.createAndUnmarshal((Node)object922);
                    object6 = ((WSSecurityContext)object3).getRequiredTokenHandler(object7.getValueType());
                    securityToken = object6.getSecurityToken((SecurityTokenReference)object7, (MessageContext)node);
                }
                if (bl2) {
                    object6 = DOMUtils.getExistingId((Element)object2, ((WSSecurityContext)object3).getIdQNames());
                    ((WSSecurityContext)object3).addKeyInfo((String)object6, securityToken);
                } else {
                    ((WSSecurityContext)object3).addSTR((SecurityTokenReference)object7, securityToken);
                }
                object6 = ((WSSecurityContext)object3).getNode(securityToken);
                if (object6 == null) {
                    securityToken.setId(null);
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put(object922.getNamespaceURI(), object922.getPrefix());
                    if (securityToken instanceof BinarySecurityToken) {
                        BSTUtils.marshalToken((BinarySecurityToken)securityToken, (Element)object922.getParentNode(), hashMap, (Node)object922, false);
                    } else {
                        securityToken.marshal((Element)object922.getParentNode(), (Node)object922, null);
                    }
                } else {
                    Node node2 = object922.getParentNode().insertBefore(object6.cloneNode(true), (Node)object922);
                    object5 = DOMUtils.getNodeSet(object6, false);
                    object4 = DOMUtils.getNodeSet(node2, false);
                    Iterator iterator2 = object5.iterator();
                    HashSet<String> hashSet = new HashSet<String>();
                    Iterator iterator3 = object4.iterator();
                    while (iterator3.hasNext()) {
                        Node node3 = (Node)iterator2.next();
                        Node node4 = (Node)iterator3.next();
                        if (node4.getNodeType() != 1) {
                            if (node4.getNodeType() != 2) continue;
                        }
                        String string = node4.getPrefix();
                        if (node4.getNodeType() == 2 && ("xmlns".equals(node4.getNodeName()) || "xmlns".equals(string) || string == null || "".equals(string)) || hashSet.contains(string)) continue;
                        String string2 = node3.lookupNamespaceURI(string);
                        String string3 = node4.lookupNamespaceURI(string);
                        if (!(string2 == null && string3 == null || string2 == null || string2.equals(string3))) {
                            if (string == null || "".equals(string)) {
                                ((Element)node2).setAttribute("xmlns", string2);
                            }
                            DOMUtils.declareNamespace((Element)node2, string2, string);
                        }
                        hashSet.add(string);
                    }
                }
                Node object10 = object922.getPreviousSibling();
                object922.getParentNode().removeChild((Node)object922);
                object.put(object922, object10);
            }
            HashSet hashSet = new HashSet();
            object922 = object.values().iterator();
            while (object922.hasNext()) {
                hashSet.add(((Node)object922.next()).getNodeName());
            }
            ((WLCanonicalizationMethod)this.c14nMethod).setAugmentedElementTracks(hashSet);
            object922 = object2;
            if (object.keySet().contains(object922)) {
                object922 = (Node)object.get(object922);
            }
            securityToken = DOMUtils.getXMLInputStream((Node)object922);
            object8 = DOMUtils.getNamespaceMap((Node)object922);
            object7 = new OctetData(this.c14n((XMLInputStream)securityToken, (Map)object8));
            for (Map.Entry entry : object.entrySet()) {
                object5 = (Node)entry.getKey();
                object4 = (Node)entry.getValue();
                object4.getParentNode().insertBefore((Node)object5, (Node)object4);
                object4.getParentNode().removeChild((Node)object4);
            }
            if (bl) {
                object6 = ((WLDOMSignContext)((Object)xMLCryptoContext)).getXMLSignature().getSignatureNode();
                object6.removeChild((Node)object2);
            }
            return object7;
        }
        catch (MarshalException marshalException) {
            throw new XMLSignatureException(marshalException);
        }
        catch (WSSecurityException wSSecurityException) {
            throw new XMLSignatureException(wSSecurityException);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new XMLSignatureException("Failed to obtain InputStream of STR-Transform result.", xMLStreamException);
        }
    }

    public void readParameters(XMLStreamReader xMLStreamReader) throws weblogic.xml.crypto.api.MarshalException {
        try {
            xMLStreamReader.nextTag();
            xMLStreamReader.require(1, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "TransformationParameters");
            xMLStreamReader.nextTag();
            String string = StaxUtils.getAttributeValue("http://www.w3.org/2000/09/xmldsig#", "Algorithm", xMLStreamReader);
            this.c14nMethod = CanonicalizationMethodImpl.newCanonicalizationMethod(string + "_augmented");
            ((WLXMLStructure)((Object)this.c14nMethod)).read(xMLStreamReader);
            xMLStreamReader.nextTag();
            StaxUtils.findEnd(xMLStreamReader, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "TransformationParameters");
        }
        catch (javax.xml.stream.XMLStreamException xMLStreamException) {
            throw new weblogic.xml.crypto.api.MarshalException("Failed to read Transform " + this.getAlgorithm() + ".", xMLStreamException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new weblogic.xml.crypto.api.MarshalException("Failed to read CanonicalizationMethod Transform " + this.getAlgorithm() + ".", noSuchAlgorithmException);
        }
    }

    public void writeParameters(XMLStreamWriter xMLStreamWriter) throws weblogic.xml.crypto.api.MarshalException {
        try {
            xMLStreamWriter.writeStartElement("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "TransformationParameters");
            ((WLXMLStructure)((Object)this.c14nMethod)).write(xMLStreamWriter);
            xMLStreamWriter.writeEndElement();
        }
        catch (javax.xml.stream.XMLStreamException xMLStreamException) {
            throw new weblogic.xml.crypto.api.MarshalException("Failed to write element Transform", xMLStreamException);
        }
    }

    private byte[] c14n(XMLInputStream xMLInputStream, Map map) throws XMLSignatureException {
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        XMLOutputStream xMLOutputStream = ((WLCanonicalizationMethod)this.c14nMethod).canonicalize((OutputStream)unsyncByteArrayOutputStream, map);
        try {
            xMLOutputStream.add(xMLInputStream);
            xMLOutputStream.close(true);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new XMLSignatureException("canonicalization error", xMLStreamException);
        }
        byte[] byArray = unsyncByteArrayOutputStream.toByteArray();
        return byArray;
    }

    public Transform newTransform(TransformParameterSpec transformParameterSpec) throws InvalidAlgorithmParameterException {
        return new STRTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
    }

    public String getURI() {
        return "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform";
    }
}

