/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.wss;

import java.security.Key;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.rpc.handler.MessageContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.ContextHandler;
import weblogic.xml.crypto.api.KeySelector;
import weblogic.xml.crypto.api.KeySelectorException;
import weblogic.xml.crypto.api.KeySelectorResult;
import weblogic.xml.crypto.api.MarshalException;
import weblogic.xml.crypto.api.XMLStructure;
import weblogic.xml.crypto.common.keyinfo.KeyProvider;
import weblogic.xml.crypto.dsig.ReferenceUtils;
import weblogic.xml.crypto.dsig.api.DigestMethod;
import weblogic.xml.crypto.dsig.api.Reference;
import weblogic.xml.crypto.dsig.api.SignedInfo;
import weblogic.xml.crypto.dsig.api.XMLSignature;
import weblogic.xml.crypto.dsig.api.XMLSignatureFactory;
import weblogic.xml.crypto.dsig.api.keyinfo.KeyInfo;
import weblogic.xml.crypto.dsig.api.keyinfo.KeyInfoFactory;
import weblogic.xml.crypto.encrypt.EncryptionAlgorithm;
import weblogic.xml.crypto.encrypt.ReferenceList;
import weblogic.xml.crypto.encrypt.api.DataReference;
import weblogic.xml.crypto.encrypt.api.EncryptedData;
import weblogic.xml.crypto.encrypt.api.EncryptionMethod;
import weblogic.xml.crypto.encrypt.api.TBEKey;
import weblogic.xml.crypto.encrypt.api.TBEXML;
import weblogic.xml.crypto.encrypt.api.XMLEncryptionException;
import weblogic.xml.crypto.encrypt.api.XMLEncryptionFactory;
import weblogic.xml.crypto.encrypt.api.dom.DOMEncryptContext;
import weblogic.xml.crypto.encrypt.api.dom.DOMTBEXML;
import weblogic.xml.crypto.encrypt.api.keyinfo.EncryptedKey;
import weblogic.xml.crypto.utils.DOMUtils;
import weblogic.xml.crypto.utils.LogUtils;
import weblogic.xml.crypto.wss.SCTUtils;
import weblogic.xml.crypto.wss.STRTransform;
import weblogic.xml.crypto.wss.SecurityBuilder;
import weblogic.xml.crypto.wss.SecurityTokenContextHandler;
import weblogic.xml.crypto.wss.WSSConstants;
import weblogic.xml.crypto.wss.WSSecurityContext;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss.api.BinarySecurityToken;
import weblogic.xml.crypto.wss.api.Security;
import weblogic.xml.crypto.wss.api.Timestamp;
import weblogic.xml.crypto.wss.api.WSSecurityFactory;
import weblogic.xml.crypto.wss.provider.CredentialProvider;
import weblogic.xml.crypto.wss.provider.Purpose;
import weblogic.xml.crypto.wss.provider.SecurityToken;
import weblogic.xml.crypto.wss.provider.SecurityTokenHandler;
import weblogic.xml.crypto.wss.provider.SecurityTokenReference;

public class SecurityBuilderImpl
implements SecurityBuilder {
    protected static final String STR_ID_PREFIX = "str";
    protected WSSecurityContext securityCtx;
    protected Map namespaces;
    protected Set idQNames;
    private Timestamp timestamp;
    private List msgTokens = new ArrayList();
    private List ctxTokens = new ArrayList();
    protected Security security;
    private Map refs = new HashMap();
    private WSSecurityFactory sf = WSSecurityFactory.getInstance();

    public SecurityBuilderImpl(WSSecurityContext wSSecurityContext, Element element) {
        this.securityCtx = wSSecurityContext;
        this.namespaces = DOMUtils.getNSMap(element);
        this.idQNames = wSSecurityContext.getIdQNames();
    }

    public SecurityBuilderImpl(WSSecurityContext wSSecurityContext) {
        this.securityCtx = wSSecurityContext;
        this.namespaces = wSSecurityContext.getNamespaces();
        this.idQNames = wSSecurityContext.getIdQNames();
    }

    public XMLSignatureFactory getXMLSignatureFactory() {
        return this.securityCtx.getSignatureFactory();
    }

    private KeyInfoFactory getKeyInfoFactory() {
        return this.getXMLSignatureFactory().getKeyInfoFactory();
    }

    public XMLEncryptionFactory getXMLEncryptionFactory() {
        return this.securityCtx.getEncryptionFactory();
    }

    protected String getExisitingUri(Element element) {
        return DOMUtils.getExistingId(element, this.idQNames);
    }

    public String assignUri(Element element) throws WSSecurityException {
        if (element.isSameNode(element.getOwnerDocument().getDocumentElement())) {
            return "";
        }
        if ("http://www.w3.org/2000/09/xmldsig#".equals(element.getNamespaceURI()) || "http://www.w3.org/2001/04/xmlenc#".equals(element.getNamespaceURI())) {
            String string = null;
            if (element.hasAttributeNS("", "Id")) {
                string = element.getAttributeNS("", "Id");
            } else if (element.hasAttributeNS(null, "Id")) {
                string = element.getAttributeNS(null, "Id");
            } else {
                string = DOMUtils.generateId(element.getLocalName());
                element.setAttributeNS("", "Id", string);
            }
            return this.getUri(string);
        }
        String string = this.getExisitingUri(element);
        if (string != null && string.length() > 0) {
            return this.getUri(string);
        }
        String string2 = (String)this.namespaces.get("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        String string3 = WSSConstants.WSU_ID_QNAME.getNamespaceURI();
        String string4 = this.getUri(DOMUtils.assignId(element, WSSConstants.WSU_ID_QNAME, string2, this.idQNames));
        DOMUtils.declareNamespace(element, string3, string2);
        return string4;
    }

    public Reference createReference(String string, String string2, DigestMethod digestMethod, List list, boolean bl, ContextHandler contextHandler) throws WSSecurityException {
        return this.createReferenceInternal(string, null, string2, digestMethod, list, bl, contextHandler);
    }

    protected Reference createReferenceInternal(String string, List list, String string2, DigestMethod digestMethod, List list2, boolean bl, ContextHandler contextHandler) throws WSSecurityException {
        XMLStructure xMLStructure;
        boolean bl2;
        String string3 = null;
        XMLStructure xMLStructure2 = null;
        SecurityToken securityToken = this.getSecurityToken(string, string2, Purpose.SIGN, contextHandler);
        if (securityToken == null) {
            return null;
        }
        SecurityToken securityToken2 = this.getPreviousToken(securityToken);
        if (securityToken2 != null) {
            securityToken = securityToken2;
        }
        String string4 = securityToken.getId();
        boolean bl3 = bl2 = string != null && (string.startsWith("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile") || string.startsWith("http://docs.oasis-open.org/wss/2004/01/oasis-2004-01-saml-token-profile"));
        if ((bl || securityToken2 != null) && string4 != null && !bl2) {
            string3 = this.getUri(string4);
            xMLStructure2 = securityToken;
        } else {
            xMLStructure = this.getSTR(string, list, securityToken, false);
            String string5 = this.getSTRId((SecurityTokenReference)xMLStructure);
            this.securityCtx.addSTR(string5, (SecurityTokenReference)xMLStructure);
            string3 = this.getUri(string5);
            list2.add(0, STRTransform.getInstance());
            xMLStructure2 = xMLStructure;
        }
        try {
            if (bl) {
                this.addTokenToMessage(securityToken, contextHandler);
            }
        }
        catch (MarshalException marshalException) {
            throw new WSSecurityException("Failed to add target token for Reference.", marshalException);
        }
        xMLStructure = this.getXMLSignatureFactory().newReference(string3, digestMethod, ReferenceUtils.getTransforms(list2), null, null);
        this.refs.put(xMLStructure, xMLStructure2);
        return xMLStructure;
    }

    public Reference createSTRReference(SecurityToken securityToken, DigestMethod digestMethod, List arrayList, boolean bl) throws WSSecurityException {
        SecurityTokenReference securityTokenReference = this.getSTR(securityToken.getValueType(), securityToken, bl);
        String string = this.getSTRId(securityTokenReference);
        this.securityCtx.addSTR(string, securityTokenReference);
        String string2 = this.getUri(string);
        if (arrayList == null) {
            arrayList = new ArrayList<STRTransform>();
        }
        arrayList.add(0, STRTransform.getInstance());
        Reference reference = this.getXMLSignatureFactory().newReference(string2, digestMethod, ReferenceUtils.getTransforms(arrayList), null, null);
        return reference;
    }

    protected String getUri(String string) {
        return "#" + string;
    }

    private String getSTRId(SecurityTokenReference securityTokenReference) {
        String string = securityTokenReference.getId();
        if (string == null) {
            string = SecurityBuilderImpl.getId(STR_ID_PREFIX);
            securityTokenReference.setId(string);
        }
        return string;
    }

    public boolean addTimestamp(short s, ContextHandler contextHandler) throws WSSecurityException, MarshalException {
        if (this.timestamp != null) {
            throw new WSSecurityException("Timestamp already added to SecurityBuilder.");
        }
        this.timestamp = WSSecurityFactory.newTimestamp(null, true, s);
        this.add(this.timestamp, contextHandler);
        return true;
    }

    public SecurityToken createSecurityToken(String string, String string2, Purpose purpose, ContextHandler contextHandler) throws WSSecurityException, MarshalException {
        SecurityToken securityToken = this.getSecurityToken(string, string2, purpose, contextHandler);
        SecurityToken securityToken2 = this.getPreviousToken(securityToken);
        if (securityToken2 != null) {
            securityToken = securityToken2;
        }
        this.addToken(false, securityToken, contextHandler);
        return securityToken;
    }

    public SecurityToken addSecurityToken(String string, String string2, Purpose purpose, ContextHandler contextHandler) throws WSSecurityException, MarshalException {
        SecurityToken securityToken = this.getSecurityToken(string, string2, purpose, contextHandler);
        SecurityToken securityToken2 = this.getPreviousToken(securityToken);
        if (securityToken2 != null) {
            securityToken = securityToken2;
        }
        this.addTokenToMessage(securityToken, contextHandler);
        if (Purpose.IDENTITY.equals(purpose)) {
            this.addIdToken(securityToken);
        }
        return securityToken;
    }

    public Node addSignature(SignedInfo signedInfo, String string, String string2, boolean bl, ContextHandler contextHandler) throws WSSecurityException, MarshalException {
        return this.addSignatureInternal(signedInfo, string, null, string2, bl, contextHandler);
    }

    protected Node addSignatureInternal(SignedInfo signedInfo, String string, List list, String string2, boolean bl, ContextHandler contextHandler) throws WSSecurityException, MarshalException {
        SecurityTokenReference securityTokenReference;
        SecurityToken securityToken = this.getSecurityToken(string, string2, Purpose.SIGN, contextHandler);
        if (securityToken == null) {
            return null;
        }
        SecurityToken securityToken2 = this.getPreviousToken(securityToken);
        if (securityToken2 != null) {
            securityToken = securityToken2;
        }
        if ((securityTokenReference = this.getSTR(string, list, securityToken, bl)) == null) {
            throw new WSSecurityException("Failed to create reference for token: " + securityToken);
        }
        return this.addSignatureWithToken(signedInfo, securityTokenReference, bl, contextHandler);
    }

    public Node addSignature(SignedInfo signedInfo, Reference reference, ContextHandler contextHandler) throws WSSecurityException, MarshalException {
        return this.addSignatureInternal(signedInfo, reference, null, contextHandler);
    }

    protected Node addSignatureInternal(SignedInfo signedInfo, Reference reference, List list, ContextHandler contextHandler) throws WSSecurityException, MarshalException {
        Object v = this.refs.get(reference);
        SecurityToken securityToken = null;
        SecurityTokenReference securityTokenReference = null;
        if (v instanceof SecurityToken) {
            securityToken = (SecurityToken)v;
            String string = securityToken.getValueType();
            securityTokenReference = this.getSTR(string, list, securityToken, true);
        } else {
            securityTokenReference = (SecurityTokenReference)v;
            securityToken = securityTokenReference.getSecurityToken();
        }
        return this.addSignatureWithToken(signedInfo, securityTokenReference, false, contextHandler);
    }

    protected Node addSignatureWithToken(SignedInfo signedInfo, SecurityTokenReference securityTokenReference, Boolean bl, ContextHandler contextHandler) throws MarshalException, WSSecurityException {
        SecurityToken securityToken = securityTokenReference.getSecurityToken();
        KeyProvider keyProvider = this.getKeyProvider(securityToken);
        ArrayList<SecurityTokenReference> arrayList = new ArrayList<SecurityTokenReference>();
        arrayList.add(securityTokenReference);
        KeyInfo keyInfo = this.getXMLSignatureFactory().getKeyInfoFactory().newKeyInfo(arrayList);
        XMLSignature xMLSignature = this.getXMLSignatureFactory().newXMLSignature(signedInfo, keyInfo);
        Node node = this.addSignature(xMLSignature, keyProvider, contextHandler);
        if (bl != null) {
            this.addToken(bl, securityToken, contextHandler);
        }
        return node;
    }

    protected void addToken(boolean bl, SecurityToken securityToken, ContextHandler contextHandler) throws WSSecurityException, MarshalException {
        if (bl) {
            this.addTokenToMessage(securityToken, contextHandler);
        } else {
            this.addTokenToContext(securityToken);
        }
    }

    public boolean addEncryption(List list, EncryptionMethod encryptionMethod, EncryptionMethod encryptionMethod2, String string, String string2, boolean bl, ContextHandler contextHandler) throws WSSecurityException, MarshalException {
        return this.addEncryptionInternal(list, encryptionMethod, encryptionMethod2, string, null, string2, bl, contextHandler);
    }

    protected boolean addEncryptionInternal(List list, EncryptionMethod encryptionMethod, EncryptionMethod encryptionMethod2, String string, List list2, String string2, boolean bl, ContextHandler contextHandler) throws WSSecurityException, MarshalException {
        if (list == null || list.size() == 0) {
            throw new WSSecurityException("List of TBE must not be null or empty.");
        }
        boolean bl2 = encryptionMethod != null;
        SecurityToken securityToken = this.getToken(string, string2, contextHandler);
        SecurityTokenReference securityTokenReference = null;
        if (bl2) {
            securityTokenReference = this.createKeyIdSTRInternal(string, list2, securityToken, bl);
        } else {
            int n = this.msgTokens.indexOf(securityToken);
            if (n > -1) {
                securityToken = (SecurityToken)this.msgTokens.get(n);
            }
            securityTokenReference = this.getSTR(string, list2, securityToken, bl);
        }
        if (securityTokenReference == null) {
            throw new WSSecurityException("Failed to create reference for token: " + securityToken);
        }
        KeyInfo keyInfo = this.getKeyInfo(securityTokenReference);
        KeyProvider keyProvider = this.getKeyProvider(string, securityToken);
        KeySelector keySelector = this.securityCtx.getKeySelector();
        Key key = this.selectKey(keySelector, encryptionMethod2);
        if (key == null) {
            key = this.generateKey(encryptionMethod2);
        }
        DOMEncryptContext dOMEncryptContext = new DOMEncryptContext(key);
        List list3 = this.encryptData(list, dOMEncryptContext, encryptionMethod2, keyInfo, !bl2, contextHandler);
        if (bl2) {
            Key key2 = this.getKey(keySelector, keyProvider, encryptionMethod);
            this.addEncryptedKey(key, key2, encryptionMethod, keyInfo, list3, bl, securityToken, contextHandler);
        } else {
            this.addReferenceList(list3, securityToken, contextHandler, string, bl);
        }
        return true;
    }

    private Key selectKey(KeySelector keySelector, EncryptionMethod encryptionMethod) {
        KeySelectorResult keySelectorResult = null;
        Key key = null;
        try {
            keySelectorResult = keySelector.select(null, KeySelector.Purpose.ENCRYPT, encryptionMethod, null);
            if (keySelectorResult != null) {
                key = keySelectorResult.getKey();
            }
        }
        catch (KeySelectorException keySelectorException) {
            // empty catch block
        }
        return key;
    }

    protected Key generateKey(EncryptionMethod encryptionMethod) throws WSSecurityException {
        Key key;
        try {
            key = ((EncryptionAlgorithm)encryptionMethod).generateKey();
        }
        catch (XMLEncryptionException xMLEncryptionException) {
            throw new WSSecurityException("Failed to generate key for algorithm " + encryptionMethod.getAlgorithm());
        }
        return key;
    }

    protected KeyProvider getKeyProvider(String string, SecurityToken securityToken) throws WSSecurityException {
        SecurityTokenHandler securityTokenHandler = this.securityCtx.getRequiredTokenHandler(string);
        KeyProvider keyProvider = securityTokenHandler.getKeyProvider(securityToken, this.securityCtx.getMessageContext());
        if (keyProvider != null) {
            this.securityCtx.addKeyProvider(keyProvider);
        }
        return keyProvider;
    }

    protected KeyInfo getKeyInfo(SecurityTokenReference securityTokenReference) {
        ArrayList<SecurityTokenReference> arrayList = new ArrayList<SecurityTokenReference>();
        arrayList.add(securityTokenReference);
        KeyInfo keyInfo = this.getKeyInfoFactory().newKeyInfo(arrayList);
        return keyInfo;
    }

    protected SecurityToken getToken(String string, String string2, ContextHandler contextHandler) throws WSSecurityException {
        SecurityTokenContextHandler securityTokenContextHandler = SecurityBuilderImpl.getSecurityTokenContextHandler(contextHandler);
        this.copySubject(securityTokenContextHandler);
        Object object = this.getCredential(string, string2, securityTokenContextHandler, Purpose.ENCRYPT);
        SecurityToken securityToken = null;
        if (object != null) {
            SecurityTokenHandler securityTokenHandler = this.securityCtx.getRequiredTokenHandler(string);
            securityToken = securityTokenHandler.getSecurityToken(string, object, contextHandler);
        } else {
            securityToken = this.getToken(string, string2, contextHandler, Purpose.ENCRYPT);
            if (securityToken == null) {
                throw new WSSecurityException("Failed to get token for tokenType: " + string);
            }
        }
        return securityToken;
    }

    protected List encryptData(List list, DOMEncryptContext dOMEncryptContext, EncryptionMethod encryptionMethod, KeyInfo keyInfo, boolean bl, ContextHandler contextHandler) throws MarshalException, WSSecurityException {
        XMLEncryptionFactory xMLEncryptionFactory = this.getXMLEncryptionFactory();
        ArrayList<DataReference> arrayList = new ArrayList<DataReference>();
        for (TBEXML tBEXML : list) {
            String string = SecurityBuilderImpl.getId();
            EncryptedData encryptedData = xMLEncryptionFactory.newEncryptedData(tBEXML, encryptionMethod, bl ? keyInfo : null, null, string, null);
            this.encrypt(encryptedData, dOMEncryptContext, contextHandler);
            DataReference dataReference = this.getXMLEncryptionFactory().newDataReference("#" + string, null);
            arrayList.add(dataReference);
        }
        return arrayList;
    }

    protected EncryptedKey addEncryptedKey(Key key, Key key2, EncryptionMethod encryptionMethod, KeyInfo keyInfo, List list, String string, boolean bl, SecurityToken securityToken, ContextHandler contextHandler) throws WSSecurityException, MarshalException {
        TBEKey tBEKey = new TBEKey(key);
        EncryptedKey encryptedKey = this.getEncryptionFactory().newEncryptedKey(tBEKey, encryptionMethod, keyInfo, null, list, string, null, null, null);
        DOMEncryptContext dOMEncryptContext = new DOMEncryptContext(key2);
        this.addEncryptedKey(encryptedKey, dOMEncryptContext, contextHandler);
        this.msgTokens.add(encryptedKey);
        this.addToken(bl, securityToken, contextHandler);
        return encryptedKey;
    }

    protected void addEncryptedKey(Key key, Key key2, EncryptionMethod encryptionMethod, KeyInfo keyInfo, List list, boolean bl, SecurityToken securityToken, ContextHandler contextHandler) throws WSSecurityException, MarshalException {
        this.addEncryptedKey(key, key2, encryptionMethod, keyInfo, list, SecurityBuilderImpl.getId(), bl, securityToken, contextHandler);
    }

    protected Key getKey(KeySelector keySelector, KeyProvider keyProvider, EncryptionMethod encryptionMethod) throws WSSecurityException {
        KeySelectorResult keySelectorResult = null;
        try {
            keySelectorResult = keyProvider != null ? keyProvider.getKey(encryptionMethod.getAlgorithm(), KeySelector.Purpose.ENCRYPT) : keySelector.select(null, KeySelector.Purpose.ENCRYPT, encryptionMethod, null);
        }
        catch (KeySelectorException keySelectorException) {
            throw new WSSecurityException(keySelectorException);
        }
        if (keySelectorResult == null) {
            throw new WSSecurityException("Failed to select key for algorithm " + encryptionMethod.getAlgorithm());
        }
        Key key = keySelectorResult.getKey();
        return key;
    }

    protected XMLEncryptionFactory getEncryptionFactory() {
        return this.securityCtx.getEncryptionFactory();
    }

    private void copySubject(SecurityTokenContextHandler securityTokenContextHandler) {
        MessageContext messageContext = this.securityCtx.getMessageContext();
        if (messageContext != null) {
            AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)messageContext.getProperty("weblogic.wsee.wss.subject");
            securityTokenContextHandler.addContextElement("weblogic.wsee.wss.subject", authenticatedSubject);
        }
    }

    private void encrypt(EncryptedData encryptedData, DOMEncryptContext dOMEncryptContext, ContextHandler contextHandler) throws MarshalException, WSSecurityException {
        DOMTBEXML dOMTBEXML = (DOMTBEXML)encryptedData.getTBE();
        try {
            Node node = null;
            Node node2 = null;
            Node node3 = null;
            Node node4 = null;
            int n = dOMTBEXML.getNodeList().getLength();
            String string = dOMTBEXML.getType();
            if ("http://www.w3.org/2001/04/xmlenc#Element".equals(string)) {
                node = dOMTBEXML.getNodeList().item(0);
                node3 = node.getNextSibling();
                node4 = node.getParentNode();
            }
            encryptedData.encrypt(dOMEncryptContext);
            if ("http://www.w3.org/2001/04/xmlenc#Element".equals(string)) {
                node2 = node3 != null ? node3.getPreviousSibling() : node4.getLastChild();
                this.updateContext(node, node2, contextHandler);
                if (this.isHeader(node2)) {
                    this.processEncryptedHeader(node, node2);
                }
            }
        }
        catch (XMLEncryptionException xMLEncryptionException) {
            throw new WSSecurityException(xMLEncryptionException);
        }
    }

    private boolean isHeader(Node node) {
        return DOMUtils.is(node.getParentNode(), "http://schemas.xmlsoap.org/soap/envelope/", "Header") || DOMUtils.is(node.getParentNode(), "http://www.w3.org/2003/05/soap-envelope", "Header");
    }

    protected void processEncryptedHeader(Node node, Node node2) {
    }

    protected void updateContext(Node node, Node node2, ContextHandler contextHandler) {
        Node node3;
        SecurityTokenContextHandler securityTokenContextHandler = (SecurityTokenContextHandler)contextHandler;
        Node node4 = (Node)securityTokenContextHandler.getValue("weblogic.wsee.security.first_token_node");
        if (node4 != null && node4.equals(node)) {
            securityTokenContextHandler.addContextElement("weblogic.wsee.security.first_token_node", node2);
        }
        if ((node3 = (Node)securityTokenContextHandler.getValue("weblogic.wsee.security.last_token_node")) != null && node3.equals(node)) {
            securityTokenContextHandler.addContextElement("weblogic.wsee.security.last_token_node", node2);
        }
    }

    protected void addReferenceList(List list, SecurityToken securityToken, ContextHandler contextHandler) throws MarshalException, WSSecurityException {
        this.addReferenceList(list, securityToken, contextHandler, null, true);
    }

    private void addReferenceList(List list, SecurityToken securityToken, ContextHandler contextHandler, String string, boolean bl) throws MarshalException, WSSecurityException {
        if (string != null) {
            if (SCTUtils.isSCTokenTypeURI(string)) {
                if (bl) {
                    this.addTokenToMessage(securityToken, contextHandler);
                }
            } else {
                this.addTokenToMessage(securityToken, contextHandler);
            }
        } else {
            this.addTokenToMessage(securityToken, contextHandler);
        }
        this.add(new ReferenceList(list), contextHandler);
    }

    private SecurityToken getSecurityToken(String string, String string2, Purpose purpose, ContextHandler contextHandler) throws WSSecurityException {
        SecurityTokenContextHandler securityTokenContextHandler = SecurityBuilderImpl.getSecurityTokenContextHandler(contextHandler);
        Object object = this.getCredential(string, string2, securityTokenContextHandler, purpose);
        if (object == null) {
            return null;
        }
        SecurityToken securityToken = this.getSecurityToken(string, object, securityTokenContextHandler);
        return securityToken;
    }

    private KeyProvider getKeyProvider(SecurityToken securityToken) throws WSSecurityException {
        SecurityTokenHandler securityTokenHandler = this.securityCtx.getRequiredTokenHandler(securityToken.getValueType());
        return securityTokenHandler.getKeyProvider(securityToken, this.securityCtx.getMessageContext());
    }

    private Object getCredential(String string, String string2, SecurityTokenContextHandler securityTokenContextHandler, Purpose purpose) {
        LogUtils.logWss("Trying to get credential for token type " + string + " and purpose " + purpose + " from credential provider.");
        CredentialProvider credentialProvider = this.getCredentialProvider(string);
        if (credentialProvider == null) {
            LogUtils.logWss("No credential provider found for token type " + string);
            return null;
        }
        Object object = credentialProvider.getCredential(string, string2, securityTokenContextHandler, purpose);
        if (object != null) {
            LogUtils.logWss("Got credential for token type " + string + " and purpose " + purpose + " from credential provider " + credentialProvider);
        } else {
            LogUtils.logWss("No credential for token type " + string + " and purpose " + purpose + " from credential provider " + credentialProvider);
        }
        return object;
    }

    protected CredentialProvider getCredentialProvider(String string) {
        return this.securityCtx.getCredentialProvider(string);
    }

    private SecurityToken getSecurityToken(String string, Object object, SecurityTokenContextHandler securityTokenContextHandler) throws WSSecurityException {
        SecurityTokenHandler securityTokenHandler = this.securityCtx.getRequiredTokenHandler(string);
        SecurityToken securityToken = securityTokenHandler.getSecurityToken(string, object, securityTokenContextHandler);
        return securityToken;
    }

    private SecurityToken getToken(String string, String string2, ContextHandler contextHandler, Purpose purpose) throws WSSecurityException {
        LogUtils.logWss("Trying to get token for token type " + string + " and purpose " + purpose + " from token handler.");
        SecurityTokenHandler securityTokenHandler = this.securityCtx.getRequiredTokenHandler(string);
        SecurityToken securityToken = securityTokenHandler.getSecurityToken(string, string2, purpose, contextHandler);
        if (securityToken != null) {
            LogUtils.logWss("Got token for token type " + string + " and purpose " + purpose + " from token handler" + securityTokenHandler);
        } else {
            LogUtils.logWss("Did not get token for token type " + string + " and purpose " + purpose + " from token handler" + securityTokenHandler);
        }
        return securityToken;
    }

    protected SecurityTokenReference createDirectSTR(String string, SecurityToken securityToken) throws WSSecurityException {
        SecurityTokenHandler securityTokenHandler = this.securityCtx.getRequiredTokenHandler(string);
        SecurityTokenReference securityTokenReference = securityTokenHandler.getSTR(WSSConstants.REFERENCE_QNAME, string, securityToken);
        if (securityTokenReference == null) {
            LogUtils.logWss("Returned STR was null, returning null to caller");
            return null;
        }
        String string2 = securityTokenReference.getReferenceURI();
        if (string2 == null) {
            String string3 = securityToken.getId();
            if (string3 == null) {
                string3 = SecurityBuilderImpl.getId();
                securityToken.setId(string3);
            }
            securityTokenReference.setReferenceURI("#" + string3);
        }
        LogUtils.logWss("Token's ID is: " + securityToken.getId());
        LogUtils.logWss("STR's ID is: " + securityTokenReference.getId());
        LogUtils.logWss("STR's reference URI is: " + securityTokenReference.getReferenceURI());
        return securityTokenReference;
    }

    protected SecurityTokenReference getSTR(String string, List list, SecurityToken securityToken, boolean bl) throws WSSecurityException {
        return this.getSTR(string, securityToken, bl);
    }

    protected SecurityTokenReference getSTR(String string, SecurityToken securityToken, boolean bl) throws WSSecurityException {
        SecurityTokenReference securityTokenReference = null;
        if (bl) {
            securityTokenReference = this.createDirectSTR(string, securityToken);
        }
        if (securityTokenReference == null) {
            securityTokenReference = this.createKeyIdSTR(string, securityToken);
        }
        if (securityTokenReference != null && securityTokenReference.getId() == null) {
            securityTokenReference.setId(SecurityBuilderImpl.getId(STR_ID_PREFIX));
        }
        return securityTokenReference;
    }

    protected SecurityTokenReference createKeyIdSTRInternal(String string, List list, SecurityToken securityToken, boolean bl) throws WSSecurityException {
        return this.createKeyIdSTR(string, securityToken);
    }

    protected SecurityTokenReference createKeyIdSTR(String string, SecurityToken securityToken) throws WSSecurityException {
        SecurityTokenHandler securityTokenHandler = this.securityCtx.getRequiredTokenHandler(string);
        SecurityTokenReference securityTokenReference = securityTokenHandler.getSTR(WSSConstants.KEY_IDENTIFIER_QNAME, string, securityToken);
        return securityTokenReference;
    }

    private String assignId(SecurityToken securityToken) {
        String string = securityToken.getId();
        if (string == null) {
            string = SecurityBuilderImpl.getId();
            securityToken.setId(string);
        }
        return string;
    }

    protected static String getId(String string) {
        return DOMUtils.generateId(string);
    }

    private static String getId() {
        return DOMUtils.generateId();
    }

    private void add(XMLStructure xMLStructure, ContextHandler contextHandler) throws MarshalException, WSSecurityException {
        if (this.security == null) {
            this.createSecurity(this.securityCtx);
        }
        this.security.add(xMLStructure, null, contextHandler);
    }

    private Node addSignature(XMLSignature xMLSignature, KeyProvider keyProvider, ContextHandler contextHandler) throws MarshalException, WSSecurityException {
        if (this.security == null) {
            this.createSecurity(this.securityCtx);
        }
        return this.security.add(xMLSignature, keyProvider, contextHandler);
    }

    protected void addEncryptedKey(EncryptedKey encryptedKey, DOMEncryptContext dOMEncryptContext, ContextHandler contextHandler) throws MarshalException, WSSecurityException {
        if (this.security == null) {
            this.createSecurity(this.securityCtx);
        }
        this.security.add(encryptedKey, dOMEncryptContext, contextHandler);
    }

    protected void createSecurity(WSSecurityContext wSSecurityContext) throws MarshalException {
        WSSecurityFactory.getInstance();
        this.security = WSSecurityFactory.newSecurity(wSSecurityContext);
    }

    protected void addTokenToMessage(SecurityToken securityToken, ContextHandler contextHandler) throws WSSecurityException, MarshalException {
        if (securityToken != null) {
            int n = this.msgTokens.indexOf(securityToken);
            if (n < 0) {
                this.msgTokens.add(securityToken);
                this.assignId(securityToken);
                this.add(securityToken, contextHandler);
                if (securityToken instanceof BinarySecurityToken) {
                    this.moveToTop(securityToken);
                }
            } else {
                this.moveToTop((SecurityToken)this.msgTokens.get(n));
            }
        }
    }

    protected void addTokenToContext(SecurityToken securityToken) {
        if (!this.ctxTokens.contains(securityToken) && !this.msgTokens.contains(securityToken)) {
            this.securityCtx.addSecurityToken(securityToken);
        }
    }

    private void addIdToken(SecurityToken securityToken) {
        this.securityCtx.addIdToken(securityToken);
    }

    private SecurityToken getPreviousToken(SecurityToken securityToken) {
        int n = this.msgTokens.indexOf(securityToken);
        if (n >= 0) {
            return (SecurityToken)this.msgTokens.get(n);
        }
        return null;
    }

    protected void moveToTop(SecurityToken securityToken) {
        Node node = this.securityCtx.getNode(securityToken);
        if (null == node) {
            return;
        }
        Element element = this.securityCtx.getSecurityElement();
        if (null == element) {
            return;
        }
        Node node2 = element.getFirstChild();
        if (node2.equals(node)) {
            return;
        }
        element.removeChild(node);
        element.insertBefore(node, node2);
    }

    private static SecurityTokenContextHandler getSecurityTokenContextHandler(ContextHandler contextHandler) throws WSSecurityException {
        if (!(contextHandler instanceof SecurityTokenContextHandler)) {
            throw new WSSecurityException(contextHandler + " is not a SecurityTokenContextHandler");
        }
        SecurityTokenContextHandler securityTokenContextHandler = (SecurityTokenContextHandler)contextHandler;
        return securityTokenContextHandler;
    }
}

