/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.wss;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weblogic.security.service.ContextHandler;
import weblogic.wsee.security.saml.SAML2Constants;
import weblogic.wsee.security.saml.SAMLConstants;
import weblogic.xml.crypto.NodeURIDereferencer;
import weblogic.xml.crypto.api.KeySelector;
import weblogic.xml.crypto.api.KeySelectorResult;
import weblogic.xml.crypto.api.URIDereferencer;
import weblogic.xml.crypto.api.XMLCryptoContext;
import weblogic.xml.crypto.api.XMLStructure;
import weblogic.xml.crypto.common.keyinfo.EncryptedKeyProvider;
import weblogic.xml.crypto.common.keyinfo.KeyProvider;
import weblogic.xml.crypto.common.keyinfo.KeyResolver;
import weblogic.xml.crypto.dom.WLDOMSignContextImpl;
import weblogic.xml.crypto.dom.WLDOMValidateContextImpl;
import weblogic.xml.crypto.dsig.DsigConstants;
import weblogic.xml.crypto.dsig.XMLSignatureImpl;
import weblogic.xml.crypto.dsig.api.Reference;
import weblogic.xml.crypto.dsig.api.XMLSignature;
import weblogic.xml.crypto.dsig.api.XMLSignatureException;
import weblogic.xml.crypto.dsig.api.XMLSignatureFactory;
import weblogic.xml.crypto.encrypt.ReferenceList;
import weblogic.xml.crypto.encrypt.api.DataReference;
import weblogic.xml.crypto.encrypt.api.EncryptedData;
import weblogic.xml.crypto.encrypt.api.KeyReference;
import weblogic.xml.crypto.encrypt.api.ReferenceType;
import weblogic.xml.crypto.encrypt.api.XMLEncryptContext;
import weblogic.xml.crypto.encrypt.api.XMLEncryptionException;
import weblogic.xml.crypto.encrypt.api.XMLEncryptionFactory;
import weblogic.xml.crypto.encrypt.api.dom.DOMDecryptContext;
import weblogic.xml.crypto.encrypt.api.dom.DOMEncryptContext;
import weblogic.xml.crypto.encrypt.api.keyinfo.EncryptedKey;
import weblogic.xml.crypto.utils.DOMUtils;
import weblogic.xml.crypto.utils.LogUtils;
import weblogic.xml.crypto.wss.Encryption;
import weblogic.xml.crypto.wss.SecurityTokenContextHandler;
import weblogic.xml.crypto.wss.SecurityTokenValidateResult;
import weblogic.xml.crypto.wss.TimestampImpl;
import weblogic.xml.crypto.wss.WSSConstants;
import weblogic.xml.crypto.wss.WSSecurityContext;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss.api.Security;
import weblogic.xml.crypto.wss.api.Timestamp;
import weblogic.xml.crypto.wss.provider.SecurityToken;
import weblogic.xml.crypto.wss.provider.SecurityTokenHandler;
import weblogic.xml.crypto.wss.provider.SecurityTokenReference;
import weblogic.xml.crypto.wss11.internal.enckey.EncryptedKeyToken;
import weblogic.xml.dom.DOMStreamReader;
import weblogic.xml.dom.DOMStreamWriter;
import weblogic.xml.dom.marshal.MarshalException;
import weblogic.xml.dom.marshal.WLDOMStructure;

public class SecurityImpl
implements Security,
WLDOMStructure {
    public static final QName ENCRYPTED_KEY_QNAME = new QName("http://www.w3.org/2001/04/xmlenc#", "EncryptedKey");
    public static final QName ENCRYPTED_DATA_QNAME = new QName("http://www.w3.org/2001/04/xmlenc#", "EncryptedData");
    public static final QName REFERENCE_LIST_QNAME = new QName("http://www.w3.org/2001/04/xmlenc#", "ReferenceList");
    private static final String TRUE = "1";
    private static final String LOCAL_URI_PREFIX = "#";
    private static final String SIGNATURE_LOCALNAME = "Signature";
    private WSSecurityContext securityCtx;
    protected Element security;
    protected Map namespaces;
    protected Map elementHandlers = new HashMap();
    public static final String VERBOSE_PROPERTY = "weblogic.xml.crypto.wss.verbose";
    public static final boolean VERBOSE = Boolean.getBoolean("weblogic.xml.crypto.wss.verbose");

    public SecurityImpl() {
    }

    public SecurityImpl(WSSecurityContext wSSecurityContext) {
        this.securityCtx = wSSecurityContext;
    }

    public QName getActor() {
        return null;
    }

    private void processAndMarshal(ContextHandler contextHandler) throws weblogic.xml.crypto.api.MarshalException {
        if (this.securityCtx == null) {
            this.securityCtx = (WSSecurityContext)contextHandler.getValue("com.bea.contextelement.xml.SecurityInfo");
        }
        try {
            this.marshal((Element)this.securityCtx.getNode(), this.securityCtx.getNextSibling(), this.securityCtx.getNamespaces());
        }
        catch (MarshalException marshalException) {
            throw new weblogic.xml.crypto.api.MarshalException(marshalException);
        }
    }

    public void add(XMLStructure xMLStructure, XMLCryptoContext xMLCryptoContext, ContextHandler contextHandler) throws WSSecurityException, weblogic.xml.crypto.api.MarshalException {
        if (this.security == null) {
            this.processAndMarshal(contextHandler);
        }
        this.processAndMarshal(xMLStructure, xMLCryptoContext, contextHandler);
    }

    public Node add(XMLSignature xMLSignature, KeyProvider keyProvider, ContextHandler contextHandler) throws WSSecurityException, weblogic.xml.crypto.api.MarshalException {
        if (this.security == null) {
            this.processAndMarshal(contextHandler);
        }
        Node node = this.processAndMarshalSignature(xMLSignature, keyProvider, contextHandler);
        if (SecurityImpl.isEndoringEncryptSignature(contextHandler)) {
            DOMUtils.assignId((Element)node, new QName("", "Id"), "", this.securityCtx.getIdQNames());
            ((SecurityTokenContextHandler)contextHandler).addContextElement("weblogic.wsee.security.signature_node", node);
        }
        return node;
    }

    protected void processAndMarshal(XMLStructure xMLStructure, XMLCryptoContext xMLCryptoContext, ContextHandler contextHandler) throws WSSecurityException, weblogic.xml.crypto.api.MarshalException {
        if (xMLStructure instanceof Timestamp) {
            this.processAndMarshalTimestamp((Timestamp)xMLStructure, contextHandler);
        } else if (xMLStructure instanceof EncryptedKeyToken) {
            EncryptedKeyToken encryptedKeyToken = (EncryptedKeyToken)xMLStructure;
            DOMEncryptContext dOMEncryptContext = encryptedKeyToken.getDOMEncryptContext();
            if (dOMEncryptContext != null) {
                this.processAndMarshalEncryptedKey(encryptedKeyToken.getEncryptedKey(), dOMEncryptContext, contextHandler);
            } else {
                this.processAndMarshalSecurityToken(encryptedKeyToken, contextHandler);
            }
        } else if (xMLStructure instanceof SecurityToken) {
            this.processAndMarshalSecurityToken((SecurityToken)xMLStructure, contextHandler);
        } else if (xMLStructure instanceof EncryptedKey) {
            this.processAndMarshalEncryptedKey((EncryptedKey)xMLStructure, (XMLEncryptContext)xMLCryptoContext, contextHandler);
        } else if (xMLStructure instanceof SecurityTokenReference) {
            this.processAndMarshalSTR((SecurityTokenReference)xMLStructure, contextHandler);
        } else if (xMLStructure instanceof ReferenceList) {
            this.processAndMarshalReferenceList((ReferenceList)xMLStructure, contextHandler);
        }
    }

    private void processAndMarshalReferenceList(ReferenceList referenceList, ContextHandler contextHandler) throws weblogic.xml.crypto.api.MarshalException {
        Node node = this.findReferenceInsertBeforeNode(this.security, contextHandler);
        Document document = this.security.getOwnerDocument();
        DOMStreamWriter dOMStreamWriter = new DOMStreamWriter(document, this.security);
        List list = referenceList.getReferences();
        if (list != null && list.size() > 0) {
            ReferenceList.write((XMLStreamWriter)((Object)dOMStreamWriter), list);
        }
        Node node2 = this.security.getLastChild();
        if (node != null) {
            this.security.removeChild(node2);
            this.security.insertBefore(node2, node);
        }
    }

    private void processAndMarshalSTR(SecurityTokenReference securityTokenReference, ContextHandler contextHandler) throws weblogic.xml.crypto.api.MarshalException {
        try {
            Node node = this.findInsertBeforeNode(this.security, contextHandler, false);
            securityTokenReference.marshal(this.security, node, this.namespaces);
            SecurityImpl.getInsertedNode(this.security, contextHandler, node, false);
        }
        catch (MarshalException marshalException) {
            throw new weblogic.xml.crypto.api.MarshalException(marshalException);
        }
    }

    public void marshal(Element element, Node node, Map map) throws MarshalException {
        this.namespaces = map;
        String string = element != null ? element.getNamespaceURI() : null;
        boolean bl = "http://www.w3.org/2003/05/soap-envelope".equals(string);
        String string2 = (String)map.get("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        if (string2 == null) {
            string2 = "wsse";
        }
        try {
            this.security = SecurityImpl.getSecurityHeader(element, SecurityImpl.getRoleAttrName(null), SecurityImpl.getRole(null));
        }
        catch (WSSecurityException wSSecurityException) {
            throw new MarshalException(wSSecurityException);
        }
        if (this.security == null) {
            this.security = DOMUtils.createAndAddElement(element, WSSConstants.SECURITY_QNAME, string2);
            SecurityImpl.declareNamespaces(this.security, map);
            SecurityImpl.setMustUnderstand(this.security, map, bl);
        }
        if (node != null) {
            element.insertBefore(this.security, node);
        } else {
            element.appendChild(this.security);
        }
        if (this.securityCtx == null) {
            this.securityCtx = new WSSecurityContext(element, null, null, null);
        }
        this.securityCtx.setSecurityElement(this.security);
    }

    public static void setMustUnderstand(Element element, Map map, boolean bl) {
        if (bl) {
            String string = (String)map.get("http://www.w3.org/2003/05/soap-envelope");
            QName qName = new QName("http://www.w3.org/2003/05/soap-envelope", "mustUnderstand");
            DOMUtils.addPrefixedAttribute(element, qName, string, "true");
        } else {
            String string = (String)map.get("http://schemas.xmlsoap.org/soap/envelope/");
            DOMUtils.addPrefixedAttribute(element, WSSConstants.MUST_UNDERSTAND_QNAME, string, TRUE);
        }
    }

    private void processAndMarshalTimestamp(Timestamp timestamp, ContextHandler contextHandler) throws weblogic.xml.crypto.api.MarshalException {
        Node node = SecurityImpl.isTimestampFirst(contextHandler) ? this.security.getFirstChild() : this.security.getLastChild();
        try {
            timestamp.marshal(this.security, node, this.namespaces);
        }
        catch (MarshalException marshalException) {
            throw new weblogic.xml.crypto.api.MarshalException(marshalException);
        }
        if (SecurityImpl.isTimestampFirst(contextHandler)) {
            SecurityImpl.setFirstTokenNode(contextHandler, this.security.getFirstChild());
        }
    }

    private void processAndMarshalSecurityToken(SecurityToken securityToken, ContextHandler contextHandler) throws weblogic.xml.crypto.api.MarshalException, WSSecurityException {
        SecurityTokenHandler securityTokenHandler = this.securityCtx.getRequiredTokenHandler(securityToken.getValueType());
        KeyProvider keyProvider = securityTokenHandler.getKeyProvider(securityToken, this.securityCtx.getMessageContext());
        if (keyProvider != null) {
            this.securityCtx.addKeyProvider(keyProvider);
        }
        LogUtils.logWss("Adding KeyProvider (outbound) to WSSecurityContext: " + keyProvider + "\nfor token (type: " + securityToken.getValueType() + ") ", securityToken);
        try {
            Node node = this.findInsertBeforeNode(this.security, contextHandler, true);
            securityToken.marshal(this.security, node, this.namespaces);
            Element element = (Element)SecurityImpl.getInsertedNode(this.security, contextHandler, node, true);
            this.securityCtx.addSecurityToken(securityToken);
            this.securityCtx.addToken(securityToken, element);
        }
        catch (MarshalException marshalException) {
            throw new weblogic.xml.crypto.api.MarshalException(marshalException);
        }
    }

    private Node processAndMarshalSignature(XMLSignature xMLSignature, KeyProvider keyProvider, ContextHandler contextHandler) throws WSSecurityException, weblogic.xml.crypto.api.MarshalException {
        Node node = this.findSignatureInsertBeforeNode(this.security, xMLSignature, contextHandler);
        WLDOMSignContextImpl wLDOMSignContextImpl = new WLDOMSignContextImpl(null, this.security, node);
        KeyResolver keyResolver = new KeyResolver(new KeyProvider[]{keyProvider});
        wLDOMSignContextImpl.setKeySelector(keyResolver);
        try {
            Element element;
            wLDOMSignContextImpl.setProperty("weblogic.xml.crypto.wss.WSSecurityContext", this.securityCtx);
            if (SecurityImpl.isEndoringEncryptSignature(contextHandler) && null != (element = (Element)contextHandler.getValue("weblogic.wsee.security.signature_node"))) {
                wLDOMSignContextImpl.setProperty("weblogic.wsee.security.signature_node", element);
            }
            xMLSignature.sign(wLDOMSignContextImpl);
            this.securityCtx.addSignature(xMLSignature);
            return (Element)SecurityImpl.getInsertedNode(this.security, contextHandler, node, false);
        }
        catch (XMLSignatureException xMLSignatureException) {
            throw new WSSecurityException("Failed to process signature." + xMLSignatureException.getMessage(), xMLSignatureException);
        }
    }

    private void processAndMarshalEncryptedKey(EncryptedKey encryptedKey, XMLEncryptContext xMLEncryptContext, ContextHandler contextHandler) throws WSSecurityException, weblogic.xml.crypto.api.MarshalException {
        try {
            Node node = this.findInsertBeforeNode(this.security, contextHandler, true);
            ((DOMEncryptContext)xMLEncryptContext).setParent(this.security);
            ((DOMEncryptContext)xMLEncryptContext).setNextSibling(node);
            encryptedKey.encrypt(xMLEncryptContext);
            SecurityImpl.getInsertedNode(this.security, contextHandler, node, true);
        }
        catch (XMLEncryptionException xMLEncryptionException) {
            throw new WSSecurityException(xMLEncryptionException);
        }
    }

    public void unmarshal(Node node) throws MarshalException {
        if (node == null) {
            throw new MarshalException("Node to unmarshal security object from must not be null.");
        }
        if (this.securityCtx == null) {
            this.securityCtx = new WSSecurityContext(node);
        }
        this.unmarshalInternal(node);
    }

    public void unmarshal(WSSecurityContext wSSecurityContext) throws MarshalException {
        if (wSSecurityContext == null) {
            throw new MarshalException("Context to unmarshal security object from must not be null.");
        }
        this.securityCtx = wSSecurityContext;
        Element element = this.getSecurityHeader(wSSecurityContext);
        if (element != null) {
            this.unmarshalInternal(element);
        }
    }

    public void unmarshal(SOAPMessageContext sOAPMessageContext) throws MarshalException {
        if (sOAPMessageContext == null) {
            throw new MarshalException("Context to unmarshal security object from must not be null.");
        }
        this.securityCtx = WSSecurityContext.getSecurityContext((MessageContext)sOAPMessageContext);
        WSSecurityContext.pushContext(this.securityCtx);
        try {
            Element element = SecurityImpl.getSecurityHeader(sOAPMessageContext);
            if (element != null) {
                this.unmarshalInternal(element);
            }
        }
        catch (SOAPException sOAPException) {
            throw new MarshalException(sOAPException);
        }
        catch (WSSecurityException wSSecurityException) {
            throw new MarshalException(wSSecurityException);
        }
        finally {
            WSSecurityContext.popContext();
        }
    }

    private void unmarshalInternal(Node node) throws MarshalException {
        QName qName = DOMUtils.getQName(node);
        if (!qName.equals(WSSConstants.SECURITY_QNAME)) {
            throw new MarshalException("QName " + qName + " of node to unmarshal Security object from does not match " + WSSConstants.SECURITY_QNAME);
        }
        this.securityCtx.setSecurityElement((Element)node);
        Element element = DOMUtils.getFirstElement(node);
        try {
            this.unmarshalChildren(element, node);
            this.validateSecurityTokens(this.securityCtx);
            this.validateHandlers(this.securityCtx);
            if (node.getParentNode() != null) {
                node.getParentNode().removeChild(node);
            }
        }
        catch (WSSecurityException wSSecurityException) {
            throw new MarshalException(wSSecurityException);
        }
        catch (weblogic.xml.crypto.api.MarshalException marshalException) {
            throw new MarshalException(marshalException);
        }
    }

    protected void unmarshalChildren(Element element, Node node) throws MarshalException, WSSecurityException, weblogic.xml.crypto.api.MarshalException {
        XMLStructure xMLStructure;
        Object object;
        Object object2;
        Element element2 = null;
        Element element3 = element;
        KeySelector keySelector = null;
        while (element3 != null) {
            QName qName = DOMUtils.getQName(element3);
            if (qName.equals(WSSConstants.BST_QNAME)) {
                object2 = this.unmarshalAndProcessSecurityToken(element3, qName, this.securityCtx);
            } else if (this.isSAMLQName(qName)) {
                object2 = DOMUtils.getFirstElement(element3);
                if (object2 != null && !((QName)(object = DOMUtils.getQName((Node)object2))).equals(ENCRYPTED_DATA_QNAME)) {
                    xMLStructure = this.unmarshalAndProcessSecurityToken(element3, qName, this.securityCtx);
                }
            } else if (!qName.equals(ENCRYPTED_KEY_QNAME) || keySelector == null) {
                // empty if block
            }
            element3 = DOMUtils.getNextElement(element3);
        }
        element3 = element;
        boolean bl = true;
        while (element3 != null) {
            object2 = DOMUtils.getQName(element3);
            if (((QName)object2).equals(WSSConstants.TIMESTAMP_QNAME)) {
                this.unmarshalAndProcessTimestamp(element3, this.securityCtx);
            } else if (((QName)object2).equals(WSSConstants.UNT_QNAME)) {
                object = this.unmarshalAndProcessSecurityToken(element3, (QName)object2, this.securityCtx);
            } else if (((QName)object2).equals(DsigConstants.SIGNATURE_QNAME)) {
                try {
                    object = null;
                    object = this.unmarshalAndProcessSignature(element3, this.securityCtx);
                }
                catch (WSSecurityException wSSecurityException) {
                    if (null != keySelector) {
                        LogUtils.logDsig("Got error on " + wSSecurityException.getMessage() + "Try again with Encrypted Key!");
                        xMLStructure = this.unmarshalAndProcessSignature(element3, this.securityCtx, keySelector);
                    }
                    throw wSSecurityException;
                }
            } else if (((QName)object2).equals(REFERENCE_LIST_QNAME)) {
                bl = false;
                object = this.unmarshalReferenceList(element3);
                this.processReferenceList((List)object, this.securityCtx);
            } else if (((QName)object2).equals(ENCRYPTED_KEY_QNAME)) {
                bl = false;
                this.unmarshalAndProcessEncryptedKey(element3, this.securityCtx);
            } else {
                if (((QName)object2).equals(ENCRYPTED_DATA_QNAME)) {
                    bl = false;
                    this.unmarshalAndProcessEncryptedData(element3, this.securityCtx);
                    if (element2 != null) {
                        element3 = (Element)element2.getNextSibling();
                        continue;
                    }
                    element3 = DOMUtils.getFirstElement(node);
                    continue;
                }
                if (((QName)object2).equals(WSSConstants.STR_QNAME)) {
                    bl = false;
                } else if (this.elementHandlers.containsKey(object2)) {
                    bl = false;
                    object = (SecurityHeaderElementHandler)this.elementHandlers.get(object2);
                    object.process(element3, this.securityCtx);
                } else {
                    bl = false;
                    object = this.unmarshalAndProcessSecurityToken(element3, (QName)object2, this.securityCtx);
                }
            }
            element2 = element3;
            element3 = DOMUtils.getNextElement(element3);
        }
    }

    private boolean isSAMLQName(QName qName) {
        int n;
        for (n = 0; n < SAMLConstants.SAML_ASST_QNAMES.length; ++n) {
            if (!qName.equals(SAMLConstants.SAML_ASST_QNAMES[n])) continue;
            return true;
        }
        for (n = 0; n < SAML2Constants.SAML2_ASST_QNAMES.length; ++n) {
            if (!qName.equals(SAML2Constants.SAML2_ASST_QNAMES[n])) continue;
            return true;
        }
        return false;
    }

    private void validateSecurityTokens(WSSecurityContext wSSecurityContext) throws WSSecurityException {
        List list = wSSecurityContext.getCurrentTokens();
        for (SecurityToken securityToken : list) {
            MessageContext messageContext;
            String string = securityToken.getValueType();
            SecurityTokenHandler securityTokenHandler = wSSecurityContext.getRequiredTokenHandler(string);
            SecurityTokenValidateResult securityTokenValidateResult = securityTokenHandler.validateProcessed(securityToken, messageContext = wSSecurityContext.getMessageContext());
            if (securityTokenValidateResult.status()) continue;
            throw new WSSecurityException("Security token failed to validate.", securityTokenValidateResult, WSSConstants.FAILURE_TOKEN_INVALID);
        }
    }

    private Timestamp unmarshalAndProcessTimestamp(Element element, WSSecurityContext wSSecurityContext) throws MarshalException {
        TimestampImpl timestampImpl = new TimestampImpl();
        timestampImpl.unmarshal(element);
        wSSecurityContext.setTimestamp(timestampImpl);
        return timestampImpl;
    }

    private SecurityToken unmarshalAndProcessSecurityToken(Node node, QName qName, WSSecurityContext wSSecurityContext) throws MarshalException, WSSecurityException {
        SecurityTokenHandler securityTokenHandler = wSSecurityContext.getRequiredTokenHandler(qName);
        if (securityTokenHandler == null) {
            throw new MarshalException("Unsupported security token " + qName);
        }
        SecurityToken securityToken = null;
        try {
            securityToken = securityTokenHandler.newSecurityToken(node);
        }
        catch (weblogic.xml.crypto.api.MarshalException marshalException) {
            Throwable throwable = marshalException;
            if (marshalException.getCause() instanceof WSSecurityException) {
                throwable = marshalException.getCause();
            }
            throw new MarshalException("Failed to unmarshal " + qName, throwable);
        }
        SecurityTokenValidateResult securityTokenValidateResult = securityTokenHandler.validateUnmarshalled(securityToken, wSSecurityContext.getMessageContext());
        if (!securityTokenValidateResult.status()) {
            throw new WSSecurityException("Security token failed to validate.", securityTokenValidateResult, WSSConstants.FAILURE_TOKEN_INVALID);
        }
        wSSecurityContext.addSecurityToken(securityToken);
        wSSecurityContext.addToken(securityToken, (Element)node);
        LogUtils.logWss("Adding token to WSSecurityContext: ", securityToken);
        KeyProvider keyProvider = securityTokenHandler.getKeyProvider(securityToken, wSSecurityContext.getMessageContext());
        if (keyProvider != null) {
            wSSecurityContext.addKeyProvider(keyProvider);
        }
        LogUtils.logWss("Adding KeyProvider (inbound) to WSSecurityContext : " + keyProvider + "\nfor token (type: " + securityToken.getValueType() + ") ", securityToken);
        return securityToken;
    }

    private XMLSignature unmarshalAndProcessSignature(Node node, WSSecurityContext wSSecurityContext) throws WSSecurityException {
        return this.unmarshalAndProcessSignature(node, wSSecurityContext, wSSecurityContext.getKeySelector());
    }

    private void p(String string) {
    }

    private XMLSignature unmarshalAndProcessSignature(Node node, WSSecurityContext wSSecurityContext, KeySelector keySelector) throws WSSecurityException {
        Set set;
        if (null == keySelector) {
            keySelector = wSSecurityContext.getKeySelector();
        }
        WLDOMValidateContextImpl wLDOMValidateContextImpl = new WLDOMValidateContextImpl(keySelector, node);
        URIDereferencer uRIDereferencer = wSSecurityContext.getURIDereferencer();
        if (uRIDereferencer != null) {
            wLDOMValidateContextImpl.setURIDereferencer(uRIDereferencer);
        }
        if ((set = wSSecurityContext.getIdQNames()) != null) {
            wLDOMValidateContextImpl.setProperty("weblogic.xml.crypto.idqnames", set);
        }
        MessageContext messageContext = wSSecurityContext.getMessageContext();
        wLDOMValidateContextImpl.setProperty("javax.xml.rpc.handler.MessageContext", messageContext);
        wLDOMValidateContextImpl.setProperty("weblogic.xml.crypto.wss.WSSecurityContext", wSSecurityContext);
        XMLSignature xMLSignature = null;
        try {
            XMLSignatureFactory xMLSignatureFactory = wSSecurityContext.getSignatureFactory();
            xMLSignature = xMLSignatureFactory.unmarshalXMLSignature(wLDOMValidateContextImpl);
            boolean bl = xMLSignature.validate(wLDOMValidateContextImpl);
            if (!bl) {
                throw new WSSecurityException("Signature failed to validate.", ((XMLSignatureImpl)xMLSignature).getSignatureValidateResult().toFaultString(), WSSConstants.FAILURE_VERIFY_OR_DECRYPT);
            }
        }
        catch (weblogic.xml.crypto.api.MarshalException marshalException) {
            throw new WSSecurityException("Failed to unmarshal signature.", marshalException);
        }
        catch (XMLSignatureException xMLSignatureException) {
            throw new WSSecurityException("Failed to validate signature.", xMLSignatureException);
        }
        catch (Throwable throwable) {
            throw new WSSecurityException(throwable.getMessage());
        }
        this.p("\n\n +++ ADD Signature to SecurityCOntext");
        wSSecurityContext.addSignature(xMLSignature);
        this.p("\n\n +++ ADD Signature to SecurityCOntext DONE");
        return xMLSignature;
    }

    private void processReferenceList(List list, WSSecurityContext wSSecurityContext) throws WSSecurityException, weblogic.xml.crypto.api.MarshalException {
        for (ReferenceType referenceType : list) {
            String string = referenceType.getURI();
            String string2 = referenceType.getType();
            Element element = wSSecurityContext.getElementById(string.substring(1));
            if (element == null) {
                throw new WSSecurityException("Failed to resolve DataReference.", WSSConstants.FAILURE_INVALID);
            }
            if ("DataReference".equals(string2) || referenceType instanceof DataReference) {
                KeySelector keySelector = wSSecurityContext.getKeySelector();
                DOMDecryptContext dOMDecryptContext = new DOMDecryptContext(keySelector, element);
                XMLEncryptionFactory xMLEncryptionFactory = wSSecurityContext.getEncryptionFactory();
                try {
                    EncryptedData encryptedData = (EncryptedData)xMLEncryptionFactory.unmarshalEncryptedType(dOMDecryptContext);
                    Element element2 = (Element)element.getParentNode();
                    Node node = element.getNextSibling();
                    Node node2 = element.getPreviousSibling();
                    this.decrypt(encryptedData, element, dOMDecryptContext);
                    List list2 = this.getInsertedNodes(element2, node2, node);
                    KeySelectorResult keySelectorResult = (KeySelectorResult)dOMDecryptContext.getProperty("weblogic.xml.crypto.ksr");
                    Encryption encryption = new Encryption(encryptedData, null, list2, keySelectorResult);
                    wSSecurityContext.addEncryption(encryption);
                    continue;
                }
                catch (XMLEncryptionException xMLEncryptionException) {
                    throw new WSSecurityException(xMLEncryptionException, WSSConstants.FAILURE_VERIFY_OR_DECRYPT);
                }
            }
            if (!"KeyReference".equals(string2) && !(referenceType instanceof KeyReference)) continue;
            this.unmarshalAndProcessEncryptedKey(element, wSSecurityContext);
        }
    }

    protected boolean isHeader(Node node) {
        return false;
    }

    protected void handleEncryptedHeader(Node node) {
    }

    private KeyResolver unmarshalEncryptedKeyOnly(Element element, WSSecurityContext wSSecurityContext) throws WSSecurityException, weblogic.xml.crypto.api.MarshalException {
        KeySelector keySelector = wSSecurityContext.getKeySelector();
        DOMDecryptContext dOMDecryptContext = new DOMDecryptContext(keySelector, element);
        MessageContext messageContext = wSSecurityContext.getMessageContext();
        dOMDecryptContext.setProperty("javax.xml.rpc.handler.MessageContext", messageContext);
        dOMDecryptContext.setProperty("weblogic.xml.crypto.wss.WSSecurityContext", wSSecurityContext);
        XMLEncryptionFactory xMLEncryptionFactory = wSSecurityContext.getEncryptionFactory();
        EncryptedKey encryptedKey = (EncryptedKey)xMLEncryptionFactory.unmarshalEncryptedType(dOMDecryptContext);
        EncryptedKeyProvider encryptedKeyProvider = this.handleEncryptedKey(encryptedKey, dOMDecryptContext, wSSecurityContext);
        KeyResolver keyResolver = new KeyResolver();
        keyResolver.addKeyProvider(encryptedKeyProvider);
        return keyResolver;
    }

    private void unmarshalAndProcessEncryptedKey(Element element, WSSecurityContext wSSecurityContext) throws WSSecurityException, weblogic.xml.crypto.api.MarshalException {
        KeySelector keySelector = wSSecurityContext.getKeySelector();
        DOMDecryptContext dOMDecryptContext = new DOMDecryptContext(keySelector, element);
        MessageContext messageContext = wSSecurityContext.getMessageContext();
        dOMDecryptContext.setProperty("javax.xml.rpc.handler.MessageContext", messageContext);
        dOMDecryptContext.setProperty("weblogic.xml.crypto.wss.WSSecurityContext", wSSecurityContext);
        XMLEncryptionFactory xMLEncryptionFactory = wSSecurityContext.getEncryptionFactory();
        EncryptedKey encryptedKey = (EncryptedKey)xMLEncryptionFactory.unmarshalEncryptedType(dOMDecryptContext);
        EncryptedKeyProvider encryptedKeyProvider = this.handleEncryptedKey(encryptedKey, dOMDecryptContext, wSSecurityContext);
        KeyResolver keyResolver = new KeyResolver();
        keyResolver.addKeyProvider(encryptedKeyProvider);
        List list = encryptedKey.getReferenceList();
        if (list != null) {
            for (DataReference dataReference : list) {
                try {
                    Element element2 = wSSecurityContext.getElementById(dataReference.getURI().substring(1));
                    if (element2 == null) {
                        throw new WSSecurityException("Failed to resolve DataReference.", WSSConstants.FAILURE_INVALID);
                    }
                    DOMDecryptContext dOMDecryptContext2 = new DOMDecryptContext(keyResolver, element2);
                    dOMDecryptContext2.setProperty("javax.xml.rpc.handler.MessageContext", messageContext);
                    EncryptedData encryptedData = (EncryptedData)xMLEncryptionFactory.unmarshalEncryptedType(dOMDecryptContext2);
                    Element element3 = (Element)element2.getParentNode();
                    Node node = element2.getNextSibling();
                    Node node2 = element2.getPreviousSibling();
                    this.decrypt(encryptedData, element2, dOMDecryptContext2);
                    List list2 = this.getInsertedNodes(element3, node2, node);
                    KeySelectorResult keySelectorResult = (KeySelectorResult)dOMDecryptContext2.getProperty("weblogic.xml.crypto.ksr");
                    Encryption encryption = new Encryption(encryptedData, encryptedKey, list2, keySelectorResult);
                    wSSecurityContext.addEncryption(encryption);
                }
                catch (XMLEncryptionException xMLEncryptionException) {
                    throw new WSSecurityException(xMLEncryptionException, WSSConstants.FAILURE_VERIFY_OR_DECRYPT);
                }
            }
        }
    }

    private void decrypt(EncryptedData encryptedData, Element element, DOMDecryptContext dOMDecryptContext) throws XMLEncryptionException {
        if (this.isHeader(element)) {
            this.handleEncryptedHeader(element);
        }
        encryptedData.decryptAndReplace(dOMDecryptContext);
        NodeURIDereferencer.resetParsedFlag(this.securityCtx);
    }

    protected EncryptedKeyProvider handleEncryptedKey(EncryptedKey encryptedKey, DOMDecryptContext dOMDecryptContext, WSSecurityContext wSSecurityContext) throws WSSecurityException {
        EncryptedKeyProvider encryptedKeyProvider = null;
        try {
            encryptedKeyProvider = new EncryptedKeyProvider(encryptedKey, dOMDecryptContext);
        }
        catch (XMLEncryptionException xMLEncryptionException) {
            throw new WSSecurityException(xMLEncryptionException, WSSConstants.FAILURE_INVALID);
        }
        wSSecurityContext.addKeyProvider(encryptedKeyProvider);
        return encryptedKeyProvider;
    }

    private void unmarshalAndProcessEncryptedData(Element element, WSSecurityContext wSSecurityContext) throws WSSecurityException {
        KeySelector keySelector = wSSecurityContext.getKeySelector();
        DOMDecryptContext dOMDecryptContext = new DOMDecryptContext(keySelector, element);
        XMLEncryptionFactory xMLEncryptionFactory = wSSecurityContext.getEncryptionFactory();
        try {
            EncryptedData encryptedData = (EncryptedData)xMLEncryptionFactory.unmarshalEncryptedType(dOMDecryptContext);
            encryptedData.decryptAndReplace(dOMDecryptContext);
        }
        catch (weblogic.xml.crypto.api.MarshalException marshalException) {
            throw new WSSecurityException("Failed to unmarsahl encrypted data.", marshalException, WSSConstants.FAILURE_INVALID);
        }
        catch (XMLEncryptionException xMLEncryptionException) {
            throw new WSSecurityException("Failed to decrypt encrypted data.", xMLEncryptionException, WSSConstants.FAILURE_VERIFY_OR_DECRYPT);
        }
    }

    private List unmarshalReferenceList(Node node) throws weblogic.xml.crypto.api.MarshalException {
        try {
            DOMStreamReader dOMStreamReader = new DOMStreamReader(node);
            return ReferenceList.read(dOMStreamReader, false);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new weblogic.xml.crypto.api.MarshalException(xMLStreamException);
        }
    }

    private static void declareNamespaces(Element element, Map map) {
        SecurityImpl.declareNamespace(element, map, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse");
        SecurityImpl.declareNamespace(element, map, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu");
    }

    private static void declareNamespace(Element element, Map map, String string, String string2) {
        if (map.get(string) == null) {
            map.put(string, string2);
            DOMUtils.declareNamespace(element, string, string2);
        }
    }

    private static Element getSecurityHeader(SOAPMessageContext sOAPMessageContext) throws SOAPException, WSSecurityException {
        String string = SecurityImpl.getRole(sOAPMessageContext);
        String string2 = SecurityImpl.getRoleAttrName(sOAPMessageContext);
        SOAPHeader sOAPHeader = sOAPMessageContext.getMessage().getSOAPHeader();
        return SecurityImpl.getSecurityHeader((Element)sOAPHeader, string2, string);
    }

    private Element getSecurityHeader(WSSecurityContext wSSecurityContext) {
        return (Element)wSSecurityContext.getNode();
    }

    private static Element getSecurityHeader(Element element, String string, String string2) throws WSSecurityException {
        NodeList nodeList = element.getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");
        Element element2 = null;
        for (int i = 0; nodeList.getLength() > i; ++i) {
            Element element3 = (Element)nodeList.item(i);
            if (!SecurityImpl.isForRole(element3, string, string2)) continue;
            if (element2 == null) {
                element2 = element3;
                continue;
            }
            throw new WSSecurityException("Found more than one Security header for role " + string2, WSSConstants.FAILURE_INVALID);
        }
        return element2;
    }

    private static boolean isForRole(Element element, String string, String string2) {
        Attr attr = element.getAttributeNodeNS("soapenv", string);
        if (SecurityImpl.isNext(string2) && attr == null || SecurityImpl.isNext(attr.getValue())) {
            return true;
        }
        return attr.getValue() != null && attr.getValue().equals(string2);
    }

    private static String getRole(SOAPMessageContext sOAPMessageContext) {
        return null;
    }

    private static String getRoleAttrName(SOAPMessageContext sOAPMessageContext) {
        return "actor";
    }

    private static boolean isNext(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        return string.equals("http://schemas.xmlsoap.org/soap/actor/next");
    }

    private List getInsertedNodes(Element element, Node node, Node node2) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        Node node3 = null;
        for (node3 = node != null ? node.getNextSibling() : element.getFirstChild(); node3 != null && node3 != node2; node3 = node3.getNextSibling()) {
            arrayList.add(node3);
        }
        return arrayList;
    }

    private static boolean isTimestampFirst(ContextHandler contextHandler) {
        return Boolean.parseBoolean((String)contextHandler.getValue("weblogic.wsee.security.timestamp_first")) || SecurityImpl.isStrictLayout(contextHandler);
    }

    private static Node getLastTokenNode(ContextHandler contextHandler) {
        return (Node)contextHandler.getValue("weblogic.wsee.security.last_token_node");
    }

    private static void setLastTokenNode(ContextHandler contextHandler, Node node) {
        ((SecurityTokenContextHandler)contextHandler).addContextElement("weblogic.wsee.security.last_token_node", node);
    }

    private static Node getFirstTokenNode(ContextHandler contextHandler) {
        return (Node)contextHandler.getValue("weblogic.wsee.security.first_token_node");
    }

    private static void setFirstTokenNode(ContextHandler contextHandler, Node node) {
        ((SecurityTokenContextHandler)contextHandler).addContextElement("weblogic.wsee.security.first_token_node", node);
    }

    private static boolean needToSetAsFirstToken(ContextHandler contextHandler) {
        String string = (String)contextHandler.getValue("weblogic.wsee.security.move_node_to_top");
        if (string != null) {
            return Boolean.parseBoolean(string);
        }
        return false;
    }

    private static boolean isStrictLayout(ContextHandler contextHandler) {
        Boolean bl = (Boolean)contextHandler.getValue("weblogic.wsee.security.strict_layout");
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public static boolean isEndoringEncryptSignature(ContextHandler contextHandler) {
        Boolean bl = (Boolean)contextHandler.getValue("weblogic.wsee.security.endorse_signature_encrypt_signature");
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public static boolean isEncryptBeforeSign(ContextHandler contextHandler) {
        Boolean bl = (Boolean)contextHandler.getValue("weblogic.wsee.security.encrypt_sign");
        if (bl != null) {
            return bl;
        }
        return false;
    }

    private static Node getInsertedNode(Element element, ContextHandler contextHandler, Node node, boolean bl) {
        Node node2;
        Node node3 = node == null ? ((node2 = SecurityImpl.getFirstTokenNode(contextHandler)) == null ? element.getFirstChild() : node2.getNextSibling()) : node.getPreviousSibling();
        if (bl) {
            SecurityImpl.setLastTokenNode(contextHandler, node3);
        }
        if (SecurityImpl.needToSetAsFirstToken(contextHandler)) {
            SecurityImpl.setFirstTokenNode(contextHandler, node3);
        }
        return node3;
    }

    protected Node findSignatureInsertBeforeNode(Element element, XMLSignature xMLSignature, ContextHandler contextHandler) {
        Object object;
        Node node = this.findInsertBeforeNode(element, contextHandler, false);
        if (SecurityImpl.isStrictLayout(contextHandler)) {
            object = xMLSignature.getSignedInfo().getReferences();
            ArrayList<String> arrayList = new ArrayList<String>();
            Object object2 = object.iterator();
            while (object2.hasNext()) {
                Reference reference = (Reference)object2.next();
                if (!reference.getURI().startsWith(LOCAL_URI_PREFIX)) continue;
                arrayList.add(reference.getURI().substring(1));
            }
            object2 = this.findLastChildNodeById(arrayList, this.securityCtx.getIdQNames(), element, node);
            if (object2 != null) {
                node = object2.getNextSibling();
            }
        }
        if (SecurityImpl.isEncryptBeforeSign(contextHandler)) {
            Object object3 = object = node == null ? element.getLastChild() : node;
            while (null != object) {
                if (ENCRYPTED_KEY_QNAME.getLocalPart().equals(object.getLocalName()) || REFERENCE_LIST_QNAME.getLocalPart().equals(object.getLocalName())) {
                    return object;
                }
                object = object.getPreviousSibling();
            }
        }
        if (SecurityImpl.isEndoringEncryptSignature(contextHandler)) {
            object = null;
            if (null != node) {
                if (!ENCRYPTED_KEY_QNAME.getLocalPart().equals(node.getLocalName()) && !REFERENCE_LIST_QNAME.getLocalPart().equals(node.getLocalName())) {
                    return node;
                }
                object = node.getNextSibling();
            } else {
                object = SecurityImpl.getLastTokenNode(contextHandler);
            }
            while (null != object) {
                if (!ENCRYPTED_KEY_QNAME.getLocalPart().equals(object.getLocalName()) && !REFERENCE_LIST_QNAME.getLocalPart().equals(object.getLocalName())) {
                    return object;
                }
                object = object.getNextSibling();
            }
        }
        return node;
    }

    protected Node findReferenceInsertBeforeNode(Element element, ContextHandler contextHandler) {
        Node node;
        Node node2;
        if (!SecurityImpl.isEncryptBeforeSign(contextHandler)) {
            for (node2 = node = this.findInsertBeforeNode(element, contextHandler, false); node2 != null && !node2.getLocalName().equals(SIGNATURE_LOCALNAME); node2 = node2.getPreviousSibling()) {
            }
        }
        if (node2 != null) {
            node = node2;
        }
        return node;
    }

    protected Node findInsertBeforeNode(Element element, ContextHandler contextHandler, boolean bl) {
        Node node = element.getLastChild();
        if (node == null) {
            return null;
        }
        if (SecurityImpl.needToSetAsFirstToken(contextHandler)) {
            return element.getFirstChild();
        }
        boolean bl2 = SecurityImpl.isTimestampFirst(contextHandler);
        Node node2 = SecurityImpl.getLastTokenNode(contextHandler);
        Node node3 = SecurityImpl.getFirstTokenNode(contextHandler);
        if (bl) {
            if (node2 == null) {
                Node node4 = element.getFirstChild();
                if (bl2 && node4 != null && WSSConstants.TIMESTAMP_QNAME.getLocalPart().equals(node4.getLocalName())) {
                    return node4.getNextSibling();
                }
                return node4;
            }
            if (node3 == null) {
                return node2;
            }
            return node3.getNextSibling();
        }
        Node node5 = null;
        if (node2 == null) {
            if (bl2 && WSSConstants.TIMESTAMP_QNAME.getLocalPart().equals(node.getLocalName())) {
                return null;
            }
            node5 = node;
        } else {
            node5 = node2.getNextSibling();
        }
        return node5;
    }

    private Node findLastChildNodeById(List list, Set set, Node node, Node node2) {
        for (Node node3 = node.getLastChild(); node3 != null; node3 = node3.getPreviousSibling()) {
            if (this.matchesId(list, set, node3)) {
                return node3;
            }
            if (node3 != node2) continue;
            return null;
        }
        return null;
    }

    private boolean matchesId(List list, Set set, Node node) {
        if (!node.hasAttributes()) {
            return false;
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n = namedNodeMap.getLength();
        for (String string : list) {
            for (int i = 0; i < n; ++i) {
                Node node2 = namedNodeMap.item(i);
                if (!string.equals(node2.getNodeValue())) continue;
                for (QName qName : set) {
                    if (!this.namespacesMatch(node2, qName) || !node2.getLocalName().equals(qName.getLocalPart())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean namespacesMatch(Node node, QName qName) {
        String string = node.getNamespaceURI();
        String string2 = qName.getNamespaceURI();
        if (this.isEmptyNamespace(string) && this.isEmptyNamespace(string2)) {
            return true;
        }
        return string != null && string.equals(string2);
    }

    private boolean isEmptyNamespace(String string) {
        return string == null || "".equals(string);
    }

    public void register(SecurityHeaderElementHandler securityHeaderElementHandler) {
        this.elementHandlers.put(securityHeaderElementHandler.getQName(), securityHeaderElementHandler);
    }

    private void validateHandlers(WSSecurityContext wSSecurityContext) throws WSSecurityException {
        for (QName qName : this.elementHandlers.keySet()) {
            ((SecurityHeaderElementHandler)this.elementHandlers.get(qName)).validate(wSSecurityContext);
        }
    }

    public static interface SecurityHeaderElementHandler {
        public QName getQName();

        public void process(Node var1, WSSecurityContext var2) throws weblogic.xml.crypto.api.MarshalException;

        public void validate(WSSecurityContext var1) throws WSSecurityException;
    }
}

