/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.wss;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.rpc.handler.MessageContext;
import org.w3c.dom.Node;
import weblogic.security.service.ContextElement;
import weblogic.security.service.ContextHandler;
import weblogic.xml.crypto.wss.WSSecurityContext;
import weblogic.xml.crypto.wss.WSSecurityInfo;
import weblogic.xml.crypto.wss.policy.Claims;

public class SecurityTokenContextHandler
implements ContextHandler {
    public static final String CLAIMS_MAP = "weblogic.xml.crypto.wss.policy.Claims";
    public static final String TOKEN = "com.bea.contextelement.xml.SecurityToken";
    public static final String SECURITY_INFO = "com.bea.contextelement.xml.SecurityInfo";
    public static final String ISSUER_SERIAL = "com.bea.contextelement.xml.IssuerSerial";
    public static final String KEYID = "com.bea.contextelement.xml.KeyIdentifier";
    public static final String THUMBPRINT = "weblogic.wsee.security.wss11.thumbprint";
    public static final String KEY_NAME = "weblogic.xml.crypto.keyinfo.keyname";
    public static final String ENDPOINT_URL = "com.bea.contextelement.xml.EndpointURL";
    public static final String PKI_INITIATOR = "weblogic.xml.crypto.wss.PKI_Initiator";
    public static final String WSS_SUBJECT_PROPERTY = "weblogic.wsee.wss.subject";
    public static final String DERIVED_FROM_TOKEN = "weblogic.wsee.wsc.derived_from_token";
    public static final String SET_TO_FIRST_TOKEN = "weblogic.wsee.security.move_node_to_top";
    public static final String FRIST_TOKEN_NODE = "weblogic.wsee.security.first_token_node";
    public static final String LAST_TOKEN_NODE = "weblogic.wsee.security.last_token_node";
    public static final String TIMESTAMP_FIRST = "weblogic.wsee.security.timestamp_first";
    public static final String ENCRYPT_THEN_SIGN = "weblogic.wsee.security.encrypt_sign";
    public static final String NEED_TO_MOVE_TIMESTAMP = "weblogic.wsee.security.need_to_move_timestamp";
    public static final String SIGNATURE_NODE = "weblogic.wsee.security.signature_node";
    public static final String ENCRYPTED_ELEMENT_MAP = "weblogic.wsee.security.encrypted_element.map";
    public static final String STRICT_LAYOUT = "weblogic.wsee.security.strict_layout";
    public static final String WST_BOOT_STRAP_POLICY = "weblogic.wsee.security.wst_bootstrap_policy";
    public static final String WST_OUTER_POLICY = "weblogic.wsee.security.wst_outer_policy";
    public static final String ISSUER_ENDPOINT_REF = "weblogic.wsee.security.issuer_endpoint_ref";
    public static final String TRUST_VERSION = "weblogic.wsee.security.trust_version";
    public static final String KEY_TYPE = "weblogic.wsee.security.key_type";
    public static final String SCT_TOKEN_LIFE_TIME = "weblogic.wsee.wssc.sct.lifetime";
    public static String DK_LABEL = "weblogic.wsee.wssc.dk.label";
    public static final String DK_LENGTH = "weblogic.wsee.wssc.dk.length";
    public static final String EK_ENCRYPT_METHOD = "weblogic.wsee.ek.encrypt_method";
    public static final String EK_KEYWRAP_METHOD = "weblogic.wsee.ek.keywrap_method";
    public static final String DK_STR_REFERENCE_TYPE = "weblogic.wsee.dk.referece_type";
    public static final String ENDORSE_SIGNATURE_ENCRYPT_SIGNATURE = "weblogic.wsee.security.endorse_signature_encrypt_signature";
    public static final String DK_BASE_TOKEN_REFERENCE_TYPE = "weblogic.wsee.dk.base_token_referece_type";
    private List names = new ArrayList();
    private Map contextElements = new HashMap();

    public SecurityTokenContextHandler() {
    }

    public SecurityTokenContextHandler(WSSecurityInfo wSSecurityInfo) {
        WSSecurityContext wSSecurityContext;
        MessageContext messageContext;
        if (wSSecurityInfo instanceof WSSecurityContext && (messageContext = (wSSecurityContext = (WSSecurityContext)wSSecurityInfo).getMessageContext()) != null) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            String string;
            String string2 = (String)messageContext.getProperty("javax.xml.rpc.service.endpoint.address");
            if (string2 != null) {
                this.addContextElement(ENDPOINT_URL, string2);
            }
            if ((string = (String)messageContext.getProperty(PKI_INITIATOR)) != null) {
                this.addContextElement(PKI_INITIATOR, string);
            }
            if ((object4 = messageContext.getProperty("com.bea.contextelement.saml.CachingRequested")) != null) {
                this.addContextElement("com.bea.contextelement.saml.CachingRequested", object4);
            }
            if ((object3 = messageContext.getProperty(SCT_TOKEN_LIFE_TIME)) != null) {
                this.addContextElement(SCT_TOKEN_LIFE_TIME, object3);
            }
            if ((object2 = messageContext.getProperty(DK_LABEL)) != null) {
                this.addContextElement(DK_LABEL, object2);
            }
            if ((object = messageContext.getProperty(DK_LENGTH)) != null) {
                this.addContextElement(DK_LENGTH, object);
            }
        }
        this.addContextElement(SECURITY_INFO, wSSecurityInfo);
    }

    public SecurityTokenContextHandler(Claims claims) {
        this.addContextElement(CLAIMS_MAP, claims);
    }

    public SecurityTokenContextHandler(Node node, WSSecurityInfo wSSecurityInfo) {
        this(wSSecurityInfo);
        this.addContextElement(CLAIMS_MAP, node);
        this.addContextElement(SECURITY_INFO, wSSecurityInfo);
    }

    public int size() {
        return this.names.size();
    }

    public String[] getNames() {
        return this.names.toArray(new String[this.names.size()]);
    }

    public Object getValue(String string) {
        Object object = null;
        ContextElement contextElement = (ContextElement)this.contextElements.get(string);
        if (contextElement != null) {
            object = contextElement.getValue();
        }
        return object;
    }

    public ContextElement[] getValues(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        ArrayList<ContextElement> arrayList = new ArrayList<ContextElement>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            ContextElement contextElement = (ContextElement)this.contextElements.get(string);
            if (contextElement == null) continue;
            arrayList.add(contextElement);
        }
        return arrayList.toArray(new ContextElement[arrayList.size()]);
    }

    public void addContextElement(String string, Object object) {
        this.contextElements.put(string, new ContextElement(string, object));
        this.names.add(string);
    }
}

