/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.wss;

import java.util.List;
import weblogic.security.service.ContextHandler;
import weblogic.wsee.security.wssc.sct.SCCredential;
import weblogic.xml.crypto.wss.WSSecurityContext;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss.provider.SecurityToken;

public class SecurityTokenHelper {
    public static final String getURI(SecurityToken securityToken) {
        String string = securityToken.getId();
        String string2 = string == null ? null : "#" + securityToken.getId();
        return string2;
    }

    public static final String getIdFromURI(String string) {
        return string != null ? string.substring(1) : null;
    }

    public static final SecurityToken findSecurityTokenInContext(ContextHandler contextHandler, String string) throws WSSecurityException {
        WSSecurityContext wSSecurityContext = (WSSecurityContext)contextHandler.getValue("com.bea.contextelement.xml.SecurityInfo");
        if (wSSecurityContext == null) {
            return null;
        }
        return SecurityTokenHelper.findSecurityTokenInContext(wSSecurityContext, string);
    }

    public static final SecurityToken findSecurityTokenInContext(WSSecurityContext wSSecurityContext, String string) {
        List list = wSSecurityContext.getSecurityTokens();
        SecurityToken securityToken = null;
        for (SecurityToken securityToken2 : list) {
            if (!securityToken2.getValueType().equals(string)) continue;
            securityToken = securityToken2;
            break;
        }
        return securityToken;
    }

    public static final SecurityToken findSecurityTokenByIdInContext(WSSecurityContext wSSecurityContext, String string, String string2) {
        List list = wSSecurityContext.getSecurityTokens();
        SecurityToken securityToken = null;
        for (SecurityToken securityToken2 : list) {
            if (securityToken2.getValueType().equals(string) && string2.equals(securityToken2.getId())) {
                securityToken = securityToken2;
                break;
            }
            if (securityToken2.getCredential() == null || !(securityToken2.getCredential() instanceof SCCredential)) continue;
            SCCredential sCCredential = (SCCredential)securityToken2.getCredential();
            if (!securityToken2.getValueType().equals(string) || !string2.equals(sCCredential.getIdentifier())) continue;
            securityToken = securityToken2;
            break;
        }
        return securityToken;
    }

    public static SecurityToken[] findSecurityTokenByType(WSSecurityContext wSSecurityContext, String string) {
        return wSSecurityContext.getSecurityTokens(string).toArray(new SecurityToken[0]);
    }
}

