/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.wss;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.utils.collections.ConcurrentHashMap;
import weblogic.xml.crypto.dsig.DsigConstants;
import weblogic.xml.crypto.dsig.KeyInfoObjectFactory;
import weblogic.xml.crypto.dsig.api.keyinfo.X509IssuerSerial;
import weblogic.xml.crypto.utils.DOMUtils;
import weblogic.xml.crypto.wss.BinarySecurityTokenReference;
import weblogic.xml.crypto.wss.KeyIdentifierImpl;
import weblogic.xml.crypto.wss.UsernameTokenReference;
import weblogic.xml.crypto.wss.WSSConstants;
import weblogic.xml.crypto.wss.WSSecurityContext;
import weblogic.xml.crypto.wss.api.KeyIdentifier;
import weblogic.xml.crypto.wss.provider.SecurityToken;
import weblogic.xml.crypto.wss.provider.SecurityTokenHandler;
import weblogic.xml.crypto.wss.provider.SecurityTokenReference;
import weblogic.xml.crypto.wss11.internal.WSS11Constants;
import weblogic.xml.crypto.wss11.internal.enckey.EncryptedKeySTR;
import weblogic.xml.dom.Builder;
import weblogic.xml.dom.ElementNode;
import weblogic.xml.dom.marshal.MarshalException;
import weblogic.xml.security.utils.Utils;

public class SecurityTokenReferenceImpl
implements SecurityTokenReference,
KeyInfoObjectFactory {
    private static final String ID_PREFIX = "str";
    private static final QName TOKEN_TYPE_QNAME = new QName("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "TokenType");
    private static final ConcurrentHashMap factories = new ConcurrentHashMap();
    private String id;
    private QName STRType;
    private String valueType;
    private String uri;
    private KeyIdentifier keyId;
    private SecurityToken token;

    public SecurityTokenReferenceImpl() {
    }

    public SecurityTokenReferenceImpl(QName qName, String string, SecurityToken securityToken) {
        this.STRType = qName;
        this.valueType = string;
        this.token = securityToken;
        this.id = DOMUtils.generateId(ID_PREFIX);
    }

    private static final void initFactories() {
        BinarySecurityTokenReference.init();
        UsernameTokenReference.init();
        EncryptedKeySTR.init();
    }

    public static void register(SecurityTokenHandler securityTokenHandler) {
        String[] stringArray = securityTokenHandler.getValueTypes();
        for (int i = 0; i < stringArray.length; ++i) {
            factories.put((Object)stringArray[i], (Object)securityTokenHandler);
        }
        QName[] qNameArray = securityTokenHandler.getQNames();
        for (int i = 0; i < qNameArray.length; ++i) {
            factories.put((Object)qNameArray[i], (Object)securityTokenHandler);
        }
    }

    public String getValueType() {
        return this.valueType;
    }

    public QName getSTRType() {
        return this.STRType;
    }

    public void setSTRType(QName qName) {
        this.STRType = qName;
    }

    public X509IssuerSerial getIssuerSerial() {
        return null;
    }

    public void setValueType(String string) {
        this.valueType = string;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getUsage() {
        return null;
    }

    public KeyIdentifier getKeyIdentifier() {
        return this.keyId;
    }

    public void setKeyIdentifier(KeyIdentifier keyIdentifier) {
        this.keyId = keyIdentifier;
    }

    public String getReferenceURI() {
        return this.uri;
    }

    public void setReferenceURI(String string) {
        this.uri = string;
    }

    public SecurityToken getSecurityToken() {
        return this.token;
    }

    public void marshal(Element element, Node node, Map map) throws MarshalException {
        if (this.STRType.equals(WSSConstants.REFERENCE_QNAME)) {
            this.marshalDirectRef(element, node, map, this.uri);
        } else if (this.STRType.equals(WSSConstants.KEY_IDENTIFIER_QNAME)) {
            this.marshalKeyIdRef(element, node, map, this.keyId);
        } else if (this.STRType.equals(WSSConstants.EMBEDDED_QNAME)) {
            this.marshalEmbeddedRef(element, node, map, this.token);
        }
    }

    public void unmarshal(Node node) throws MarshalException {
        this.unmarshalInternal(node);
        Element element = DOMUtils.getFirstElement(node);
        this.STRType = DOMUtils.getQName(element);
        if (this.STRType.equals(WSSConstants.REFERENCE_QNAME)) {
            this.unmarshalDirectRef(element);
        } else if (this.STRType.equals(WSSConstants.KEY_IDENTIFIER_QNAME)) {
            this.unmarshalKeyIdRef(element);
        } else if (this.STRType.equals(WSSConstants.EMBEDDED_QNAME)) {
            this.unmarshalEmbeddedRef(element);
        } else {
            throw new MarshalException("Unrecognized child element in " + WSSConstants.STR_QNAME);
        }
    }

    protected void unmarshalInternal(Node node) {
        this.id = DOMUtils.getAttributeValue((Element)node, WSSConstants.WSU_ID_QNAME);
    }

    public static SecurityTokenReference createAndUnmarshal(Node node) throws MarshalException {
        SecurityTokenHandler securityTokenHandler = null;
        Object var2_2 = null;
        Element element = (Element)node;
        String string = DOMUtils.getAttributeValue(element, TOKEN_TYPE_QNAME);
        if (string != null) {
            securityTokenHandler = (SecurityTokenHandler)factories.get((Object)string);
        }
        if (securityTokenHandler != null) {
            return SecurityTokenReferenceImpl.unmarshalSTR(securityTokenHandler, node);
        }
        Element element2 = DOMUtils.getFirstElement(element);
        QName qName = DOMUtils.getQName(element2);
        if (WSSConstants.REFERENCE_QNAME.equals(qName) || WSSConstants.KEY_IDENTIFIER_QNAME.equals(qName)) {
            String string2 = DOMUtils.getAttributeValue(element2, WSSConstants.VALUE_TYPE_QNAME);
            securityTokenHandler = (SecurityTokenHandler)factories.get((Object)string2);
            if (securityTokenHandler == null && WSSConstants.KEY_IDENTIFIER_QNAME.equals(qName)) {
                throw new MarshalException("Failed to unmarshal " + WSSConstants.STR_QNAME + ", no SecurityTokenReference factory " + "found for " + qName + " " + WSSConstants.VALUE_TYPE_QNAME + ": " + string2);
            }
            if (WSSConstants.REFERENCE_QNAME.equals(qName)) {
                Element element3;
                String string3 = DOMUtils.getAttributeValue(element2, WSSConstants.URI_QNAME);
                WSSecurityContext wSSecurityContext = WSSecurityContext.getCurrentContext();
                if (wSSecurityContext != null && securityTokenHandler == null && (element3 = wSSecurityContext.getElementById(string3.startsWith("#") ? string3.substring(1) : string3)) != null) {
                    QName qName2 = DOMUtils.getQName(element3);
                    securityTokenHandler = (SecurityTokenHandler)factories.get((Object)qName2);
                }
            }
        } else if (WSSConstants.EMBEDDED_QNAME.equals(qName)) {
            Element element4 = DOMUtils.getFirstElement(element2);
            QName qName3 = DOMUtils.getQName(element4);
            securityTokenHandler = (SecurityTokenHandler)factories.get((Object)qName3);
        } else {
            if (DsigConstants.KEYNAME_QNAME.equals(qName)) {
                throw new MarshalException("Failed to unmarshal " + WSSConstants.STR_QNAME + ", " + DsigConstants.KEYNAME_QNAME + " not supported.");
            }
            securityTokenHandler = (SecurityTokenHandler)factories.get((Object)qName);
            if (securityTokenHandler == null) {
                throw new MarshalException("Failed to unmarshal " + WSSConstants.STR_QNAME + ", " + qName + " not supported.");
            }
        }
        return SecurityTokenReferenceImpl.unmarshalSTR(securityTokenHandler, node);
    }

    private static SecurityTokenReference unmarshalSTR(SecurityTokenHandler securityTokenHandler, Node node) throws MarshalException {
        SecurityTokenReference securityTokenReference = securityTokenHandler == null ? new SecurityTokenReferenceImpl() : securityTokenHandler.newSecurityTokenReference(node);
        securityTokenReference.unmarshal(node);
        return securityTokenReference;
    }

    public QName getQName() {
        return WSSConstants.STR_QNAME;
    }

    public Object newKeyInfoObject(XMLStreamReader xMLStreamReader) throws weblogic.xml.crypto.api.MarshalException {
        SecurityTokenReference securityTokenReference = null;
        try {
            ElementNode elementNode = new ElementNode();
            Builder.read(elementNode, xMLStreamReader);
            securityTokenReference = SecurityTokenReferenceImpl.createAndUnmarshal(elementNode);
        }
        catch (MarshalException marshalException) {
            throw new weblogic.xml.crypto.api.MarshalException(marshalException);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new weblogic.xml.crypto.api.MarshalException(xMLStreamException);
        }
        return securityTokenReference;
    }

    public boolean isFeatureSupported(String string) {
        return false;
    }

    protected Element marshalInternal(Element element, Node node, Map map) {
        String string = SecurityTokenReferenceImpl.getPrefix(map, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse");
        String string2 = SecurityTokenReferenceImpl.getPrefix(map, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu");
        Element element2 = DOMUtils.createElement(element, WSSConstants.STR_QNAME, string);
        DOMUtils.declareNamespace(element2, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse");
        if (this.id != null) {
            DOMUtils.addPrefixedAttribute(element2, WSSConstants.WSU_ID_QNAME, string2, this.id);
            DOMUtils.declareNamespace(element2, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", string2);
        }
        this.marshalAttributes(element2, map);
        String string3 = (String)map.get(this.STRType.getNamespaceURI());
        if (string3 == null) {
            map.put(this.STRType.getNamespaceURI(), "strtype");
        }
        Element element3 = DOMUtils.createAndAddElement(element2, this.STRType, string3);
        if (node != null) {
            element.insertBefore(element2, node);
        } else {
            element.appendChild(element2);
        }
        return element3;
    }

    protected void marshalAttributes(Element element, Map map) {
        String string = null;
        if (this.token != null) {
            string = this.token.getValueType();
        }
        if (string != null) {
            String string2 = SecurityTokenReferenceImpl.getPrefix(map, WSS11Constants.TOKEN_TYPE_QNAME.getNamespaceURI(), "wsse11");
            DOMUtils.addPrefixedAttribute(element, WSS11Constants.TOKEN_TYPE_QNAME, string2, string);
            DOMUtils.declareNamespace(element, WSS11Constants.TOKEN_TYPE_QNAME.getNamespaceURI(), string2);
        }
    }

    protected static String getPrefix(Map map, String string, String string2) {
        String string3 = (String)map.get(string);
        if (string3 == null) {
            map.put(string, string2);
            string3 = string2;
        }
        return string3;
    }

    public Node marshalDirectRef(Element element, Node node, Map map, String string) {
        Element element2 = this.marshalInternal(element, node, map);
        DOMUtils.addAttribute(element2, WSSConstants.VALUE_TYPE_QNAME, map, this.valueType);
        DOMUtils.addAttribute(element2, WSSConstants.URI_QNAME, map, string);
        return element2.getParentNode();
    }

    public Node marshalEmbeddedRef(Element element, Node node, Map map, SecurityToken securityToken) throws MarshalException {
        Element element2 = this.marshalInternal(element, node, map);
        securityToken.marshal(element2, null, map);
        return element2.getParentNode();
    }

    public Node marshalKeyIdRef(Element element, Node node, Map map, KeyIdentifier keyIdentifier) throws MarshalException {
        Element element2 = this.marshalInternal(element, node, map);
        DOMUtils.addAttribute(element2, WSSConstants.VALUE_TYPE_QNAME, map, this.valueType);
        String string = keyIdentifier.getEncodingType();
        DOMUtils.addAttribute(element2, WSSConstants.ENCODING_TYPE_QNAME, map, string);
        DOMUtils.addText(element2, Utils.toBase64(keyIdentifier.getIdentifier()));
        return element2.getParentNode();
    }

    public void unmarshalDirectRef(Element element) {
        SecurityToken securityToken;
        Element element2;
        WSSecurityContext wSSecurityContext;
        this.uri = DOMUtils.getAttributeValue(element, WSSConstants.URI_QNAME);
        this.valueType = DOMUtils.getAttributeValue(element, WSSConstants.VALUE_TYPE_QNAME);
        if (this.valueType == null && (wSSecurityContext = WSSecurityContext.getCurrentContext()) != null && (element2 = wSSecurityContext.getElementById(this.uri.startsWith("#") ? this.uri.substring(1) : this.uri)) != null && (securityToken = wSSecurityContext.getToken(element2)) != null) {
            this.valueType = securityToken.getValueType();
        }
    }

    public void unmarshalKeyIdRef(Element element) throws MarshalException {
        this.valueType = DOMUtils.getAttributeValue(element, WSSConstants.VALUE_TYPE_QNAME);
        String string = DOMUtils.getAttributeValue(element, WSSConstants.ENCODING_TYPE_QNAME);
        if (string != null && !string.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary")) {
            throw new MarshalException("Unsupported " + WSSConstants.ENCODING_TYPE_QNAME + ": " + string);
        }
        this.keyId = new KeyIdentifierImpl(Utils.base64(DOMUtils.getText(element)));
    }

    public void unmarshalEmbeddedRef(Element element) throws MarshalException {
    }

    public static Node getStrNode(SecurityTokenReference securityTokenReference) throws weblogic.xml.crypto.api.MarshalException {
        Document document = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new weblogic.xml.crypto.api.MarshalException("Failed to write element SecurityTokenReference", parserConfigurationException);
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new weblogic.xml.crypto.api.MarshalException("Failed to write element SecurityTokenReference", factoryConfigurationError);
        }
        Element element = document.createElementNS("foo", "bar");
        document.appendChild(element);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse");
        hashMap.put("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu");
        try {
            securityTokenReference.marshal(element, null, hashMap);
        }
        catch (MarshalException marshalException) {
            throw new weblogic.xml.crypto.api.MarshalException("Failed to write element SecurityTokenReference");
        }
        Node node = element.getLastChild();
        element.removeChild(node);
        return node;
    }

    static {
        SecurityTokenReferenceImpl.initFactories();
    }
}

