/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.wss;

import java.security.AccessController;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import weblogic.security.SimpleCallbackHandler;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrincipalAuthenticator;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityService;
import weblogic.security.service.SecurityServiceManager;
import weblogic.xml.crypto.wss.WSSConstants;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss.api.UsernameToken;

public class SecurityUtils {
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final Map AUTHENTICATORS = new HashMap();

    public static AuthenticatedSubject assertIdentity(X509Certificate[] x509CertificateArray, String string) throws LoginException {
        try {
            return SecurityUtils.getPrincipalAuthenticator(string).assertIdentity("X.509", (Object)x509CertificateArray);
        }
        catch (SecurityException securityException) {
            return null;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public static Subject assertIdentity(UsernameToken usernameToken, String string) throws WSSecurityException {
        Subject subject = null;
        AuthenticatedSubject authenticatedSubject = null;
        UsernameToken usernameToken2 = usernameToken;
        String string2 = usernameToken2.getPasswordType();
        try {
            authenticatedSubject = string2.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText") ? SecurityUtils.assertId(usernameToken2.getUsername(), usernameToken2.getPassword(), string) : SecurityUtils.assertId(usernameToken2, string);
        }
        catch (LoginException loginException) {
            throw new WSSecurityException("Failed to assert identity with UsernameToken.", WSSConstants.FAILURE_AUTH);
        }
        if (authenticatedSubject != null) {
            subject = authenticatedSubject.getSubject();
        }
        if (subject != null) {
            return subject;
        }
        throw new WSSecurityException("Failed to get subject from UsernameToken.", WSSConstants.FAILURE_AUTH);
    }

    private static AuthenticatedSubject assertId(String string, byte[] byArray, String string2) throws LoginException {
        SimpleCallbackHandler simpleCallbackHandler = new SimpleCallbackHandler(string, byArray);
        return SecurityUtils.getPrincipalAuthenticator(string2).authenticate((CallbackHandler)simpleCallbackHandler);
    }

    private static AuthenticatedSubject assertId(UsernameToken usernameToken, String string) throws LoginException {
        return SecurityUtils.getPrincipalAuthenticator(string).assertIdentity("wsse:PasswordDigest", (Object)usernameToken);
    }

    private static PrincipalAuthenticator getPrincipalAuthenticator(String string) {
        PrincipalAuthenticator principalAuthenticator;
        if (string == null) {
            string = "weblogicDEFAULT";
        }
        if ((principalAuthenticator = (PrincipalAuthenticator)AUTHENTICATORS.get(string)) == null) {
            principalAuthenticator = (PrincipalAuthenticator)SecurityServiceManager.getSecurityService((AuthenticatedSubject)SecurityUtils.getKernelID(), (String)string, (SecurityService.ServiceType)SecurityService.ServiceType.AUTHENTICATION);
            AUTHENTICATORS.put(string, principalAuthenticator);
        }
        return principalAuthenticator;
    }

    private static AuthenticatedSubject getKernelID() {
        return KERNEL_ID;
    }

    public static boolean isTokenTypeSupported(String string) {
        return SecurityUtils.getPrincipalAuthenticator(null).isTokenTypeSupported(string);
    }

    public static boolean isPasswordDigestSupported() {
        return SecurityUtils.isTokenTypeSupported("wsse:PasswordDigest");
    }

    public static boolean isX509Supported() {
        return SecurityUtils.isTokenTypeSupported("X.509");
    }

    public static boolean isSAMLTokenSupported() {
        return SecurityUtils.isTokenTypeSupported("SAML.Assertion.DOM");
    }
}

