/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.wss;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weblogic.wsee.security.saml.SAMLUtils;
import weblogic.xml.crypto.api.MarshalException;
import weblogic.xml.crypto.common.keyinfo.KeySelectorResultImpl;
import weblogic.xml.crypto.dsig.ReferenceUtils;
import weblogic.xml.crypto.dsig.XMLSignatureImpl;
import weblogic.xml.crypto.dsig.api.DigestMethod;
import weblogic.xml.crypto.dsig.api.Reference;
import weblogic.xml.crypto.dsig.api.SignedInfo;
import weblogic.xml.crypto.dsig.api.Transform;
import weblogic.xml.crypto.dsig.api.XMLSignature;
import weblogic.xml.crypto.dsig.api.XMLSignatureException;
import weblogic.xml.crypto.dsig.api.XMLSignatureFactory;
import weblogic.xml.crypto.dsig.api.XMLValidateContext;
import weblogic.xml.crypto.encrypt.api.EncryptedData;
import weblogic.xml.crypto.encrypt.api.EncryptionMethod;
import weblogic.xml.crypto.encrypt.api.TBE;
import weblogic.xml.crypto.encrypt.api.XMLEncryptionException;
import weblogic.xml.crypto.encrypt.api.XMLEncryptionFactory;
import weblogic.xml.crypto.encrypt.api.dom.DOMTBEXML;
import weblogic.xml.crypto.utils.DOMUtils;
import weblogic.xml.crypto.wss.Encryption;
import weblogic.xml.crypto.wss.STRTransform;
import weblogic.xml.crypto.wss.SecurityTokenContextHandler;
import weblogic.xml.crypto.wss.SecurityTokenValidateResult;
import weblogic.xml.crypto.wss.SecurityValidator;
import weblogic.xml.crypto.wss.TimestampHandler;
import weblogic.xml.crypto.wss.WSSConstants;
import weblogic.xml.crypto.wss.WSSecurityContext;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss.api.BinarySecurityToken;
import weblogic.xml.crypto.wss.api.Timestamp;
import weblogic.xml.crypto.wss.provider.Purpose;
import weblogic.xml.crypto.wss.provider.SecurityToken;
import weblogic.xml.crypto.wss.provider.SecurityTokenHandler;
import weblogic.xml.crypto.wss.provider.SecurityTokenReference;
import weblogic.xml.crypto.wss11.internal.enckey.EncryptedKeyToken;

public class SecurityValidatorImpl
implements SecurityValidator {
    protected WSSecurityContext securityCtx;

    public SecurityValidatorImpl(WSSecurityContext wSSecurityContext) {
        this.securityCtx = wSSecurityContext;
    }

    public XMLSignatureFactory getXMLSignatureFactory() {
        return this.securityCtx.getSignatureFactory();
    }

    public XMLEncryptionFactory getXMLEncryptionFactory() {
        return this.securityCtx.getEncryptionFactory();
    }

    public String getUri(Element element) throws WSSecurityException {
        String string = DOMUtils.getExistingId(element, this.securityCtx.getIdQNames());
        if (string == null || string.length() == 0) {
            if (element.isSameNode(element.getOwnerDocument().getDocumentElement())) {
                return "";
            }
            throw new WSSecurityException("No id attribute on element " + element.getNamespaceURI() + ":" + element.getLocalName(), WSSConstants.FAILURE_INVALID);
        }
        return "#" + string;
    }

    public Reference getReference(Element element, DigestMethod digestMethod, List list) throws WSSecurityException, MarshalException {
        String string = null;
        SecurityToken securityToken = this.securityCtx.getToken(element);
        if (securityToken != null) {
            return this.getReference(securityToken, digestMethod, ReferenceUtils.getTransforms(list), true);
        }
        string = this.getUri(element);
        return this.getReference(string, digestMethod, ReferenceUtils.getTransforms(list));
    }

    public Reference getReference(String string, String string2, Node node, DigestMethod digestMethod, List list) throws WSSecurityException {
        return this.getReference(string, string2, node, digestMethod, list, true);
    }

    public Reference getReference(String string, String string2, Node node, DigestMethod digestMethod, List list, boolean bl) throws WSSecurityException {
        SecurityTokenContextHandler securityTokenContextHandler = new SecurityTokenContextHandler();
        securityTokenContextHandler.addContextElement("weblogic.xml.crypto.wss.policy.Claims", node);
        securityTokenContextHandler.addContextElement("com.bea.contextelement.xml.SecurityInfo", this.securityCtx);
        SecurityTokenHandler securityTokenHandler = this.securityCtx.getRequiredTokenHandler(string);
        SecurityToken securityToken = null;
        List list2 = this.getEquivalentSecurityTokens(string);
        if ((list2 == null || list2.size() == 0) && ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509PKIPathv1".equals(string) || "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#PKCS7".equals(string))) {
            list2 = this.securityCtx.getSecurityTokens("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3");
            list2.addAll(this.securityCtx.getSecurityTokens("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v1"));
        }
        for (SecurityToken securityToken2 : list2) {
            Node node2 = this.securityCtx.getNode(securityToken2);
            List list3 = this.securityCtx.getSignatures(securityToken2);
            if (list3 == null || list3.size() <= 0 || !securityTokenHandler.matches(securityToken2, string, string2, securityTokenContextHandler, Purpose.VERIFY)) continue;
            securityToken = securityToken2;
            break;
        }
        if (securityToken == null) {
            throw new WSSecurityException("Failed to create Reference for token of type " + string + ", token handler did not return a token for claims " + node, WSSConstants.FAILURE_INVALID);
        }
        return this.getReference(securityToken, digestMethod, list, bl);
    }

    public Reference getReference(SecurityToken securityToken, DigestMethod digestMethod, List list, boolean bl) {
        Object object;
        String string = null;
        String string2 = securityToken.getId();
        String string3 = securityToken.getValueType();
        boolean bl2 = string3 != null && (string3.startsWith("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile") || string3.startsWith("http://docs.oasis-open.org/wss/2004/01/oasis-2004-01-saml-token-profile"));
        boolean bl3 = false;
        Object object2 = this.securityCtx.getSTR(securityToken);
        if (bl && string2 != null && (!bl2 || object2 == null)) {
            string = this.getUri(string2);
        } else {
            bl3 = true;
            if (object2 == null) {
                return null;
            }
            object = null;
            if (object2 instanceof String) {
                object = (String)object2;
            } else if (object2 instanceof SecurityTokenReference) {
                object = this.getSTRId((SecurityTokenReference)object2);
            }
            string = this.getUri((String)object);
            list.add(0, STRTransform.getInstance());
        }
        object = this.getReference(string, digestMethod, list);
        if (bl2 && bl3 && bl && string2 != null) {
            string = this.getUri(string2);
            list.remove(0);
            object = new CombinedReference((Reference)object, this.getReference(string, digestMethod, list));
        }
        return object;
    }

    public Reference getReference(String string, DigestMethod digestMethod, List list, boolean bl) {
        String string2 = null;
        if (bl && string != null) {
            string2 = this.getUri(string);
        }
        return this.getReference(string2, digestMethod, list);
    }

    private Reference getReference(String string, DigestMethod digestMethod, List list) {
        List list2 = ReferenceUtils.getTransforms(list);
        return this.getXMLSignatureFactory().newReference(string, digestMethod, list2, null, null);
    }

    public boolean validateTimestamp(short s) throws WSSecurityException {
        Timestamp timestamp = this.securityCtx.getTimestamp();
        if (timestamp != null) {
            TimestampHandler timestampHandler = this.securityCtx.getTimestampHandler();
            timestampHandler.validate(timestamp, s);
            return true;
        }
        return false;
    }

    public boolean validateSecurityToken(String string, String string2, Node node) throws WSSecurityException {
        return this.validateSecurityToken(string, string2, node, Purpose.IDENTITY);
    }

    private boolean validateSecurityToken(String string, String string2, Node node, Purpose purpose) throws WSSecurityException {
        List list = this.securityCtx.getSecurityTokens();
        for (SecurityToken securityToken : list) {
            if (!this.validateSecurityToken(securityToken, string, string2, node, purpose) || !this.validateIncludedInMessage(securityToken)) continue;
            this.securityCtx.addIdToken(securityToken);
            return true;
        }
        return false;
    }

    protected boolean validateSecurityToken(SecurityToken securityToken, String string, String string2, Node node, Purpose purpose) throws WSSecurityException {
        SecurityTokenValidateResult securityTokenValidateResult;
        BinarySecurityToken binarySecurityToken;
        if (!this.isEquivalentTokenType(securityToken.getValueType(), string)) {
            return false;
        }
        SecurityTokenHandler securityTokenHandler = this.securityCtx.getRequiredTokenHandler(string);
        SecurityTokenContextHandler securityTokenContextHandler = new SecurityTokenContextHandler(node, this.securityCtx);
        if (securityToken instanceof BinarySecurityToken && !(binarySecurityToken = (BinarySecurityToken)securityToken).isValidated() && !(securityTokenValidateResult = securityTokenHandler.validateProcessed(securityToken, this.securityCtx.getMessageContext())).status()) {
            return false;
        }
        return securityTokenHandler.matches(securityToken, securityToken.getValueType(), string2, securityTokenContextHandler, purpose);
    }

    protected boolean validateIncludedInMessage(SecurityToken securityToken) {
        Object object = this.securityCtx.getProperty("weblogic.xml.crypto.wss.SecurityValidator.securityTokenIncludedInMessage");
        boolean bl = true;
        if (!(object instanceof Boolean)) {
            return true;
        }
        bl = (Boolean)object;
        if (securityToken instanceof EncryptedKeyToken) {
            return true;
        }
        return bl && null != this.securityCtx.getNode(securityToken) || !bl && null == this.securityCtx.getNode(securityToken);
    }

    private boolean isSameKindOfX509ValueType(String string, String string2) {
        if (null == string || null == string2) {
            return false;
        }
        int n = string.indexOf("#");
        int n2 = string2.indexOf("#");
        if (n != -1 && n2 != -1 && string.endsWith("#EncryptedKey") && string2.endsWith("#X509v3")) {
            return true;
        }
        if (n == -1 || n2 == -1 || n != n2 || string.length() < n + 6) {
            return false;
        }
        return string.substring(0, n - 1).equals(string2.substring(0, n2 - 1)) && string.indexOf("x509-token") != -1 && "#X509".equals(string.substring(n, n + 5));
    }

    public boolean validateSignature(SignedInfo signedInfo, String string, String string2, Node node) throws WSSecurityException {
        List list = this.securityCtx.getSignatures();
        for (XMLSignature xMLSignature : list) {
            XMLSignatureImpl xMLSignatureImpl = (XMLSignatureImpl)xMLSignature;
            KeySelectorResultImpl keySelectorResultImpl = (KeySelectorResultImpl)xMLSignatureImpl.getSignatureValidateResult().getKeySelectorResult();
            SecurityToken securityToken = keySelectorResultImpl.getSecurityToken();
            if (!SecurityValidatorImpl.match(xMLSignature.getSignedInfo(), signedInfo) || !this.validateSecurityToken(securityToken, string, string2, node, Purpose.SIGN)) continue;
            return true;
        }
        return false;
    }

    public boolean validateEncryption(List list, EncryptionMethod encryptionMethod, EncryptionMethod encryptionMethod2, String string, String string2, Node node) throws WSSecurityException, XMLEncryptionException {
        List list2 = this.securityCtx.getEncryptions();
        for (TBE tBE : list) {
            for (Encryption encryption : list2) {
                EncryptedData encryptedData = encryption.getEncryptedData();
                List list3 = encryption.getNodes();
                KeySelectorResultImpl keySelectorResultImpl = (KeySelectorResultImpl)encryption.getKeySelectorResult();
                if (!encryptedData.getEncryptionMethod().getAlgorithm().equals(encryptionMethod2.getAlgorithm()) || !this.matchNodes(list3, tBE) || !this.validateSecurityToken(keySelectorResultImpl.getSecurityToken(), string, string2, node, Purpose.DECRYPT)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasSecurity() {
        return this.securityCtx.getSecurityElement() != null;
    }

    protected static boolean match(SignedInfo signedInfo, SignedInfo signedInfo2) throws WSSecurityException {
        return signedInfo.getCanonicalizationMethod().getAlgorithm().equals(signedInfo2.getCanonicalizationMethod().getAlgorithm()) && signedInfo.getSignatureMethod().getAlgorithm().equals(signedInfo2.getSignatureMethod().getAlgorithm()) && SecurityValidatorImpl.matchReferences(signedInfo.getReferences(), signedInfo2.getReferences());
    }

    private static boolean matchReferences(List list, List list2) throws WSSecurityException {
        for (int i = 0; i < list2.size(); ++i) {
            boolean bl = false;
            Reference reference = (Reference)list2.get(i);
            for (int j = 0; j < list.size(); ++j) {
                Reference reference2 = (Reference)list.get(j);
                if (!SecurityValidatorImpl.matchReference(reference2, reference)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    protected static boolean matchReference(Reference reference, Reference reference2) throws WSSecurityException {
        if (reference2 instanceof CombinedReference) {
            CombinedReference combinedReference = (CombinedReference)reference2;
            if (!SecurityValidatorImpl.matchReferenceInternal(reference, combinedReference.refOnSTR)) {
                return SecurityValidatorImpl.matchReferenceInternal(reference, combinedReference.refOnToken);
            }
            return true;
        }
        return SecurityValidatorImpl.matchReferenceInternal(reference, reference2);
    }

    private static boolean matchReferenceInternal(Reference reference, Reference reference2) throws WSSecurityException {
        String string = reference.getURI();
        String string2 = reference2.getURI();
        if (string == null || string2 == null) {
            throw new WSSecurityException("Can not validate Reference without URI.", WSSConstants.FAILURE_INVALID);
        }
        return string.equals(string2) && reference.getDigestMethod().getAlgorithm().equals(reference2.getDigestMethod().getAlgorithm()) && SecurityValidatorImpl.matchTransforms(reference.getTransforms(), reference2.getTransforms());
    }

    private static boolean matchTransforms(List list, List list2) {
        if (list.size() == 0 && list2.size() == 1 && ((Transform)list2.get(0)).getAlgorithm().equals("http://www.w3.org/2001/10/xml-exc-c14n#")) {
            return true;
        }
        if (list.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            Transform transform = (Transform)list.get(i);
            Transform transform2 = (Transform)list2.get(i);
            if (transform.getAlgorithm().equals(transform2.getAlgorithm())) continue;
            return false;
        }
        return true;
    }

    protected boolean matchNodes(List list, TBE tBE) {
        if (!(tBE instanceof DOMTBEXML)) {
            return false;
        }
        DOMTBEXML dOMTBEXML = (DOMTBEXML)tBE;
        NodeList nodeList = dOMTBEXML.getNodeList();
        for (int i = 0; i < list.size(); ++i) {
            Node node;
            Node node2 = (Node)list.get(i);
            if (node2 == (node = nodeList.item(i))) continue;
            if (node2 == null || node == null) {
                return false;
            }
            if (this.isEquals(node2.getNamespaceURI(), node.getNamespaceURI()) && this.isEquals(node2.getLocalName(), node.getLocalName())) continue;
            return false;
        }
        return true;
    }

    private boolean isEquals(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        return string.equals(string2);
    }

    private String getUri(String string) {
        return "#" + string;
    }

    private String getSTRId(SecurityTokenReference securityTokenReference) {
        return securityTokenReference.getId();
    }

    private boolean isEquivalentTokenType(String string, String string2) {
        if (string != null && string.equals(string2)) {
            return true;
        }
        if (this.isSameKindOfX509ValueType(string, string2)) {
            return true;
        }
        return SAMLUtils.isEquivalentSamlTokenType(string, string2);
    }

    private List getEquivalentSecurityTokens(String string) {
        ArrayList<SecurityToken> arrayList = new ArrayList<SecurityToken>();
        List list = this.securityCtx.getSecurityTokens();
        for (SecurityToken securityToken : list) {
            if (!this.isEquivalentTokenType(securityToken.getValueType(), string)) continue;
            arrayList.add(securityToken);
        }
        return arrayList;
    }

    private class CombinedReference
    implements Reference {
        public Reference refOnSTR;
        public Reference refOnToken;

        public CombinedReference(Reference reference, Reference reference2) {
            this.refOnSTR = reference;
            this.refOnToken = reference2;
        }

        public DigestMethod getDigestMethod() {
            return this.refOnSTR.getDigestMethod();
        }

        public Reference.DigestValue getDigestValue() {
            return this.refOnSTR.getDigestValue();
        }

        public String getId() {
            return this.refOnSTR.getId();
        }

        public List getTransforms() {
            return this.refOnSTR.getTransforms();
        }

        public Reference.ValidateResult validate(XMLValidateContext xMLValidateContext) throws XMLSignatureException {
            return this.refOnSTR.validate(xMLValidateContext);
        }

        public String getType() {
            return this.refOnSTR.getType();
        }

        public String getURI() {
            return this.refOnSTR.getURI();
        }

        public boolean isFeatureSupported(String string) {
            return this.refOnSTR.isFeatureSupported(string);
        }
    }
}

