/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.wss;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.xml.crypto.utils.DOMUtils;
import weblogic.xml.crypto.wss.WSSConstants;
import weblogic.xml.crypto.wss.api.Timestamp;
import weblogic.xml.dom.marshal.MarshalException;
import weblogic.xml.schema.types.IllegalLexicalValueException;
import weblogic.xml.schema.types.XSDDateTime;

public class TimestampImpl
implements Timestamp {
    private String id;
    private Calendar created;
    private boolean useCreated;
    private String serializedCreated;
    private Calendar expires;
    private int expiresSeconds = 0;
    private String serializedExpires;

    public TimestampImpl() {
    }

    public TimestampImpl(String string, Calendar calendar, Calendar calendar2) {
        this.id = string;
        this.created = calendar;
        this.expires = calendar2;
    }

    public TimestampImpl(String string, boolean bl, int n) {
        this.id = string;
        this.useCreated = bl;
        this.expiresSeconds = n;
    }

    public String getId() {
        return this.id;
    }

    public Calendar getCreated() {
        return this.created;
    }

    public Calendar getExpires() {
        return this.expires;
    }

    public List getContent() {
        return null;
    }

    public void marshal(Element element, Node node, Map map) throws MarshalException {
        String string = (String)map.get("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        Element element2 = DOMUtils.createElement(element, WSSConstants.TIMESTAMP_QNAME, string);
        if (this.id != null) {
            DOMUtils.addPrefixedAttribute(element2, WSSConstants.WSU_ID_QNAME, string, this.id);
        }
        if (this.useCreated) {
            this.createCreated();
        }
        if (this.created != null) {
            this.serializedCreated = this.marshalTime(this.created, element2, WSSConstants.CREATED_QNAME, string);
        }
        if (this.expiresSeconds != 0) {
            this.createExpires();
        }
        if (this.expires != null) {
            this.serializedExpires = this.marshalTime(this.expires, element2, WSSConstants.EXPIRES_QNAME, string);
        }
        if (node != null) {
            element.insertBefore(element2, node);
        } else {
            element.appendChild(element2);
        }
    }

    private String marshalTime(Calendar calendar, Element element, QName qName, String string) {
        String string2 = XSDDateTime.getXml((Calendar)calendar);
        Element element2 = DOMUtils.createAndAddElement(element, qName, string);
        DOMUtils.addText(element2, string2);
        return string2;
    }

    public void unmarshal(Node node) throws MarshalException {
        Element element = (Element)node;
        this.id = DOMUtils.getAttributeValue(element, WSSConstants.WSU_ID_QNAME);
        Element element2 = DOMUtils.getFirstElement(element);
        if (!DOMUtils.is(element2, WSSConstants.CREATED_QNAME)) {
            throw new MarshalException(WSSConstants.CREATED_QNAME + " is required in " + WSSConstants.TIMESTAMP_QNAME);
        }
        this.unmarshalCreated(element2);
        Element element3 = DOMUtils.getNextElement(element2);
        if (DOMUtils.is(element3, WSSConstants.EXPIRES_QNAME)) {
            this.unmarshalExpires(element3);
        }
    }

    private void unmarshalCreated(Element element) throws MarshalException {
        this.serializedCreated = DOMUtils.getText(element);
        if (this.serializedCreated == null) {
            throw new MarshalException("Element " + WSSConstants.CREATED_QNAME + " is empty.");
        }
        this.ensureUTC(this.serializedCreated);
        try {
            this.created = XSDDateTime.convertXml((String)this.serializedCreated);
        }
        catch (IllegalLexicalValueException illegalLexicalValueException) {
            throw new MarshalException("Element " + WSSConstants.CREATED_QNAME + " has invalid value.");
        }
    }

    private void unmarshalExpires(Element element) throws MarshalException {
        this.serializedExpires = DOMUtils.getText(element);
        this.ensureUTC(this.serializedExpires);
        this.expires = XSDDateTime.convertXml((String)this.serializedExpires);
    }

    private void ensureUTC(String string) throws MarshalException {
        if (!(string.endsWith("-00:00") || string.endsWith("+00:00") || string.endsWith("Z"))) {
            throw new MarshalException("xsd:dateTime element does not have required UTC time zone.");
        }
    }

    private void createCreated() {
        this.created = TimestampImpl.getCalendar();
    }

    private void createExpires() {
        this.expires = TimestampImpl.getCalendar();
        if (this.created != null) {
            this.expires.set(1, this.created.get(1));
            this.expires.set(2, this.created.get(2));
            this.expires.set(5, this.created.get(5));
            this.expires.set(10, this.created.get(10));
            this.expires.set(12, this.created.get(12));
            this.expires.set(13, this.created.get(13));
        }
        this.expires.add(13, this.expiresSeconds);
    }

    public static Calendar getCalendar() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        gregorianCalendar.set(14, 0);
        return gregorianCalendar;
    }

    public boolean isFeatureSupported(String string) {
        return false;
    }
}

